#pragma once

#include <mail/so/libs/protect/protect.h>

// Mail header fields
typedef enum {
    HTML_MESSAGE,
    //    HTML_00_10,
    //    HTML_10_20,
    //    HTML_20_30,
    //    HTML_30_40,
    //    HTML_40_50,
    //    HTML_50_60,
    //    HTML_60_70,
    //    HTML_70_80,
    //    HTML_80_90,
    //    HTML_90_100,
    HTML_SHOUTING3,
    HTML_SHOUTING4,
    HTML_SHOUTING5,
    HTML_SHOUTING6,
    HTML_SHOUTING7,
    HTML_SHOUTING8,
    HTML_SHOUTING9,
    HTML_TABLE_THICK_BORDER,
    //    __HTML_CHARSET_FARAWAY,
    HTML_COMMENT_EMAIL,
    HTML_COMMENT_EGP,
    HTML_COMMENT_SKY,
    HTML_COMMENT_8BITS,
    HTML_COMMENT_SAVED_URL,
    HTML_EMBEDS,
    HTML_EVENT,
    HTML_EVENT_UNSAFE,
    HTML_FONT_BIG,
    HTML_FONT_BIG_B,
    //    HTML_FONT_COLOR_NOHASH,
    HTML_FONT_COLOR_UNSAFE,
    HTML_FONT_COLOR_NAME,
    HTML_FONT_COLOR_GRAY,
    HTML_FONT_COLOR_RED,
    HTML_FONT_COLOR_YELLOW,
    HTML_FONT_COLOR_GREEN,
    HTML_FONT_COLOR_CYAN,
    HTML_FONT_COLOR_BLUE,
    HTML_FONT_COLOR_MAGENTA,
    HTML_FONT_COLOR_UNKNOWN,
    HTML_FONT_FACE_BAD,
    HTML_FONT_FACE_ODD,
    //    HTML_FONT_FACE_CAPS,
    HTML_FORM_ACTION_MAILTO,
    HTML_IMAGE_AREA_04,
    HTML_IMAGE_AREA_05,
    HTML_IMAGE_AREA_06,
    HTML_IMAGE_AREA_07,
    HTML_IMAGE_AREA_08,
    HTML_IMAGE_AREA_09,
    HTML_IMAGE_ONLY_02,
    HTML_IMAGE_ONLY_04,
    HTML_IMAGE_ONLY_06,
    HTML_IMAGE_ONLY_08,
    HTML_IMAGE_ONLY_10,
    HTML_IMAGE_ONLY_12,
    HTML_IMAGE_RATIO_02,
    HTML_IMAGE_RATIO_04,
    HTML_IMAGE_RATIO_06,
    HTML_IMAGE_RATIO_08,
    HTML_IMAGE_RATIO_10,
    HTML_IMAGE_RATIO_12,
    HTML_IMAGE_RATIO_14,
    HTML_JAVASCRIPT,
    HTML_LINK_CLICK_HERE,
    HTML_LINK_CLICK_CAPS,
    HTML_RELAYING_FRAME,
    HTML_WEB_BUGS,
    HTML_WIN_BLUR,
    HTML_WIN_FOCUS,
    HTML_WIN_OPEN,
    //    HTML_WITH_BGCOLOR,
    HTML_TAG_BALANCE_A,
    HTML_TAG_BALANCE_FONT,
    HTML_TAG_BALANCE_HTML,
    HTML_TAG_BALANCE_BODY,
    HTML_TAG_BALANCE_HEAD,
    HTML_TAG_BALANCE_TABLE,
    HTML_TAG_EXISTS_BASE,
    HTML_TAG_EXISTS_PARAM,
    HTML_TAG_EXISTS_TBODY,
    HTML_TITLE_EMPTY,
    HTML_TITLE_UNTITLED,
    HTML_LOT_OF_EXCLAMS_4,
    HTML_LOT_OF_EXCLAMS_3,
    HTML_LOT_OF_EXCLAMS_2,
    HTML_LOT_OF_EXCLAMS_1,
    HTML_LOT_OF_EXCLAMS_05,
    HTML_LOT_OF_EXCLAMS_03,
    HTML_LOT_OF_DOTS_4,
    HTML_LOT_OF_DOTS_3,
    HTML_LOT_OF_DOTS_2,
    HTML_LOT_OF_DOTS_1,
    HTML_LOT_OF_DOTS_05,
    QUOTED_EMAIL_TEXT,
    QUOTE_TWICE_1,
    PGP_SIGNATURE,
    HTML_FORGED_TAGS_64,
    HTML_FORGED_TAGS_32,
    HTML_FORGED_TAGS_16,
    HTML_FORGED_TAGS_8,
    HTML_FORGED_TAGS_3,
    HTML_FORGED_TAGS_0,
    HTML_IMAGE_SRC,
    XML_INCLUDED,
    PGP_MESSAGE,
    HTML_CENTER,
    HTML_REPLACE_4,
    HTML_REPLACE_3,
    HTML_REPLACE_2,
    HTML_REPLACE_1,
    HTML_REPLACE_05,
    HTML_REPLACE_03,
    HTML_LOT_OF_BREAK,
    TRACKER_ID,
    __MIME_HTML,
    __TAG_EXISTS_BODY,
    __TAG_EXISTS_HEAD,
    __TAG_EXISTS_HTML,
    __TAG_EXISTS_META,
    __TAG_EXISTS_TITLE,
    __TAG_COUNT_10,
    __TAG_COUNT_20,
    __TAG_COUNT_50,
    __TAG_COUNT_BIG,
    __RAW_BODY_SIZE_05,
    __RAW_BODY_SIZE_1,
    __RAW_BODY_SIZE_2,
    __RAW_BODY_SIZE_5,
    __RAW_BODY_SIZE_10,
    __RAW_BODY_SIZE_20,
    __RAW_BODY_SIZE_50,
    __RAW_BODY_SIZE_BIG,

    SP_BAN_HOST,
    SP_BAN_MAIL,
    SP_BAN_ICQ,
    SP_BAN_PHONE,

    __LV_TIME

} TSpHtmlRules;

typedef struct _THtmlRuleName {
    TSpHtmlRules rid;
    const char* name;
} THtmlRuleName;

// Property descriptions
static const auto html_rules = MakeTrueConstArray(
    THtmlRuleName{HTML_MESSAGE, "HTML_MESSAGE"},
    //    THtmlRuleName{ HTML_00_10,            "HTML_00_10" },
    //    THtmlRuleName{ HTML_10_20,            "HTML_10_20" },
    //    THtmlRuleName{ HTML_20_30,            "HTML_20_30" },
    //    THtmlRuleName{ HTML_30_40,            "HTML_30_40" },
    //    THtmlRuleName{ HTML_40_50,            "HTML_40_50" },
    //    THtmlRuleName{ HTML_50_60,            "HTML_50_60" },
    //    THtmlRuleName{ HTML_60_70,            "HTML_60_70" },
    //    THtmlRuleName{ HTML_70_80,            "HTML_70_80" },
    //    THtmlRuleName{ HTML_80_90,            "HTML_80_90" },
    //    THtmlRuleName{ HTML_90_100,            "HTML_90_100" },
    THtmlRuleName{HTML_SHOUTING3, "HTML_SHOUTING3"},
    THtmlRuleName{HTML_SHOUTING4, "HTML_SHOUTING4"},
    THtmlRuleName{HTML_SHOUTING5, "HTML_SHOUTING5"},
    THtmlRuleName{HTML_SHOUTING6, "HTML_SHOUTING6"},
    THtmlRuleName{HTML_SHOUTING7, "HTML_SHOUTING7"},
    THtmlRuleName{HTML_SHOUTING8, "HTML_SHOUTING8"},
    THtmlRuleName{HTML_SHOUTING9, "HTML_SHOUTING9"},
    THtmlRuleName{HTML_TABLE_THICK_BORDER, "HTML_TABLE_THICK_BORDER"},
    //    THtmlRuleName{ __HTML_CHARSET_FARAWAY,    "__HTML_CHARSET_FARAWAY" },
    THtmlRuleName{HTML_COMMENT_EMAIL, "HTML_COMMENT_EMAIL"},
    THtmlRuleName{HTML_COMMENT_EGP, "HTML_COMMENT_EGP"},
    THtmlRuleName{HTML_COMMENT_SKY, "HTML_COMMENT_SKY"},
    THtmlRuleName{HTML_COMMENT_8BITS, "HTML_COMMENT_8BITS"},
    THtmlRuleName{HTML_COMMENT_SAVED_URL, "HTML_COMMENT_SAVED_URL"},
    THtmlRuleName{HTML_EMBEDS, "HTML_EMBEDS"},
    THtmlRuleName{HTML_EVENT, "HTML_EVENT"},
    THtmlRuleName{HTML_EVENT_UNSAFE, "HTML_EVENT_UNSAFE"},
    THtmlRuleName{HTML_FONT_BIG, "HTML_FONT_BIG"},
    THtmlRuleName{HTML_FONT_BIG_B, "HTML_FONT_BIG_B"},
    //    THtmlRuleName{ HTML_FONT_COLOR_NOHASH,    "HTML_FONT_COLOR_NOHASH" },
    THtmlRuleName{HTML_FONT_COLOR_UNSAFE, "HTML_FONT_COLOR_UNSAFE"},
    THtmlRuleName{HTML_FONT_COLOR_NAME, "HTML_FONT_COLOR_NAME"},
    THtmlRuleName{HTML_FONT_COLOR_GRAY, "HTML_FONT_COLOR_GRAY"},
    THtmlRuleName{HTML_FONT_COLOR_RED, "HTML_FONT_COLOR_RED"},
    THtmlRuleName{HTML_FONT_COLOR_YELLOW, "HTML_FONT_COLOR_YELLOW"},
    THtmlRuleName{HTML_FONT_COLOR_GREEN, "HTML_FONT_COLOR_GREEN"},
    THtmlRuleName{HTML_FONT_COLOR_CYAN, "HTML_FONT_COLOR_CYAN"},
    THtmlRuleName{HTML_FONT_COLOR_BLUE, "HTML_FONT_COLOR_BLUE"},
    THtmlRuleName{HTML_FONT_COLOR_MAGENTA, "HTML_FONT_COLOR_MAGENTA"},
    THtmlRuleName{HTML_FONT_COLOR_UNKNOWN, "HTML_FONT_COLOR_UNKNOWN"},
    THtmlRuleName{HTML_FONT_FACE_BAD, "HTML_FONT_FACE_BAD"},
    THtmlRuleName{HTML_FONT_FACE_ODD, "HTML_FONT_FACE_ODD"},
    //    THtmlRuleName{ HTML_FONT_FACE_CAPS,        "HTML_FONT_FACE_CAPS"   },
    THtmlRuleName{HTML_FORM_ACTION_MAILTO, "HTML_FORM_ACTION_MAILTO"},
    THtmlRuleName{HTML_IMAGE_AREA_04, "HTML_IMAGE_AREA_04"},
    THtmlRuleName{HTML_IMAGE_AREA_05, "HTML_IMAGE_AREA_05"},
    THtmlRuleName{HTML_IMAGE_AREA_06, "HTML_IMAGE_AREA_06"},
    THtmlRuleName{HTML_IMAGE_AREA_07, "HTML_IMAGE_AREA_07"},
    THtmlRuleName{HTML_IMAGE_AREA_08, "HTML_IMAGE_AREA_08"},
    THtmlRuleName{HTML_IMAGE_AREA_09, "HTML_IMAGE_AREA_09"},
    THtmlRuleName{HTML_IMAGE_ONLY_02, "HTML_IMAGE_ONLY_02"},
    THtmlRuleName{HTML_IMAGE_ONLY_04, "HTML_IMAGE_ONLY_04"},
    THtmlRuleName{HTML_IMAGE_ONLY_06, "HTML_IMAGE_ONLY_06"},
    THtmlRuleName{HTML_IMAGE_ONLY_08, "HTML_IMAGE_ONLY_08"},
    THtmlRuleName{HTML_IMAGE_ONLY_10, "HTML_IMAGE_ONLY_10"},
    THtmlRuleName{HTML_IMAGE_ONLY_12, "HTML_IMAGE_ONLY_12"},
    THtmlRuleName{HTML_IMAGE_RATIO_02, "HTML_IMAGE_RATIO_02"},
    THtmlRuleName{HTML_IMAGE_RATIO_04, "HTML_IMAGE_RATIO_04"},
    THtmlRuleName{HTML_IMAGE_RATIO_06, "HTML_IMAGE_RATIO_06"},
    THtmlRuleName{HTML_IMAGE_RATIO_08, "HTML_IMAGE_RATIO_08"},
    THtmlRuleName{HTML_IMAGE_RATIO_10, "HTML_IMAGE_RATIO_10"},
    THtmlRuleName{HTML_IMAGE_RATIO_12, "HTML_IMAGE_RATIO_12"},
    THtmlRuleName{HTML_IMAGE_RATIO_14, "HTML_IMAGE_RATIO_14"},
    THtmlRuleName{HTML_JAVASCRIPT, "HTML_JAVASCRIPT"},
    THtmlRuleName{HTML_LINK_CLICK_HERE, "HTML_LINK_CLICK_HERE"},
    THtmlRuleName{HTML_LINK_CLICK_CAPS, "HTML_LINK_CLICK_CAPS"},
    THtmlRuleName{HTML_RELAYING_FRAME, "HTML_RELAYING_FRAME"},
    THtmlRuleName{HTML_WEB_BUGS, "HTML_WEB_BUGS"},
    THtmlRuleName{HTML_WIN_BLUR, "HTML_WIN_BLUR"},
    THtmlRuleName{HTML_WIN_FOCUS, "HTML_WIN_FOCUS"},
    THtmlRuleName{HTML_WIN_OPEN, "HTML_WIN_OPEN"},
    //    THtmlRuleName{ HTML_WITH_BGCOLOR,        "HTML_WITH_BGCOLOR"     },
    THtmlRuleName{HTML_TAG_BALANCE_A, "HTML_TAG_BALANCE_A"},
    THtmlRuleName{HTML_TAG_BALANCE_FONT, "HTML_TAG_BALANCE_FONT"},
    THtmlRuleName{HTML_TAG_BALANCE_HTML, "HTML_TAG_BALANCE_HTML"},
    THtmlRuleName{HTML_TAG_BALANCE_BODY, "HTML_TAG_BALANCE_BODY"},
    THtmlRuleName{HTML_TAG_BALANCE_HEAD, "HTML_TAG_BALANCE_HEAD"},
    THtmlRuleName{HTML_TAG_BALANCE_TABLE, "HTML_TAG_BALANCE_TABLE"},
    THtmlRuleName{HTML_TAG_EXISTS_BASE, "HTML_TAG_EXISTS_BASE"},
    THtmlRuleName{HTML_TAG_EXISTS_PARAM, "HTML_TAG_EXISTS_PARAM"},
    THtmlRuleName{HTML_TAG_EXISTS_TBODY, "HTML_TAG_EXISTS_TBODY"},
    THtmlRuleName{HTML_TITLE_EMPTY, "HTML_TITLE_EMPTY"},
    THtmlRuleName{HTML_TITLE_UNTITLED, "HTML_TITLE_UNTITLED"},
    THtmlRuleName{HTML_LOT_OF_EXCLAMS_4, "HTML_LOT_OF_EXCLAMS_4"},
    THtmlRuleName{HTML_LOT_OF_EXCLAMS_3, "HTML_LOT_OF_EXCLAMS_3"},
    THtmlRuleName{HTML_LOT_OF_EXCLAMS_2, "HTML_LOT_OF_EXCLAMS_2"},
    THtmlRuleName{HTML_LOT_OF_EXCLAMS_1, "HTML_LOT_OF_EXCLAMS_1"},
    THtmlRuleName{HTML_LOT_OF_EXCLAMS_05, "HTML_LOT_OF_EXCLAMS_05"},
    THtmlRuleName{HTML_LOT_OF_EXCLAMS_03, "HTML_LOT_OF_EXCLAMS_03"},
    THtmlRuleName{HTML_LOT_OF_DOTS_4, "HTML_LOT_OF_EXCLAMS_4"},
    THtmlRuleName{HTML_LOT_OF_DOTS_3, "HTML_LOT_OF_DOTS_3"},
    THtmlRuleName{HTML_LOT_OF_DOTS_2, "HTML_LOT_OF_DOTS_2"},
    THtmlRuleName{HTML_LOT_OF_DOTS_1, "HTML_LOT_OF_DOTS_1"},
    THtmlRuleName{HTML_LOT_OF_DOTS_05, "HTML_LOT_OF_DOTS_05"},
    THtmlRuleName{QUOTED_EMAIL_TEXT, "QUOTED_EMAIL_TEXT"},
    THtmlRuleName{QUOTE_TWICE_1, "QUOTE_TWICE_1"},
    THtmlRuleName{PGP_SIGNATURE, "PGP_SIGNATURE"},
    THtmlRuleName{HTML_FORGED_TAGS_64, "HTML_FORGED_TAGS_64"},
    THtmlRuleName{HTML_FORGED_TAGS_32, "HTML_FORGED_TAGS_32"},
    THtmlRuleName{HTML_FORGED_TAGS_16, "HTML_FORGED_TAGS_16"},
    THtmlRuleName{HTML_FORGED_TAGS_8, "HTML_FORGED_TAGS_8"},
    THtmlRuleName{HTML_FORGED_TAGS_3, "HTML_FORGED_TAGS_3"},
    THtmlRuleName{HTML_FORGED_TAGS_0, "HTML_FORGED_TAGS_0"},
    THtmlRuleName{HTML_IMAGE_SRC, "HTML_IMAGE_SRC"},
    THtmlRuleName{XML_INCLUDED, "XML_INCLUDED"},
    THtmlRuleName{PGP_MESSAGE, "PGP_MESSAGE"},
    THtmlRuleName{HTML_CENTER, "HTML_CENTER"},
    THtmlRuleName{HTML_REPLACE_4, "HTML_REPLACE_4"},
    THtmlRuleName{HTML_REPLACE_3, "HTML_REPLACE_3"},
    THtmlRuleName{HTML_REPLACE_2, "HTML_REPLACE_2"},
    THtmlRuleName{HTML_REPLACE_1, "HTML_REPLACE_1"},
    THtmlRuleName{HTML_REPLACE_05, "HTML_REPLACE_05"},
    THtmlRuleName{HTML_REPLACE_03, "HTML_REPLACE_03"},
    THtmlRuleName{HTML_LOT_OF_BREAK, "HTML_LOT_OF_BREAK"},
    THtmlRuleName{TRACKER_ID, "TRACKER_ID"},
    THtmlRuleName{__MIME_HTML, "__MIME_HTML"},
    THtmlRuleName{__TAG_EXISTS_BODY, "__TAG_EXISTS_BODY"},
    THtmlRuleName{__TAG_EXISTS_HEAD, "__TAG_EXISTS_HEAD"},
    THtmlRuleName{__TAG_EXISTS_HTML, "__TAG_EXISTS_HTML"},
    THtmlRuleName{__TAG_EXISTS_META, "__TAG_EXISTS_META"},
    THtmlRuleName{__TAG_EXISTS_TITLE, "__TAG_EXISTS_TITLE"},
    THtmlRuleName{__TAG_COUNT_10, "__TAG_COUNT_10"},
    THtmlRuleName{__TAG_COUNT_20, "__TAG_COUNT_20"},
    THtmlRuleName{__TAG_COUNT_50, "__TAG_COUNT_50"},
    THtmlRuleName{__TAG_COUNT_BIG, "__TAG_COUNT_BIG"},
    THtmlRuleName{__RAW_BODY_SIZE_05, "__RAW_BODY_SIZE_05"},
    THtmlRuleName{__RAW_BODY_SIZE_1, "__RAW_BODY_SIZE_1"},
    THtmlRuleName{__RAW_BODY_SIZE_2, "__RAW_BODY_SIZE_2"},
    THtmlRuleName{__RAW_BODY_SIZE_5, "__RAW_BODY_SIZE_5"},
    THtmlRuleName{__RAW_BODY_SIZE_10, "__RAW_BODY_SIZE_10"},
    THtmlRuleName{__RAW_BODY_SIZE_20, "__RAW_BODY_SIZE_20"},
    THtmlRuleName{__RAW_BODY_SIZE_50, "__RAW_BODY_SIZE_50"},
    THtmlRuleName{__RAW_BODY_SIZE_BIG, "__RAW_BODY_SIZE_BIG"},
    THtmlRuleName{SP_BAN_HOST, "SP_BAN_HOST"},
    THtmlRuleName{SP_BAN_MAIL, "SP_BAN_MAIL"},
    THtmlRuleName{SP_BAN_ICQ, "SP_BAN_ICQ"},
    THtmlRuleName{SP_BAN_PHONE, "SP_BAN_PHONE"},

    THtmlRuleName{__LV_TIME, "__LV_TIME"}
);

#define HTML_RULE_MAX (TStdArraySize<decltype(html_rules)::value_type>::size)

