#pragma once

//       -*- C++ -*-

#include <util/system/defaults.h>
#include <util/system/file.h>
#include <vector>

#include <contrib/deprecated/mimepp/mimepp/mimepp.h>
#include <util/folder/path.h>
#include "mail/so/spamstop/tools/so-common/ipv6.h"

class ip_match {
public:
    struct matcher_t {
        TIpAddr addr;
        TIpAddr mask;
        TString domains[3];
        bool needs_domain_check;
    };
    typedef std::vector<matcher_t> ips_t;

public:
    bool match(const TIpAddr& ip, const TString& domain = "") const;
    bool match(const TString& val, const TString& domain = "") const;
    void read_file(const TFsPath& fname);
    bool add_mask(const TString& val);

private:
    bool check_domain(const TString* domains, const TString& domain) const;
    ips_t ips;
};

