#pragma once

#include "spstat.h"
#include "spamrule.h"
#include "models.h"
#include "shingles.h"

#include <mail/so/libs/min_hash/min_hash.h>
#include <mail/so/spamstop/tools/knn_data/point.h>
#include <mail/so/spamstop/tools/lsa/data/transfer.h>
#include <mail/so/spamstop/tools/so-clients/activity/tactivityshinglerenv.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/SherlockClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/StatLogClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/UserReputClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/all_clients.h>
#include <mail/so/spamstop/tools/so-clients/sender/tsenderrepenv2.h>
#include <mail/so/spamstop/tools/so-clients/turlstat.h>
#include <mail/so/spamstop/tools/so-common/stats_consumer.h>

#include <library/cpp/dot_product/dot_product.h>
#include <library/cpp/langs/langs.h>
#include <library/cpp/threading/future/future.h>

#include <util/generic/fwd.h>
#include <util/generic/ptr.h>
#include <util/generic/ymath.h>

struct TShAttrs {
    int count = 0;
    bool bPut = false;
    TString Label;
    TString shString;
    bool compl_uniq_spam = false;
    bool compl_uniq_ham = false;
public:
    int Count() const {
        return count;
    };
    void Increment(const TStringBuf& pText, const TStringBuf& psh, bool bPut, int incCounter);
    void SetLabel(TString str);
    const TString& GetLabel() const {
        return Label;
    };
    TString BracketedLabel() const;
    const TString& GetShString() const {
        return shString;
    };
};

struct TRulesContext;
struct TRuleCurrent : NLua::IRule {
    friend struct TRulesContext;
    explicit TRuleCurrent(const TRuleDef& ruleDef, TRulesContext& master) noexcept;

    friend IOutputStream& operator<<(IOutputStream& stream, const TRuleCurrent& rule);

    void Activate() override;

    [[nodiscard]] bool IsActive() const override {
        return fWorked;
    }

    void SetScore(double score) override {
        Score = score;
    }

    [[nodiscard]] double GetScore() const override {
        return Score;
    }

    [[nodiscard]] bool IsSignificant() const {
        return std::abs(Score) > 1e-2;
    }

    [[nodiscard]] const TRuleDef& GetDef() const {
        return ruleDef;
    }

    [[nodiscard]] bool IsCancelled() const {
        return Cancelled;
    }

    NProf::Item& GetProfiler() {
        return Profiler;
    }

    const NProf::Item& GetProfiler() const {
        return Profiler;
    }

    [[nodiscard]] bool GetBfResult() const;

    [[nodiscard]] bool GetArResult() const;

private:
    bool fWorked{};               // Rule was worked
    bool Cancelled{};
    const TRuleDef& ruleDef;
    double Score{};
    TRulesContext& Master;
    NProf::Item Profiler;
    bool Computed{};
};

class TRulesHolder;

struct TScores {
    double Hits{};
    double HitsDlvr{};
};

struct TWordAndLang {
    TWordAndLang(TUtf16String wWord, ELanguage lang) noexcept
        : wWord(std::move(wWord))
        , lang(lang){};
    TUtf16String wWord;
    ELanguage lang;
};

using TRuleCurrentRef = std::reference_wrapper<TRuleCurrent>;
Y_DECLARE_OUT_SPEC(inline, TRuleCurrentRef, stream, val) {
    stream << val.get().GetDef().pRuleName;
}

struct TRulesContext : NLua::IRuleProvider {
    friend struct TRuleCurrent;
    using TRulesRefs = TDeque<TRuleCurrentRef>;
    using TRulesConstRefs = TDeque<std::reference_wrapper<const TRuleCurrent>>;

    void Freeze() { freeze = true; }

    void WorkedRule(TRuleCurrent& rule);
    void WorkedRule(int rid);
    bool IsRuleWorked(const TStringBuf& szRuleName) const;
    bool IsRuleWorked(int rid) const;
    bool SetRule(const TStringBuf& szRuleName);
    void SetRule(int rid);
    void Uncompute(TRuleCurrent& current);
    void UnsetCanceledRules();
    void Recalc();
    TScores CalcScores() const;
    const TRulesRefs& GetCanceledRules() const;
    const TRulesRefs& GetRulesAppearedAfterFreeze() const;
    const TRulesRefs& GetAntiRules() const;
    const TRulesRefs& GetOccuredRules() const;
    const TRuleCurrent& GetRuleCurrent(int rid) const;
    TRuleCurrent& GetRuleCurrentMutable(int rid);

    void CheckExpressions(TRuleCurrent& ruleCurrent, const TRuleCurrent* base);
    void CheckExpressions();

    const TRuleCurrent* FindRule(const TStringBuf& szRuleName) const;

    void SetScore(const TStringBuf& szRuleName, double score);
    double GetScore(const TStringBuf& szRuleName) const;

    const NLua::IRule& Get(const TStringBuf& ruleName) const override;

    NLua::IRule& GetMutable(const TStringBuf& ruleName) override;

    [[nodiscard]] const TVector<TRuleCurrent>& GetRules() const;

    [[nodiscard]] TMaybe<TRuleCurrentRef> GetMostSlowlyRule() const;

    TRulesContext(const TRulesHolder& rulesHolder, TLog logger) noexcept;

private:
    const TRulesHolder& RulesHolder;
    TVector<TRuleCurrent> AllRules;
    TRulesRefs RulesAsAppeared; // list of the occured rules indexes for current message
    TRulesRefs AntiRulesAsAppeared;
    TRulesRefs CanceledRulesAsAppeared;
    TRulesRefs RulesAppearedAfterFreeze;
    bool freeze{};
    TLog Logger;
};

struct TMlLogBuilder : NLua::IKVLogProvider {
    explicit TMlLogBuilder(TString prefix, TLog errorLogger) noexcept
    : Prefix(std::move(prefix))
    , ErrorLogger(std::move(errorLogger)) {}

    friend IOutputStream& operator<<(IOutputStream& stream, const TMlLogBuilder& builder);

    void Add(const TStringBuf& label, TString legacyRepr, NJson::TJsonValue value) {
        JsonLog[label] = std::move(value);
        _Add(label, std::move(legacyRepr));
    }

    void Add(const TStringBuf& label, const TStringBuf& value) {
        Add(label, TString{value}, TString{value});
    }

    void Add(const TStringBuf& label, const TString& value) {
        Add(label, value, value);
    }

    void Add(const TStringBuf& label, const char* value) {
        Add(label, TString{value}, TString{value});
    }

    void Add(const TStringBuf& label, NJson::TJsonValue value) {
        NJsonWriter::TBuf buf;
        buf.WriteJsonValue(&value);
        Add(label, buf.Str(), std::move(value));
    }

    void _Add(const TStringBuf& label, TString str);

    void Log(const TStringBuf &key, const TStringBuf &value) final {
        _Add(key, TString{value});
    }

    const TString Prefix;
    THashMap<TString, TString> Parts;

    NJson::TJsonValue JsonLog;
    TLog ErrorLogger;
};

struct TClassifiersContext {
    TClassifiersContext() = default;
    TClassifiersContext(TVector<TString> rulesNames, IModelApplier::TFeaturesMap features, THashMap<TString, IModelApplier::TFeaturesMap> addons) noexcept
    : RulesNames(std::move(rulesNames))
    , Features(std::move(features))
    , Addons(std::move(addons)) {
        StableSort(RulesNames);
    }

    struct TVecDiff {
        [[nodiscard]] NJson::TJsonValue ToJson() const;
        const TVector<TString> &Left, &Right;
    };

    struct TMapDiff {
        [[nodiscard]] NJson::TJsonValue ToJson() const;
        const IModelApplier::TFeaturesMap &Left, &Right;
    };

    struct TAddonsDiff {
        [[nodiscard]] NJson::TJsonValue ToJson() const;
        const IModelApplier::TFeaturesMap &Features;
        const THashMap<TString, IModelApplier::TFeaturesMap> Addons;
    };

    static NJson::TJsonValue DiffReport(const TClassifiersContext& context1, const TClassifiersContext& context2);

    TVector<TString> RulesNames;
    IModelApplier::TFeaturesMap Features;
    THashMap<TString, IModelApplier::TFeaturesMap> Addons;
};

struct TCurMessageEngine {
    std::pair<bool, TUrlStatistic*> AddShortUrl(const TStringBuf & url);
    std::pair<bool, TUrlStatistic*> AddUrl(const TStringBuf & url, TVector<TString> aliases);
    std::pair<bool, TUrlStatistic*> AddUrl(const TStringBuf & url, TVector<TString> aliases, bool doCount, EUrlStaticticSource code);

    TCurMessageEngine(
            const TRulesHolder& rulesHolder,
            TLog logger,
            TString mlLogPrefix,
            const TStringBuf& messageId,
            double requiredScore,
            double requiredDeliveryScore
    );

    const TInstant Creation = Now();

    TRulesContext rulesContext;

    bool fPutForward{};
    int boxes{};
    int mails{};
    int c_rcpt{};
    int c_rcpt_missmatch{};
    bool fFromDomainReputation{};    // use reputation by domain of address
    bool fSimplifiedReputation{};    // simplified complaints regime - decision on a complaint
    bool fSimplifiedReputationMid{}; // simplified complaints regime for mid - decision on a complaint
    bool fFullFL{};                  // full first line for outgoing mail
    bool fCancelGreyListing{};       // cancel grey listing
    bool fInternalPddMail{};         // sender and recipients have the same domain
    int c_InternalPdd{};
    std::array<ui32, EN_SH_MAX> c_ShAdd{};
    std::array<ui32, EN_SH_MAX> c_ShSpam{};
    std::array<ui32, EN_SH_MAX> c_ShHam{};
    //    ui32  c_ShMalic [EN_SH_MAX];
    bool fUndoMcountByCompl{};
    int cFiledToNames{};
    ui32 c_bounce_perc{};
    bool fHamPersonalCorrect{};
    bool fSpamPersonalCorrect{};
    bool fPersonalFilterUndo{};
    int c_blindTos{};
    int c_blindRcptos{};
    bool fNextPrepareScore{};
    bool bFrmFlag{};
    NSenderReputation::TSenderBitset iSenderReputationFlags;
    int indCheckExpr{};
    ELanguage langCode = LANG_UNK;

    TScores Scores;

    bool YandexTeam{};
    std::array<bool, __FD_COUNT> m_rgCurFieldsExists{};
    std::array<TVector<NJson::TJsonValue>, __FD_COUNT> FieldsValues;

    const TString m_sMessageId;

    TString m_sSoFront;
    TString m_sMailBackend;
    TLogin m_sMailFrom;
    TString m_sMailFromSuid;
    TUid m_sMailFromUID; // UID for outgoing, got from BB
    TString m_sMailFromGeo; // country code for outgoing

    THashSet<TUid> PersonalFilterUids;    // personal filter suids for grey listing
    THashMap<TUid, TSpClass> UidsResolutions;
    THashMap<TString, TSoPersonal> m_mapSuidReputation;

    M_RCPT_ATTRS m_rcptattrs;
    M_RCPT_ATTRS m_original_rcptattrs;

    int m_cHeaders{}; // enveloped messages count
    int m_cFields{};  // header fields count

    std::array<TMaybe<TString>, __FD_COUNT> fieldsById{};

    NLSA::TRequestData lsaRequestData;

    NThreading::TFuture<TMaybe<NFuncClient::TSherlock::TResponse>> SherlockFuture;
    TMaybe<ui64> StableSign;

    NThreading::TFuture<TMaybe<NSoKNN::TGetNeighborsResponse>> KnnFuture;

    NProf::Item reProf;

    THashMap<TString, i32> m_mapCurrentFields;          // header fields of letter
    TStringStream m_sCurrentFields;
    int m_mnModelsIDsSum{};

    const double m_required;
    const double m_delivery_required;
    THashMap<TUid, int> UidsActivities;
    TString m_sPaysenderRule;

    TSpClass m_messclass{};

    THashSet<TString> m_sSO_Class;
    TStringStream m_sSO_Class_Short;


    std::list<TComplaintRequest> m_compllist;
    bool m_isFreemail{};

    NThreading::TFuture<TMaybe<TFromStatRequestList>> CorrectLShingleFuture;

    TMlLogBuilder MlLogBuilder;

    TUrlStatisticVector m_url_reputation_vec;
    THashMap<TString, i32> m_mapurl_reputation;
    THashMap<TString, std::pair<int, int>> m_mapurl_rep_shingle;

    std::vector<TString> m_vsite_netc_cs;
    std::vector<TString> m_vsite_netc;
    std::vector<TString> m_vsite_netcinfo;
    THashMap<std::pair<ui64, TShHttpType>, TShAttrs> m_newsh;
    bool MassShinglerFailed{};

    TString m_shingle36source;

    IModelApplier::TFeaturesMap m_mapValueFactors4Matrixnet;
    THashMap<TString, IModelApplier::TFeaturesMap> m_factorsAddons;

    std::vector<TWordAndLang> letter_dict;
    TString messageId;

    TVector<NMinHash::TInt> MinHash;
    TVector<float> TextEmbed;

    bool IsMailish{};

    NFuncClient::CStatLogClient::TRequest DlvLogRequest;

    THashSet<TString> MailFromAliases;

    std::array<bool, TSpFields::__FD_COUNT> FieldAlreadyFilled{};

    TClassifiersContext ClassifiersContext;

    TMaybe<NGeneralShingler::TPutRequest> ShComplaintRequest;

    TMaybe<NSenderReputation::TGeneralPutInMail> SendersPutRequest;

    TMaybe<NFuncClient::TUrlPutRequest> UrlPutRequest;

    TShingleStatList ShList;

    TVector<ui64> HostsHashes;

    std::function<bool(TSpClass filter_res)> NewPf;

    TSimpleSharedPtr<const NHtmlSanMisc::TAnswer> So2Context;
    TSimpleSharedPtr<const TActivityShingleRequestVector> ActivityInfo;

    TVector<TString> DkimDomains;
    size_t RcptsWithPF{};

    bool BodyTextPresent{};

    TLog Logger;

    TString OcrText;

    TSpClass PrevSpClass;

    TRulesContext::TRulesConstRefs vr_spam, vr_dlv, vr_null;
    TStringStream ActiveComaSeparatedFilteredNullRulesNames;
private:
    THashMap<TString, size_t> UrlRepBackIndex;
};
