#pragma once

#include <utility>

#include "sptop.h"
#include "spamrule.h"
#include "splvexpr.h"

#include <mlp/mail/text_deobfuscator/lib/text_deobfuscator.h>

#include <mail/so/spamstop/tools/so-clients/activity/tactivityshinglerenv.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/all_clients.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/UserReputClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/FreemailShClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/UrlReputationShClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/BBShClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/SpamStatShClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/StatLogClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/RblClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/SherlockClient.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/rbl_producer.h>
#include <mail/so/spamstop/tools/so-clients/freemailhost.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include <mail/so/spamstop/tools/so-common/tparsedlvlog_data.h>
#include <mail/so/spamstop/tools/uids_features_reader/lib/uids_features_reader.h>
#include <mail/so/spamstop/tools/so-common/so_class.h>

#include <util/thread/pool.h>
#include <util/generic/size_literals.h>
#include <util/memory/segmented_string_pool.h>

#include <kernel/matrixnet/mn_dynamic.h>

#include <library/cpp/threading/future/future.h>
#include <library/cpp/vowpalwabbit/vowpal_wabbit_model.h>
#include <mail/so/spamstop/tools/so-clients/sender/tsenderrepenv2.h>
#include <library/cpp/config/config.h>
#include <library/cpp/monlib/metrics/metric_registry.h>

#include <mail/so/spamstop/sp/spstat.h>

#include <mail/so/spamstop/sp/rulesholder.h>

#include <mail/so/spamstop/tools/so-common/thashipv6.h>
#include <mail/so/spamstop/tools/so-common/critrule.h>
#include <mail/so/spamstop/tools/so-common/ares.h>
#include <mail/so/spamstop/tools/pcre_wrapper/pcre_wrapper.h>
#include <mlp/mail/aspam/domen_factors/lib/domen_factors.h>
#include <kernel/dssm_applier/nn_applier/lib/layers.h>
#include "processing_context.h"
#include "spbody.h"
#include "sphtml.h"
#include "spalg.h"

#define IPv4BanRuleWeight        1.0 //11.0
#define IPv4RPTRuleWeight        2.0 //12.0
#define IPv4FRWDRuleWeight       3.0 //13.0
#define IPv4PROBBANRuleWeight    4.0 //14.0
#define IPv4BAN2RuleWeight       5.0 //15.0
#define IPv4BAN7RuleWeight       7.0 //17.0
#define IPv4BAN8RuleWeight       8.0 //18.0

#define IPv6BanRuleWeight        21.0
#define IPv6RPTRuleWeight        22.0
#define IPv6FRWDRuleWeight       23.0
#define IPv6PROBBANRuleWeight    24.0
#define IPv6BAN2RuleWeight       25.0
#define IPv6BAN7RuleWeight       27.0
#define IPv6BAN8RuleWeight       28.0

#define spVersion 4.4
//#define spPackageVersion 3.01

#define SP_HTTP_MAX_SHINGLE_COUNT 256
#define SP_HTTP_MAX_ALONE_SHINGLE_COUNT 10
#define SP_HTTP_MAX_SHINGLE_SIZE 20
#define MAX_LEN 100

typedef enum {
    spHFieldUnknown,
    spHFieldFrom,
    spHFieldTo,
    spHFieldCc,
    spHFieldReplyTo,
    spHFieldSubject
} TSpHeaderFields;

class TSpAlg;
class TSpStat;
class TRengine;
class TSpRuler;
// class TSpListRuler;

#define SP_CURRENT_FIELDS 64


enum TSpShingleType{
    spShingle,
    spCShingle,
    spSanShingle,
    spAttachMd5,
    spFcrc,
};

struct TCurPattern {
    TCurPattern(TShHttpType type, TString shingle, bool fSpBan) : type(type), shingle(std::move(shingle)), fSpBan(fSpBan) {}

    TShHttpType type = EN_SH_UNKNOWN;
    TString shingle;
    bool fSpBan{};
};

struct TCurShingle {
    TShHttpType type = EN_SH_UNKNOWN;
    TString value;
    //    int count;
    ui16 cspam{};
    ui16 cham{};
    bool ftoday_set{};
    bool fhistory_set{};
    bool fSpBan{}; // ban pattern
    bool fSurbl{}; // ban
    bool fWl{};
    bool fGeo{};                // for EN_SH_HOST only (geo and hosting)
    bool compl_empty{};         // there are not complaints on the shingle
    bool compl_inwhitelist{};   // shingle in reputation white list
    ui16 compl_ham{};            // count of complaints on the shingle of type It's Ham
    ui16 compl_spam{};           // count of complaints on the shingle of type It's Spam
    ui16 compl_today_ham{};      // count of complaints today on the shingle of type It's Ham
    ui16 compl_today_spam{};     // count of complaints today on the shingle of type It's Spam
    ui16 compl_yesterday_ham{};  // count of complaints yesterday on the shingle of type It's Ham
    ui16 compl_yesterday_spam{}; // count of complaints yesterday on the shingle of type It's Spam
    float compl_weight{};       // shingle spam or conmpensation weight
};

struct TReputationComplaint {
    bool fset{};
    bool fSignificantSpamComplaint{};
    ui32 firsttime{};
    ui32 lasttime{};
    ui32 complaintham{};
    ui32 complaintspam{};
    ui32 resham{};
    ui32 resspam{};
    ui32 history{}; // 0 - is not spam complaint, 1 - FU SPAM complaint
    ui32 replace_to_ham{};
    ui32 replace_to_spam{};
    bool fUnsubscribe{};
};

typedef struct _TReputationComplaintSet {
    TReputationComplaint From;
    TReputationComplaint FromDomain;
    TReputationComplaint BeenSender;
    TReputationComplaint List;
    TReputationComplaint Subj;
    TReputationComplaint Messid;
    TReputationComplaint Paysender;
    TReputationComplaint Paysender_Nofrom;
} TReputationComplaintSet;



struct TCntShinglerResolution{
    TCntShinglerResolution() noexcept = default;

    ui32 rcpts_today_spam;
    ui32 rcpts_today_ham;
    ui32 rcpts_today_malic;

    ui32 sndr_today;
    ui32 sndr_today_spam;
    ui32 sndr_today_ham;
    ui32 sndr_today_malic;
    ui32 sndr_yesterday;
    ui32 sh14_ham;

    ui32 sndr_domain_today;

    bool set_dsl_first;

    bool fPutBlindRcpto;
};

class TShingleEngine {
private:
    const TRulesHolder & m_pRulesHolder;
    THashMap<TString, TCurPattern> m_mappatsh;
    THashMap<TString, TCurShingle> m_mapsh;
    int count{};
    static const int m_Max_Engine_Shingles = 200;
    static const int str_short_size = 256;

public:
    TDLVShinglesRequestList sh_reputation_list; // ������ �������� ������, ����� �������� ������� � ������� ���������� � TShingleEngine, ��������� � ������

    TShingleEngine(const TRulesHolder& pRulesHolder);
    void Add(const TStringBuf & pattern, const TStringBuf& szshingle, TShHttpType type, bool fBanPattern);
    void AddBanPattern(const char* pattern, TShHttpType type);
    bool SetCountToday(TRengine* m_prengine, TShHttpType type, const char* shingle, ui16 ham, ui16 spam);
    void SetSurbl(TShHttpType type, const char* shingle);
    void SetReputation(bool fWebMail);

    TCurShingle* FindCurShingle(TShHttpType type, const char* shingle);
};


class TYandexLemma;
class TRulesHolder;
struct T_SpParams;

class IRengineHtmlSanAnswerProcessor{
public:
    explicit IRengineHtmlSanAnswerProcessor(TRengine& master) noexcept : Master(master) {}
    virtual ~IRengineHtmlSanAnswerProcessor() = default;
    virtual void Process(const NHtmlSanMisc::TAnswer& answer, CProf& prof) = 0;
protected:
    TRengine& Master;
};

TAppliersMap LoadModels(const TSoConfig& config);

struct TRuleUnistat {
    NMonitoring::TRate* Metric(TSpClass spClass) {
        if(NMonitoring::TRate** metric = MapFindPtr(Metrics, spClass)) {
            return *metric;
        }

        NMonitoring::TLabels labels = NMonitoring::TMetricRegistry::Instance()->CommonLabels();
        labels.Add("sensor", Name);
        labels.Add("resolution", ToString(spClass));
        NMonitoring::TRate* metric = NMonitoring::TMetricRegistry::Instance()->Rate(std::move(labels));

        Metrics.emplace(spClass, metric);

        return metric;
    }

    NUnistat::IHole* Hole(TSpClass spClass) {
        if(NUnistat::IHolePtr* hole = MapFindPtr(Holes, spClass)) {
            return hole->Get();
        }

        TStringBuf spClassSuffix;
        switch(spClass) {
            case TSpClass::UNKNOWN:
            case TSpClass::DLVR:
            case TSpClass::HAM:
                spClassSuffix = "_ham";
                break;
            case TSpClass::SPAM:
                spClassSuffix = "_spam";
                break;
            case TSpClass::MALIC:
                spClassSuffix = "_malic";
                break;
        }
        NUnistat::IHolePtr hole = TUnistat::Instance().DrillFloatHole(TStringBuilder{} << "rule_" << Name << spClassSuffix, "summ", NUnistat::TPriority{0});

        return Holes.emplace(spClass, std::move(hole)).first->second.Get();
    }

    explicit TRuleUnistat(TStringBuf name) : Name(name) {}

private:
    TStringBuf Name;
    THashMap<TSpClass, NUnistat::IHolePtr> Holes;
    THashMap<TSpClass, NMonitoring::TRate*> Metrics;
};

struct TRengineCurlPools {
    explicit TRengineCurlPools(const TSoConfig& pSpTop, const TAtomicSharedPtr<NTvmAuth::TTvmClient> tvmClient = {})
        : StatLogRequester(pSpTop.ClientsConfigs.StatlogConfig ? MakeTrueAtomicShared<NFuncClient::CStatLogClient>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.StatlogConfig).SetTvm(tvmClient)) : TTrueAtomicSharedPtr<NFuncClient::CStatLogClient>{})
        , SpLogggerRequester(pSpTop.ClientsConfigs.SpLoggerConfig ? MakeTrueAtomicShared<NFuncClient::CStatLogClient>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.SpLoggerConfig).SetTvm(tvmClient)) : TTrueAtomicSharedPtr<NFuncClient::CStatLogClient>{})
        , BBRequester(pSpTop.ClientsConfigs.BBConfig ? MakeHolder<NFuncClient::CBB>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.BBConfig).SetTvm(tvmClient)) : nullptr)
        , PassInternalRequester(pSpTop.ClientsConfigs.PassInternalConfig ? MakeTrueAtomicShared<NFuncClient::TPassportClient>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.PassInternalConfig).SetTvm(tvmClient)) : TTrueAtomicSharedPtr<NFuncClient::TPassportClient>{})
        , LSARequester(pSpTop.ClientsConfigs.LSAConfig ? MakeHolder<NFuncClient::TLSA>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.LSAConfig).SetTvm(tvmClient)) : nullptr)
        , UaasRequester(pSpTop.ClientsConfigs.UaasConfig ? MakeHolder<NFuncClient::TUaas>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.UaasConfig).SetTvm(tvmClient)) : nullptr)
        , RblRequester(pSpTop.ClientsConfigs.RblConfig ? MakeHolder<NFuncClient::TRbl>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.RblConfig).SetTvm(tvmClient)) : nullptr)
        , KnnRequester(pSpTop.ClientsConfigs.Knn ? MakeHolder<NFuncClient::TKnn>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.Knn).SetTvm(tvmClient)) : nullptr)
        , CacheRequester(pSpTop.ClientsConfigs.CacheConfig ? MakeHolder<NFuncClient::TCache>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.CacheConfig).SetTvm(tvmClient)) : nullptr)
        , ComplRequester(pSpTop.ClientsConfigs.AbuseConfig ? MakeHolder<NFuncClient::TCompl>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.AbuseConfig).SetTvm(tvmClient)) : nullptr)
        , UserWeightsNgRequester(pSpTop.ClientsConfigs.UserWeightsNgConfig ? MakeHolder<NFuncClient::TUserWeightsRequesterNg>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.UserWeightsNgConfig).SetTvm(tvmClient)) : nullptr)
        , FreeMailRequester(pSpTop.ClientsConfigs.FreeMailReputationConfig ? MakeTrueAtomicShared<NFuncClient::TFreeMail>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.FreeMailReputationConfig).SetTvm(tvmClient)) : TTrueAtomicSharedPtr<NFuncClient::TFreeMail>{})
        , UrlRepRequester(pSpTop.ClientsConfigs.UrlReputationConfig ? MakeHolder<NFuncClient::TUrlReputation>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.UrlReputationConfig).SetTvm(tvmClient)) : nullptr)
        , SenderRepRequester(pSpTop.ClientsConfigs.SenderReputationConfig ? MakeTrueAtomicShared<NFuncClient::TSenderReputationClient>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.SenderReputationConfig).SetTvm(tvmClient)) : TTrueAtomicSharedPtr<NFuncClient::TSenderReputationClient>{})
        , CountRequester(pSpTop.ClientsConfigs.Http2Config ? MakeHolder<NFuncClient::TCountShingler>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.Http2Config).SetTvm(tvmClient)) : nullptr)
        , RblProducerRequester(pSpTop.ClientsConfigs.RblProducerConfig ? MakeHolder<NFuncClient::TRblProducer>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.RblProducerConfig).SetTvm(tvmClient), pSpTop.ClientsConfigs.RblProducerTTL) : nullptr)
        , DkimRequester(pSpTop.ClientsConfigs.DkimUpdaterConfig ? MakeTrueAtomicShared<NFuncClient::TDkimUpdater>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.DkimUpdaterConfig).SetTvm(tvmClient)) : TTrueAtomicSharedPtr<NFuncClient::TDkimUpdater>{})
        , OcrRequester(pSpTop.ClientsConfigs.OcrConfig ? MakeHolder<TRequestClient>(TRequestClient::TArgs(*pSpTop.ClientsConfigs.OcrConfig).SetTvm(tvmClient)) : nullptr) {
    }
    const TTrueAtomicSharedPtr<NFuncClient::CStatLogClient> StatLogRequester;
    const TTrueAtomicSharedPtr<NFuncClient::CStatLogClient> SpLogggerRequester;
    const THolder<NFuncClient::CBB> BBRequester;
    const TTrueAtomicSharedPtr<NFuncClient::TPassportClient> PassInternalRequester;
    const THolder<NFuncClient::TLSA> LSARequester;
    const THolder<NFuncClient::TUaas> UaasRequester;
    const THolder<NFuncClient::TRbl> RblRequester;
    const THolder<NFuncClient::TKnn> KnnRequester;
    const THolder<NFuncClient::TCache> CacheRequester;
    const THolder<NFuncClient::TCompl> ComplRequester;
    const THolder<NFuncClient::TUserWeightsRequesterNg> UserWeightsNgRequester;
    const TTrueAtomicSharedPtr<NFuncClient::TFreeMail> FreeMailRequester;
    const THolder<NFuncClient::TUrlReputation> UrlRepRequester;
    const TTrueAtomicSharedPtr<NFuncClient::TSenderReputationClient> SenderRepRequester;
    const THolder<NFuncClient::TCountShingler> CountRequester;
    const THolder<NFuncClient::TRblProducer> RblProducerRequester;
    const TTrueAtomicSharedPtr<NFuncClient::TDkimUpdater> DkimRequester;
    const THolder<TRequestClient> OcrRequester;
};

class TRengine : public NLua::IShinglerProvider{
    friend class TSpRuler;
    friend class TSherlockProcessor;
    friend class TKnnProcessor;
    friend class TUrlsProcessor;
    friend class TLsaDataProcessor;
    friend class TRulesProcessor;
    friend class TDomenFactorsProcessor;
    friend class TAbookProcessor;
    friend class TPersonalFilterProcessor;
    friend class TSpHtml;
    friend class TUserFeaturesProcessor;
private:
    bool is_spk{};

    const TSoConfig Config;

    IThreadPool & ThreadPool;

    TSpLogger* m_p_ml_logger;

    TLog ShortLog;

    void SetLogger(TSpLogger **ppSpLoggerDst, TSpLogger *pSpLoggerSrc);

    TSpLogger m_null_logger;

    TRWMutex RulesLock;

    TTrueAtomicSharedPtr<TRulesHolder> m_pRulesHolder, RulesHolderIdeal;

    TTrueAtomicSharedPtr<NHyperscan::TScratch> HsScratch, HsScratchIdeal;

    TRWMutex ModelsLock;
    TTrueAtomicSharedPtr<TAppliersMap> Models, ModelsIdeal;

    THolder<TSpHtml> m_html;
    THolder<TSpAlg> m_alg;
    THolder<TSpBodyPart> m_bodypart;

    static constexpr int str_short_size = 256;
    static constexpr int str_large_size = 2_KB;

    TTrueAtomicSharedPtr<TRulesMap> rules, rulesIdeal;
    TTrueAtomicSharedPtr<TLuaRulesMap> LuaRules, LuaRulesIdeal;

    const TTrueAtomicSharedPtr<TRengineCurlPools> Pools;

    static constexpr unsigned m_RcptMax = 300;

    THolder<TShingleEngine> m_shingler{};

    TZoneDetector m_common_zone_detector;

    TFreeMailHosts m_free_mail_hosts;

    TTrueAtomicSharedPtr<NLua::TRunner> LuaRulesRunner, LuaRulesRunnerIdeal;
    TTrueAtomicSharedPtr<NLua::TContext> LuaRulesContext, LuaRulesContextIdeal;

    const TTrueAtomicSharedPtr<NNeuralNetApplier::TModel> Text2VecModel;

    const NUnistat::IHolePtr reTimings = TUnistat::Instance().DrillHistogramHole("re_timings", "hgram", NUnistat::TPriority{0}, xrange(0, 510, 15));
    const NUnistat::IHolePtr mlTimings = TUnistat::Instance().DrillHistogramHole("ml_timings", "hgram", NUnistat::TPriority{0}, xrange(0, 510, 15));
    const NUnistat::IHolePtr KnnDiffs = TUnistat::Instance().DrillFloatHole("knn_diffs", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr SherlockSignDefined = TUnistat::Instance().DrillFloatHole("sherlock_sign_defined", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr BanByWeights = TUnistat::Instance().DrillFloatHole("ban_by_userweights", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr BanByReports = TUnistat::Instance().DrillFloatHole("ban_by_reports", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr UserFeaturesErrors = TUnistat::Instance().DrillFloatHole("user_features_erros", "summ", NUnistat::TPriority{0});
    const NUnistat::IHolePtr MissedModels = TUnistat::Instance().DrillFloatHole("missed_models", "summ", NUnistat::TPriority{0});

    const TTrueAtomicSharedPtr<NTextDeobfuscate::TTextDeobfuscator> TextDeobfuscator;
    const TTrueAtomicSharedPtr<NDomenFactors::TDomenFactorsBuilder> DomenFactorsBuilder;
    const TTrueAtomicSharedPtr<TUidsStats> UidsStats;

    void CheckRulesByfieldsExists();
    void CheckExpressions(int loop);
    TCheckMessageReport Report();
    void Check8Bit(const TStringBuf& fieldname, const TStringBuf& field);
    void CheckCharSet(const TStringBuf& pcharset);
    void TestUuencode(TStringBuf src, IOutputStream& target);
    bool GetUuencode(const TStringBuf& buf, TStringBuf & uuencode);
    void SetTimeForStatLog();
    void SetShingleRule(const char* prefix, ui8 sh_type, char value1, char value2);
    int GetRangeValue(ui32 range[], int count, ui32 value);
    void SetRulePatternRange(TShHttpType sh_type, ui32 ham_inp, ui32 dlv_inp, ui32 spam_inp, int abuseComplHam, int abuseComplSpam);
    void SetRulePattern(TShHttpType sh_type, ui32 ham, ui32 dlv, ui32 spam, ui32 unknown);
    bool SetSURBLRules(int mask);
    void CheckComplList(TComplaintRequestList* compllist, TComplaintRequestList* correct_compllist, TComplaintRequestList* reset_compllist);
    bool CheckReputation();

    void CheckOutmailReputation();

    void ProceedActivity(const TActivityShingleRequestVector& shActList, TStringBuf sFromNormal, TStringBuf sFromDomain);
    bool CheckUrlReputation(bool up);
    void ProcessingAlias(const THashMap<TString, ui8>& aliases, const TString& name, const char* prefix, const char* rule, IOutputStream& stream);
    bool PrepareScore();
    TSpClass CheckComplaints(const TReputationComplaintSet& complaintset, int* criterion);
    void PrintFromStat(TFromStatRequest& fromstatreq, bool bNewShingler = false);
    bool SetComplaint(TComplaintType type, TReputationComplaint* pComplaint, TComplaintRequestListIt cit, bool fMessageSpam, const char* puserId);
    void GetLastComplaints(const TReputationComplaint& Complaint, int& cLastHam, int& cLastSpam) const;
    bool CheckUserId(TReputationComplaintSet& cs, const char* userId, bool fMessageSpam);
    bool SetPersonalresult(TSpClass filter_res, TSpClass filter_res_fromto);
    void PrintNewSenderRepRow(const TString& pfrom, const NSenderReputation::TGetData* getData);
    void PrintNewDomainRepRow(const NSenderReputation::TGetData* getData);
    void PrintNewPaysenderRepRow(const NSenderReputation::TGetData* getData);

    void ProceedSenderReputationInfo(const NSenderReputation::TGetData& senderRepInfo, const TString& pfrom, size_t sndr_today, ui64 sh14_ham);
    NThreading::TFuture<TMaybe<NSenderReputation::TGetData>> GetSenderReputationInfo(const TString& pfrom);
    void PutSenderReputationInfo(bool f_spam);
    TMaybe<NBlackbox2::TKarmaInfo> DiscoverPddAdminKarma(const TString& admin_uid);

    void ProceedFreeMailInfo(const NFreeMail::TEmailInfo& key, const TMaybe<NFreeMail::TInfo>& info, const TMaybe<NFreeMail::TBounceInfo>& bounce);
    static std::pair<TMaybe<NFreeMail::TInfo>, TMaybe<NFreeMail::TBounceInfo>> GetFreeMailInfoGeneral(
            const NFreeMail::TEmailInfo& key,
            TTrueAtomicSharedPtr<NFuncClient::TFreeMail> requester,
            const TLog logger);
    void PutFreeMailInfoGeneral();

    TClassifiersContext MakeClassifiersContext() const;
    void CheckTextClassifier(const TClassifiersContext& context, TString& sMNLabels);
    TString GetMesageTypesCodes(const TShinglesGroupClass& fmData);
    void LogoutUser(TString uid, TString qid);
    void CleanUserKarma(TString uid, TString sPrefix);
    void PrepareDlvlogData(const char* mclass);

    void BayesFillLetterDict(const char* clear_utf8_text, TString langName, ELanguage langCode);

    std::pair<TShingleStatList, TCntComplShingleRequestList> PrepareForHttp2(const TShinglesGroupClass& fmData) const;
    TCntShinglerResolution ProcessCntShinglersResponses(
        const TShingleStatList& shList,
        const TCntComplShingleRequestList& shAbuseList,
        bool fHasBlindRcpto);

    void GetLSA();

    ui32 LangCode2LangBit(ELanguage langCode);
    TString ActivityRow() const;
    NJson::TJsonValue ActivityJson() const;
    TString GeozoneRow() const;
    NJson::TJsonValue GeozoneJson() const;
    TString ExperimentsRow() const;
    void RaiseQuantileRules(std::vector<std::pair<double, ui32>>& vQuantiles, const char* key_label);

public:
    TSpStat m_pstat;

    const TVector<THolder<IRengineHtmlSanAnswerProcessor>> Processors;

    const TUserWeightsPairPtr UsersWeights{};

    ip_match LocalMatcher;

    explicit TRengine(const T_SpParams &p_params,
                      TTrueAtomicSharedPtr<TRulesHolder> RulesHolder,
                      IThreadPool & threadPool,
                      TTrueAtomicSharedPtr<TRengineCurlPools> Pools,
                      kipv6::TStringsLists* rulePrintList = {},
                      ip_match local_matcher = {},
                      TTrueAtomicSharedPtr<TAppliersMap> models = {},
                      TTrueAtomicSharedPtr<NNeuralNetApplier::TModel> text2VecModel = {},
                      TTrueAtomicSharedPtr<NTextDeobfuscate::TTextDeobfuscator> textDeobfuscator = {},
                      TTrueAtomicSharedPtr<NDomenFactors::TDomenFactorsBuilder> domenFactorsBuilder = {},
                      TUserWeightsPairPtr usersWeights = {},
                      TTrueAtomicSharedPtr<TUidsStats> uidsStats = {});


    void ReloadRules(TTrueAtomicSharedPtr<TRulesHolder> rulesHolder);
    void ReloadModels(TTrueAtomicSharedPtr<TAppliersMap> models);
    void ActualizeRules();
    void ActualizeModels();

    bool IsSPK(){ return is_spk; }

    bool InitMessage(
        const TStringBuf& pMessageId,
        TSimpleSharedPtr<const NHtmlSanMisc::TAnswer> so2Context,
        TSimpleSharedPtr<const TActivityShingleRequestVector> activityInfo,
        const TString& ocrText,
        TSpClass prevSpClass,
        TLog logger);
    void EndMessage(const TLog& deliveryLog, const TLog& mlLog) noexcept;
    void InitHeader();
    void CheckField(TStringBuf fieldname, TStringBuf field, TStringBuf pcharset, bool fValid, bool fMime);
    void CheckField(TStringBuf fieldname, TStringBuf field, bool fInternalField = false);
    void CheckField(TSpFields fid, TStringBuf field, bool fCancelSaveListField = false);
    void CheckValueAllRules(TSpFields fid, NJson::TJsonValue value);
    void CheckFieldAllRules(TSpFields fid, const TStringBuf& field);
    void CheckLuaInitMessage();
    void CheckLuaRules();
    void CheckLevensteinRules(TSpFields fid, const char* field, int fieldlen);

    void CheckMessage(NProf::Profiler& profiler, const TStringBuf mes, TCheckedMessage& checkedMessage, const TShinglesGroupClass& fmData = {});

    void ProceedKNNSpamness(const NSoKNN::TGetNeighborsResponse& response);

    TString UnicodeBlocks(const char* pPureText);
    void CheckBody(NProf::Profiler& profiler, const char *pbufbody, size_t bodylen, TSpMesType mestype,
                   TString& pPureText, const char **pPureUtf8Text, TBodyPartProperty *property);
    static TString GetGroupedLanguage(TString sLanguage);
    void CheckBodyPart(const char* pBody, int Len, TBodyPartProperty* prop);
    void CheckQuoted(const TStringBuf& text);
    const char* GetMessageId();
public:
    void SetShingle(TSpShingleType shtype, ui64 shingle);
    void SetShingle(TSpShingleType shtype, const TStringBuf& szshingle);
    const TRuleDef* GetSuperNetRule(ui32 net) const;
    const TRuleDef* GetNetRule(ui32 net) const;
    const TRuleDef* GetIpRule(ui32 ip) const;
    int GetCountHeaders() const {
        return m_cur->m_cHeaders;
    };
    void AddShingle(const TStringBuf& pPattern, TShHttpType shtype, const TStringBuf& pText = nullptr, bool fPutAdd = true,
                    int cnt = 1);
    TString AddPattern(const TStringBuf& str, TShHttpType shtype, bool fPutAdd = true, bool fBanPattern = false, int cnt = 1);
    void AddSiteNetc(const TString& pDomen);
    void CheckRange(const TString& key, int value, bool fPrintWarning = false);
    void CheckRange(const TString& key, ui32 value, bool fPrintWarning = false);
    void CheckRange(const TString& key, ui64 value, bool fPrintWarning = false);
    void CheckRange(const TString& key, double value, bool fPrintWarning = false);

    const TSoConfig& GetSpTop() {
        return Config;
    };
    TSpStat& GetSpStat() {
        return m_pstat;
    };
    TSpHtml* GetSpHtml() {
        return m_html.Get();
    };

    void CheckRcpt(TStringBuf rcpt, TStringBuf originalRcpt);
    void FilterModelsAccordingToUaas();
    void CheckMailFrom(const TString& envfrom);
    void CheckRcptMail(const TString& to);
    void AddPatternIpTo(const TStringBuf& pIpLast);
    int GetMNModelsIdSum() {
        return m_cur->m_mnModelsIDsSum;
    }
    const char* GetSOClassShort() {
        return (m_cur->m_sSO_Class_Short.empty() ? nullptr : m_cur->m_sSO_Class_Short.Str().c_str());
    };
    bool GetGreyListingStatus() const {
        return m_cur->fCancelGreyListing;
    };
    void SetPopperSuid(TStringBuf field);
    void AddShortUrl(const TStringBuf & url);
    void CheckFieldWord(TSpHeaderFields headerfield, const char* pword, int wordlen);

    bool CancelLog();
    void SendFreemailComplaint(const TShinglesGroupClass& fmData);
    static NSenderReputation::TGeneralPutComplaint MakeSenderComplaintRequest(const TShinglesGroupClass& fmData, const TRulesContext& rulesContext);
    void Print2Shortlog(const TString& sMNLabels);
    void IncBlindTo() {
        m_cur->c_blindTos++;
    };
    void IncBlindRcpto() {
        m_cur->c_blindRcptos++;
    };
    const M_RCPT_ATTRS & GetEnvRcptos() const;
    void SetSenderUID(TUid sUID);
    void SetSenderGeo(TStringBuf sGeo);
    void CheckDomain(TStringBuf sdomain, bool bExtractDomain = false);
    void SetShingle36Src(const char* sSrc);
    void SetFrmFlag(bool bFlag);
    void Add2UrlReputationList(TStringBuf domainOrHost, EUrlStaticticSource code);
    bool CheckYaDisk(const TString& answer);
    bool IsRedirect(TString sSrcURL, TString* sInnerUrl);

    TString MNF2String() const;
    NJson::TJsonValue MNF2Json() const;
    int GetRcptCount() {
        return m_cur->c_rcpt;
    };
    void CheckForSameDomains(const TStringBuf& from, const TStringBuf& mfrm);

    void PrepareBodyDataForVw(const TString& body, ELanguage langCode);
    void PrepareSubjDataForVw(const TString& subject);
    void PrepareFromNameDataForVw(const TString& koi8FromName);
    void PrepareFromAddrDataForVw(const TString& asciiFromAddr);

    void CheckIP(const TStringBuf& word);
    void CheckRdns(const TStringBuf& word);
    void CheckGEO(const TStringBuf& word);
    void CheckSuidRoll(const TStringBuf& word) const;

    bool GetPattern(const char* PatternName, const TString &Field, TString& Match);

    void AddStat(TStringBuf fdname, TStringBuf pfield);

    bool IsHTMLText(TString &text);

    void GetWorkedCriterionBanRule(TCritRuleList &critlist) const;     //РІС‹РґРµР»СЏРµРј Р±Р°РЅСЏС‰РёРµ РїСЂР°РІРёР»Р°
    void GetWorkedCriterionRPTRule(TCritRuleList &critlist) const;     //РІС‹РґРµР»СЏРµРј РїСЂР°РІРёР»Р° РѕРїСЂРµРґРµР»РµРЅРёСЏ СЂРµС†РёРґРёРІРёСЃС‚Р°
    void GetWorkedCriterionFRWDRule(TCritRuleList &critlist) const;    //РІС‹РґРµР»СЏРµРј РїСЂР°РІРёР»Р° С„РѕСЂРІР°СЂРґР°
    void GetWorkedCriterionPROBBANRule(TCritRuleList &critlist) const; //РІС‹РґРµР»СЏРµРј РЅРµР±Р°РЅСЏС‰РёРµ РїСЂРѕР±РЅС‹Рµ РїСЂР°РІРёР»Р°
    void GetWorkedCriterionBAN2Rule(TCritRuleList &critlist) const;    //РІС‹РґРµР»СЏРµРј РЅРµР±Р°РЅСЏС‰РёРµ РїСЂР°РІРёР»Р° (РґР°СЋС‚ РєРѕРґ РІРѕР·РІСЂР°С‚Р° Р±Р°РЅР°) - ban2
    void GetWorkedCriterionBAN7Rule(TCritRuleList &critlist) const;    //РІС‹РґРµР»СЏРµРј РЅРµР±Р°РЅСЏС‰РёРµ РїСЂР°РІРёР»Р° (РґР°СЋС‚ РєРѕРґ РІРѕР·РІСЂР°С‚Р° Р±Р°РЅР°) - ban7
    void GetWorkedCriterionBAN8Rule(TCritRuleList &critlist) const;    //РІС‹РґРµР»СЏРµРј РЅРµР±Р°РЅСЏС‰РёРµ РїСЂР°РІРёР»Р° (РґР°СЋС‚ РєРѕРґ РІРѕР·РІСЂР°С‚Р° Р±Р°РЅР°) - ban8

    void GetWorkedCriterionBanRuleIPv6(TCritRuleList &critlist) const;     //РІС‹РґРµР»СЏРµРј Р±Р°РЅСЏС‰РёРµ РїСЂР°РІРёР»Р°
    void GetWorkedCriterionRPTRuleIPv6(TCritRuleList &critlist) const;     //РІС‹РґРµР»СЏРµРј РїСЂР°РІРёР»Р° РѕРїСЂРµРґРµР»РµРЅРёСЏ СЂРµС†РёРґРёРІРёСЃС‚Р°
    void GetWorkedCriterionFRWDRuleIPv6(TCritRuleList &critlist) const;    //РІС‹РґРµР»СЏРµРј РїСЂР°РІРёР»Р° С„РѕСЂРІР°СЂРґР°
    void GetWorkedCriterionPROBBANRuleIPv6(TCritRuleList &critlist) const; //РІС‹РґРµР»СЏРµРј РЅРµР±Р°РЅСЏС‰РёРµ РїСЂРѕР±РЅС‹Рµ РїСЂР°РІРёР»Р°
    void GetWorkedCriterionBAN2RuleIPv6(TCritRuleList &critlist) const;    //РІС‹РґРµР»СЏРµРј РЅРµР±Р°РЅСЏС‰РёРµ РїСЂР°РІРёР»Р° (РґР°СЋС‚ РєРѕРґ РІРѕР·РІСЂР°С‚Р° Р±Р°РЅР°) - ban2
    void GetWorkedCriterionBAN7RuleIPv6(TCritRuleList &critlist) const;    //РІС‹РґРµР»СЏРµРј РЅРµР±Р°РЅСЏС‰РёРµ РїСЂР°РІРёР»Р° (РґР°СЋС‚ РєРѕРґ РІРѕР·РІСЂР°С‚Р° Р±Р°РЅР°) - ban7
    void GetWorkedCriterionBAN8RuleIPv6(TCritRuleList &critlist) const;    //РІС‹РґРµР»СЏРµРј РЅРµР±Р°РЅСЏС‰РёРµ РїСЂР°РІРёР»Р° (РґР°СЋС‚ РєРѕРґ РІРѕР·РІСЂР°С‚Р° Р±Р°РЅР°) - ban8

    TCritRuleList GetWorkedCriterionRule(double weight, const TStringBuf &criterionTag, const TStringBuf &hourTag) const;

    bool ExistsbanInternal(const TStringBuf& rulename) const;                //true - РЅР°С€Р»Рё РїСЂР°РІРёР»Рѕ BAN_INTERNAL, false - РЅРµ РЅР°С€Р»Рё
    bool ExistsRule(char *rulename) const;                             //true - РЅР°С€Р»Рё РїСЂР°РІРёР»Рѕ
    // void CheckSuidRoll(const char *word, int len);//roll РїРѕ suid

    void CheckLongLines(const TStringBuf body);
    void ProcessClearText(CProf& prof, const TString& text);

    void PushRulesSignals();

    void PushRuleSignal(const TRuleDef& ruleDef, TSpClass spClass, int value);

    TString CheckShingle(ui32 shingleType, const TStringBuf& text) final;

    THolder<TCurMessageEngine> m_cur;

    THashMap<const TRuleDef*, TRuleUnistat> rulesUnistats;

    TString queueID;

    kipv6::TStringsLists *RulePrintList{};
};

