
#include <util/generic/yexception.h>
#include "spamrule.h"
#include "setrules.h"
#include "rules.h"

TReDef::TReDef(const TString& src) {
    if(!src)
        return;

    const char* pstr = src.c_str();
    const char* pTemp = src.c_str();
    const char* pPipe = 0;

    int len = TSetRules::GetNextWord(&pstr, 0);

    if (!len)
        ythrow TWithBackTrace<yexception>() << "Regular expr. not defined!" << pstr;

    bool localMatch = true;
    if (!strncmp(pstr, "=~", len))
        localMatch = true;
    else if (!strncmp(pstr, "!~", len))
        localMatch = false;
    else
        ythrow TWithBackTrace<yexception>() << "Regular expr. operator (=~ or !~) not defined: " << pstr;

    len = TSetRules::GetNextWord(&pstr, len);

    if (!len) {
        ythrow TWithBackTrace<yexception>() << "Regular expr. not defined: " << pstr;
    } else while ((pPipe = strstr(pTemp, "||"))) {
            if ((pPipe == pTemp || *(pPipe - 1) != '\\'))
                ythrow TWithBackTrace<yexception>() << "Regular expr. double pipe: " << pstr;
            else
            pTemp = pPipe + 1;
        }

    text = pstr;
    fMatch = localMatch;
}

THsDef::THsDef(TStringBuf text) noexcept : Text(NormalizeRe(TString{StripString(text.After('~'))})) {}
