#pragma once

#include "fields.h"
#include "setlistrule.h"
#include "setrules.h"
#include "spamrule.h"
#include "spruler.h"
#include "sptop.h"

#include <mail/so/libs/protect/protect.h>

#include <library/cpp/tvmauth/client/facade.h>

#include <util/folder/path.h>
#include <util/system/rwlock.h>

#include <array>
#include <utility>

class TSetRules;
class TRulesHolder {
private:
    bool is_spk = false;
    TSpLogger *m_p_daemon_logger;
    TSpLogger *m_p_rules_logger;
    TSpLoggers& m_p_SpLoggers;
public:
    TRulesHolder(bool is_spkA,
                 const TVector<TFsPath>& rulesFolders,
                 TSpLoggers& pSpLoggers,
                 const NRegexp::TSettings& pcreSettings,
                 const TMaybe<TFsPath>& hsRulesCache = {},
                 const TMaybe<TFsPath>& rulesDict = {});

    TSpLogger* GetRulesLogger() { return m_p_rules_logger; };

    void RulesHolderBase(bool is_spkA);

    bool IsOK() const { return rulesLoadedOK == ecOK; };
    unsigned GetCS() const { return rulesCS; };
    bool IsSPK() const { return is_spk; }

    TVector<THolder<TRuleDef>> m_ppRules;     // array of rules
    TVector<std::reference_wrapper<const TRuleDef>> MnfRules;

    THolder<TSpRuler> m_spruler;
    TSpListRuler m_pListRuler;
    THashMap<TSpFields, NHyperscan::TDatabase> HsDbsByField;

    static const TTrueConst<PcreTool> m_pcre;
    static const TTrueConst<PcreTool> m_redir_pcre;

    int m_cRules;             // count of rules

    ui64 rulesCS{};

    NLua::TRunner LuaRulesRunner;

    const TRuleDef *RuleById(int rid) const;
    TRuleDef *RuleById(int rid);
    TRulesType RuleTypeById(int rid) const;

    TString RuleNameById(int rid) const;
    const TVector<std::reference_wrapper<const TRuleDef>>& RulesByField(TSpFields fid) const;


    bool AllRulesFindRid(const TStringBuf& rule, int &rid) const;
    int GetRuleToAntirule(int rid) const;
    const auto& GetFieldsSave() const { return m_rgfFieldsSave; };
    const std::vector<std::reference_wrapper<const TRuleDef>> & GetExprRulesVector() const { return m_vexprrl; };
    const TRuleDef * FindDomainRule(const TStringBuf& domain) const;
    const TRuleDef* FindDeliverySuperNetRule(ui32 net) const;
    const TRuleDef* FindDeliveryNetRule(ui32 net) const;
    const TRuleDef* FindDeliveryIpRule(ui32 ip) const;
    const std::vector<std::pair<TSpFields, int>>& GetFieldExistsVector() const { return vFieldsExists; };
    const std::vector<int>& GetLvRules() const {
        return m_vLvRules;
    };
    const std::vector<TLvKey>& GetLvKeys() const {
        return m_vLvKeys;
    };
    const THashSet<TString>& GetMapBanListSender() const {
        return m_mapBanListSender;
    };
    const THashMap<TString, double> *GetMapBanListHost() const {
        return &m_mapBanListHost;
    };
    const std::vector<TReceivedNum>* GetReceivedNum() const {
        return &m_vReceivedNum;
    };

    void SetAntiRule(int rid);

    [[nodiscard]] const TVector<THolder<TRuleDef>>& GetRules() const {
        return m_ppRules;
    }

    [[nodiscard]] const TVector<std::reference_wrapper<const TRuleDef>>& GetMnfRules() const {
        return MnfRules;
    }

    [[nodiscard]] const THashMap<TString, int>& GetRulesDict() const {
        return RulesDict;
    }

private:
    static THashMap<TString, int> ReadRulesDict(IInputStream &s);

private:
    ecRet rulesLoadedOK;

    THashMap<TString, i32> m_mapAllRules;
    THashMap<TString, TRuleDef*> m_mapDomens;
    THashSet<TString> m_mapBanListSender;             // ban delivery sources list
    THashMap<TString, double> m_mapBanListHost;            // ban delivery hostes list

    THashMap<ui32, TRuleDef*> m_hmDlvrSuperNet;
    THashMap<ui32, TRuleDef*> m_hmDlvrNet;
    THashMap<ui32, TRuleDef*> m_hmDlvrIp;

    TVector<std::reference_wrapper<const TRuleDef>> rulesByField[__FD_COUNT];
    std::array<bool, __FD_COUNT> m_rgfFieldsSave{};         // marked fields must be saved

    std::vector<TLvKey> m_vLvKeys;
    std::vector<int> m_vLvRules;

    std::vector<std::reference_wrapper<const TRuleDef>> m_vexprrl;                 // boolean rules
    std::vector<TReceivedNum> m_vReceivedNum;   // received with number
    std::vector<std::pair<TSpFields, int>> vFieldsExists; // <fid,rid>  - rules by fields existing

    TVector<int> m_pRuleToAntiRule;  // if some rule is antirule contain antirule index else -1

    THashMap<TString, int> RulesDict;
};

struct T_SpParams {
    T_SpParams() = default;
    T_SpParams(TSoConfig pSpTop, TSpLoggers* SpLoggers)
        : pSpTop(std::move(pSpTop))
        , p_spLoggers(SpLoggers) {
    }
    TSoConfig pSpTop;
    TSpLoggers* p_spLoggers;
};
