#pragma once

#include <mail/so/spamstop/tools/so-common/tnetipv6.h>
#include <mail/so/spamstop/tools/so-clients/SperrorHolder.h>
#include <library/cpp/ipmath/range_set.h>
#include "list_types.h"
#include "processing_context.h"
#include "ip_match.h"

typedef std::map<TString, TNetIPv6> M_STROKA_ZONE;

struct TSpListInfo {
    int ind{};       // index в sp_list_names
    int indvrules{}; // index в m_vrules
    TString sKeyword;
    bool fSubject{};   // subject check  -  default fields - List, From and Reply-To only
    bool fMessageId{}; // messageid check
    bool fIgnoreDsl{}; // ignore dsl and not resolved
    TString sValue;  // info for delivery only
    bool fdlv{};       // delivery flag
    bool fipv46{};
    bool fipv46first{};
    bool fMX{}; // mailserver domain and zone
    TString sRulename;
};

struct TSpListValueDlv {
    TSpListValueDlv() = default;
    int indvrules{};   // index в m_vrules
    bool fSubject{};   // subject check  -  default from and reply-to only
    bool fMessageId{}; // messageid check
    bool fFromFieldDomainLabel{}; // from:domain_
    TString sDomainLabel;
    int cIp{};
    int indIp{};
    int cNet{};
    int indNet{};
    int cMask{};
    int indMask{};
    int cRelay{};
    int indRelay{};
    int CheckTrusted{};
    int indTrusted{};
};

struct TSpListName {
    TSpListType id;
    const char* name{};

    TSpListName(TSpListType id, const char * name) noexcept : id(id), name(name) {}
};

typedef enum {
    SP_LIST_DLV_IP,    // ip
    SP_LIST_DLV_NET,   // class C net
    SP_LIST_DLV_RELAY, // relay
    SP_LIST_DLV_FAULT, // fault value
    SP_LIST_DLV_MASK,   // zone matcher
    SP_LIST_DLV_TRUSTED, // zone must be trusted
} TSpListDlvValueType;

struct TRulesContext;

class TSpListRuler {
private:
    bool is_spk{};
    TSpLogger* m_p_sp_logger{};

    std::vector<TSpListInfo> m_vlist_info;
    std::vector<TString> m_vrules;
    int m_crules{};
    THashMap<TString, TVector<int>> m_spmap[SP_LIST_MAX];
    int m_cKeyWords[SP_LIST_MAX]{};
    bool m_fTextWithSpaces{};

    int m_idList{};
    int m_ckeywords{};
    int m_cfilewords{};
    int m_cwordsall{};
    TSpListInfo m_list_info;
    THashMap<TString, TSpListValueDlv> m_map_dlv;
    std::vector<ui32> m_vip_dlv;
    std::vector<ui32> m_vnet_dlv;
    std::vector<ip_match> m_vmask_dlv;
    std::vector<TString> m_vrelay_dlv;
//    TSpListValueDlv m_dlv_value;

    THashMap<TString, THashMap<TString, TIpRangeSet>> m_v_mxs; // rules-domains-zones
    THashMap<TString, TIpRangeSet> mZoneIPV46, mZoneIPV46First;  // rules-zones

//    bool m_fSetValueDlv;

    bool FindWord(const char* word, int len, TSpListType type, const TStringBuf & rule) const;
    bool GetDeliveryValue(const char* pkey, const char* pvalue, TSpListValueDlv* dlv_value);
    static TSpListDlvValueType SetValue(const char* pvalue, int len, ui32* ip, ui32* netc, TString* sZoneRow = nullptr);

public:
    TSpListRuler() = default;
    explicit TSpListRuler(TSpLogger *pSpLoggerA);

    bool IsSPK() const { return is_spk; }
    void Prepare();
    void CheckDomainName(TRulesContext& rulesContext, const TStringBuf & word, TSpListType type, TSpListType type_part) const;
    void CheckDomainNamePart(TRulesContext& rulesContext, const TStringBuf & word, TSpListType type_part) const;
    void CheckIpNet(TRulesContext& rulesContext, const TStringBuf & word, TSpListType type, TSpListType type_part) const;
    bool CheckShingleWl(const char* word, int len) const;
    bool CheckShingleGeo(const char* word, int len) const;
    bool CheckList(const TStringBuf& word, TSpListType type, const TStringBuf& rule_name) const;
    bool CheckWord(TRulesContext& rulesContext, const TStringBuf& word, TSpListType type) const;
    bool CheckListNoRuleSet(const char* word, int len, TSpListType type) const;
    bool CheckListNoRuleSet(const TStringBuf& word, TSpListType type) const;
    const TSpListValueDlv * SetDeliveryDomen(TRulesContext& rulesContext, const TString& pdomen, const bool* fields, bool* fCancelDomainLabel, bool* fBanOrFreem) const;
    bool CheckDeliveryIp(TRulesContext& rulesContext, const TSpListValueDlv& dlvValue, ui32 ip, TStringBuf& pRuleName, TStringBuf& pDomainLabel) const;
    bool CheckDeliveryNet(TRulesContext& rulesContext, const TSpListValueDlv& dlvValue, ui32 net, TStringBuf& pRuleName, TStringBuf& pDomainLabel) const;
    bool CheckDeliveryMask(TRulesContext& rulesContext, const TSpListValueDlv& dlvValue, TIpAddr IP, TStringBuf& pRuleName, TStringBuf& pDomainLabel) const;
    bool CheckDeliveryRelay(TRulesContext& rulesContext, const TSpListValueDlv& dlvValue, TString sRelay, TStringBuf& pRuleName, TStringBuf& pDomainLabel) const;
    bool CheckDeliveryTrusted(TRulesContext& rulesContext, const TSpListValueDlv& dlvValue, TStringBuf& pRuleName, TStringBuf& pDomainLabel) const;
    bool CheckDeliverySpfDkim(TRulesContext& rulesContext, const TSpListValueDlv& dlvValue, TStringBuf& pRuleName, TStringBuf& pDomainLabel, bool dkim, bool spf) const;
    bool CheckPhrase(const char* word, int len, std::vector<const char*>& phraserules) const;
    bool CheckIpv46(TRulesContext& rulesContext, TIpAddr ipa) const;
    bool CheckIpv46(TRulesContext& rulesContext, TKIPv6* ip) const;
    bool CheckIpv46First(TRulesContext& rulesContext, TIpAddr ipa) const;
    bool CheckIpv46First(TRulesContext& rulesContext, TKIPv6* ip) const;
    bool CheckMXZone(TRulesContext& rulesContext, const char* ip_word, const char* mfrom) const;

    void InitFile();
    bool Add(const char* pstr, const char* fn);
    int Size() {
        return m_cfilewords;
    }; // count string in file
    int SizeAll() {
        return m_cwordsall;
    }; // coun all string

    void CheckIp(TRulesContext& rulesContext, const TStringBuf& word) const;
    void CheckRdns(TRulesContext& rulesContext, const TStringBuf& word) const;
    void CheckGEO(TRulesContext& rulesContext, const TStringBuf& word) const;
    void CheckSuidRoll(TRulesContext& rulesContext, const TStringBuf& word) const;
};
