#pragma once

#include <util/folder/path.h>
#include <util/generic/hash_set.h>
#include <util/generic/bt_exception.h>
#include <library/cpp/enumbitset/enumbitset.h>
#include <library/cpp/regex/hyperscan/hyperscan.h>
#include <mail/so/libs/lua_rules/runner.h>
#include "splvexpr.h"
#include "rules_key_words.h"
#include "setlistrule.h"
#include "spamrule.h"
#include "fields.h"
#include "sptypes.h"

#define TokensSize 64
#define MAX_LV_KEYS 6000


enum TRuleReadState{
    STATE_RULE,
    STATE_DLV,
    STATE_ROLL,
    STATE_SRC_BAN,
};


class TRengine;
class TBForm;
class TArForm;
struct TRuleCurrent;

#ifdef SP_FILTER_CLIENTS
class TSpDat;
#endif

struct TRuleDef;
struct TReceivedNum {
    TReceivedNum(const char* szReceived, int rid, TRuleDef& ruleDef) : ruleDef(ruleDef), rid(rid) {
        auto iFirst = 1000;
        if (*szReceived != '+' && *szReceived != '-')
            ythrow TWithBackTrace<yexception>() << "wrong recieved format: cannot parse sign from " << szReceived;
        Direction = *szReceived;

        ++szReceived;
        if (!isdigit(*szReceived))
            ythrow TWithBackTrace<yexception>() << "wrong recieved format: cannot parse iFirst from " << szReceived;
        iFirst = atoi(szReceived);
        iLast = iFirst;

        while (isdigit(*szReceived))
            ++szReceived;

        if (*szReceived == 0)
            return;

        if (*szReceived != '-' && !isdigit(szReceived[1]))
            ythrow TWithBackTrace<yexception>() << "wrong recieved format:  " << szReceived;

        iLast = atoi(szReceived + 1);
    }

    TRuleDef& ruleDef;
    char Direction{}; // + or -
    int iFirst{};
    int iLast{};
    int rid{};
};

struct TRuleRead {
    TString szFileName;
    std::vector<TRuleDef*> vrules{};
};

class TSetRules {
private:
    bool is_spk{};
    ecRet m_ec{};
    TSpLogger* const m_p_filter_logger;
    int m_cRules{};    // count of rules in file
    int m_cFiles{};    // count of rules files
    int m_cRulesAll{}; // count of rules in all
    int m_cBoolFault{};
    int m_cArFault{};
    int m_cSources{};
    int m_cInvalidSources{};
//    SpMapperInt m_mapFields;                  // map field name to field index
    THashMap<TString, std::pair<int, int>> m_mapRules; // map rule id to field index
    TVector<TRuleRead> m_vFileRules;
    std::vector<TRuleDef*> m_vExprRules;

    int m_max_files{};

    THashMap<TString, i32> m_mapLvKeys;

    const char* m_ptokens[TokensSize]{};
    int m_tokenlens[TokensSize]{};

    TString m_szBody;
    TString m_szRegExpr;
    TString m_szReceivedNum;
    TString m_szBExpr;
    TString m_szArithmetic;
    TString m_szField;
    TString m_szComment;
    TString m_szTest;
    TString m_szOption;
    TString m_szKey;
    TString m_szList;
    TString m_szDomen;
    TString m_szRelay;
    TString m_szRange;
    TString m_szScript;
    TKWYasmTagsBitset YasmTags;
    TKWYasmTagsBitset SolomonTags;

    TRuleReadState m_rstate;

    //#^    bool m_fFiltrInfo;
    //Delivery

    bool m_fDeliveryFile{};
    THashSet<TString> unknownFields;
    THashMap<TString, i32> m_mapDomens;

    ui64 m_cs{};

    const NRegexp::TSettings PcreSettings;

    bool PrintBadStrings(const TString& dest);
    void InitStrings();
    TRuleDef* Set(TRulesType rule_type);
    void ReadRulesDir(const TString & fn);
    void Read(IInputStream& fp, const char* fn, const bool fRollFile, const bool fSrsBanList);
    void CheckExpr();
    void SetBf(TRuleDef& prule);
    void SetAr(TRuleDef& prule);
    TRuleDef* GetRule(int iFile, int iRule);
    TSpFields AddField(const TStringBuf & pfield);
    ecRet GetRangeRule(TRuleDef* pCurRule, TRulesType rule_type);
    ecRet GetLevensteinRule(TRuleDef* pCurRule, TRulesType rule_type);
    bool GetAntiRule(TRuleDef* pCurRule, const char* pstr);
    ecRet GetLvRule(TRuleDef* pCurRule);
    ecRet GetKey(TLvDef* plv);
    int GetTokens(const TString& pstr);
    void GetComment(TRuleDef* pCurRule);
    static bool GetScore(TRuleDef* prule, const char* score, int scorelen) ;
    bool CheckSymbols(const char* str, int len);
    ecRet SetRuleName(TRuleDef* pCurRule, const char* pRuleName, int len);
    TRuleDef* GetRuleByName(const char* pRuleName, int len);

public:
    TSetRules(const TVector<TFsPath>& rulesFolders, TSpLogger *pSpFilterLogger, NRegexp::TSettings pcreSettings);
    ecRet IsOk() {
        return m_ec;
    };
    int GetRules(TVector<THolder<TRuleDef>>& ppprules, const TMaybe<TFsPath>& hsRulesCache = {});
    void PrepareHsRules(const TMaybe<TFsPath>& hsRulesCache = {});
    static size_t GetFirstWord(const char** pstr, size_t offset);
    static int GetNextWord(const char** pstr, int len);
    static bool GetNextInt(const char** ppstr, int len, int* pval);
    static bool GetNextDouble(const char** ppstr, int len, double* pval);
    static void SkipSpaces(const char** ppstr);
    static bool IsWordSym(char ch);
    static void SkipWord(const char** ppstr);
    static bool End_Of_Str(char ch);
    static bool GetDataVersion(const char* szLine, float* pVersion, TSpLogger *pLogger);
    ui64 GetCs() const { return m_cs; }


    THashSet<TString> m_pmapBanListSender;  // ban delivery sources list
    THashMap<TString, double> m_pmapBanListHost; // ban delivery hostes list
    std::vector<TLvKey> m_pvLvKeys;
    std::array<bool, __FD_COUNT> m_pfFieldsSave{}; /* [FD_MAX_COUNT]; */ //  marked fields  must be saved

    TSpListRuler m_listRuler;

    THashMap<TSpFields, NHyperscan::TDatabase> HsDbsByField;

    NLua::TRunner LuaRulesRunner;
};
