#pragma once

#include "sptypes.h"
#include "mail/so/spamstop/tools/so-common/sputil.h"
#include "spamrule.h"

#include <contrib/deprecated/mimepp/mimepp/mimepp.h>

#ifdef SO_WITH_IPV6
#include "context_symbols.h"
#include "rulesholder.h"

#endif

enum TSpMTAType { EN_MTA_UNKNOWN,
    en_MTA_ZMAILER, // default
    en_MTA_SENDMAIL,
    en_MTA_QMAIL,
    en_MTA_CGP,
    en_MTA_POSTFIX,
    en_MTA_EXIM
};

#define MAX_SENDERS 64

class TRengine;
class TSpStat;

typedef struct _TCurRecipients {
#define RecMax 100
#define TOCC_SIMILAR_LENGTH 2
#define TOCC_SIMILAR_LENGTH_2 20

    TString LastAddr;
    char rguser[RecMax][TOCC_SIMILAR_LENGTH];
    char rghost[RecMax][TOCC_SIMILAR_LENGTH];
    char rghost_2[RecMax][TOCC_SIMILAR_LENGTH_2];
    int c;
    bool fSorted;
    void Init() {
        LastAddr.clear();
        c = 0;
        fSorted = true;
    }
} TCurRecipients;

typedef struct _TSiteNetcInfo {
    const char* phost;
    ui32 netc[43];
    int c_netc;
    const char* phost_cs;
    ui32 w_yand;
    int version;
    char host_rcvd[15][16];
    int c_host_rcvd;
    int w_rul;
    int w_dlv;
    int max_shin;
    int max_all;
    bool bl_arr[en_SR_MAX];
} TSiteNetcInfo;

typedef struct _TSpSender {
    bool fSender;        // other  then received:
    bool fDeliveryField; // from, reply-to, list, sender
    bool fRelay;         // received:
    bool fields[en_SR_MAX];
    bool fCoincide;
    int count; // count fields
    int weight_sort;
} TSpSender;

struct TCurMessageAlg {
    TCurMessageAlg() noexcept : curTime(time(nullptr)) {};
    ui32 outlooktime{}; //MSGID_OUTLOOK_TIME
    time_t header_time{};
    time_t received_fetchmail_time{};
    time_t date_diff{};
    time_t date_received{};
    time_t curTime;
    int iReceived{};
    bool mta_check{};
    bool fheader_date{};
    bool fMailingList{};
    bool fMessageId{};
    bool fLaterMta{};
    bool fMessageIdNotUsable{};
    bool fDeliveredTo{};
    bool fGatedThrough{};
    //    bool    fHotmailAddrWithForgedHotmailReceived;
    bool fHotmailAddrButNoHotmailReceived{};
    bool fXOriginatingIp{};
    bool fXOriginatingIpExists{};
    bool fXSenderIp{};
    bool fXLoop{};
    bool fTextType{};
    bool fBase64{};
    bool cReseivedSpf{};
    //  Predefined delivery source
    int indDomenName{};
    bool fFixedSource{};
    bool fShFixedSource{};
    bool fCheckDelivery{};
    bool fDelivery{};
    int level{};
    int sh_level{};
    ui32 rgnet[REC_MAX_LEVEL]{};
    ui32 rgip[REC_MAX_LEVEL]{};
    TSpSender senders[MAX_SENDERS]{};
    int cSenders{};
    bool fForward{};
    bool fUndefinedIp{};
    bool fDomenPrepare{};
    int cMsgDayCount{};
    time_t tBornDate{};
    ui32 karma{};
    ui32 karma_status{};
    int cSubject{};
    int cFrom{};
    int cTo{};
    bool fIpv6{};
    bool fValidIp{};
    bool fMailGmailIMAP{};
};

class TSpAlg {
private:
    bool      is_spk;
    TSpStat& m_pstat;
    const TRulesHolder& m_rulesHolder;

    TCurRecipients m_rec;
    TCurMessageAlg m_cur;
    TCurMessageEngine* m_curMessageContext{};
    std::vector<time_t> m_vReceivedHeaderTimes;
    TString m_sReceived;
    TVector<TString> m_vReceived;
    TString m_rgsReceivedHost[MAX_SENDERS];

    bool m_fWebMail;

    std::array<TString, __FD_COUNT> m_rgpFields;
    bool m_faddprint{};

    //  Predefined delivery source
    //    TDomenCach *m_pdomen_cach;
    THashMap<TString, i32> m_mapSender;
    //    SpMapper <TString> m_mapSiteNetcInfo;
    TString m_sRelay;

    TString m_sIpSender;
    TString m_sIpFirst;
    TString m_sHostFirst;
    TString m_sListAll;

    TString m_sForwardHost;
    TString m_sForwardIp;
    TString m_sDomainLabel;

    const ip_match& local_matcher;

#ifdef SO_WITH_IPV6
    TIpAddr m_ip_addr_first;
    TIpAddr m_ip_addr_last;
#endif

    bool CheckIdByDictionary(char* pid, int len);
    bool CheckSubjectIdLow(const TStringBuf& subject);
    bool CheckSubjectId(const TStringBuf& subject);
    void CheckSubject();
    int FoundReInSubj(const char* szSubject, int ind);
    bool IsSpace(ui8 c) const;
    bool IsSpace(char p) const;
    void CheckMessageId(const TStringBuf& field);
    bool GetDate(const char* field, int fieldlen, time_t* ptime) const;
    static void AssignField(const char* field, int fieldlen, char** pdupfield);
    void InitField(char** pfield);
    void GetHeaderTime();
    bool CheckOutlookTimeStamp();
    bool GatedThroughReceivedHdrRemover();
    bool CheckMessageIdNotUsable() const;
    bool ReceivedWithinMonths(int mon_min, int mon_max) const;
    bool GetTimeReceived(TString& received, time_t* pt_date);
    void GetReceivedHeaderTimes();
    void CheckDateReceived();
    void GetDateDiff();
    bool CheckForShiftedDate(int hh_min, int hh_max);
    void CheckForShiftedDate();
    int DelSpaces(char* szField);
    void DelRepeatedSpaces(TString& szField);
    bool CheckForFromToSame();
    bool CheckForForgedReceivedTrail(int* mismatch_addr);
    void CheckForForgedHotmailReceivedHeaders();
    bool CheckForFakeAolRelayInRcvd();
    bool CheckForForgedEudoraMailReceivedHeaders();
    bool CheckForForgedYahooReceivedHeaders();
    bool CheckForForgedJunoReceivedHeaders();
    bool CheckForForgedGw05ReceivedHeaders();
    void AddAddrToCc(TRengine& rengine, TStringBuf field);
    void CheckRecipients();
    void CheckMtaMessageId();
    bool GetHost(const TStringBuf& pfiled, const TStringBuf& re, const TStringBuf& re_prepare, TString& phost);
    void CheckSender();
    bool CheckReceivedHelos();
    void CheckForToInSubject();
    void SetRule(const TStringBuf& szname);
    //    void CheckMassMail(const char *pfield, int fieldlen);
    void CheckDelivery(TRengine& rengine);
    void CheckReceivedNum();
    void AddSender(TSpFields fid, const TStringBuf& pfield, int Weight);
    bool PutSender(const NRegexp::TResult& res, TSpFields fid, int Weight, bool CheckGeoDomain);
    void AddStat(TSpFields fid, const TStringBuf& pfield);
    void DomenPrepare(TRengine& rengine);
    void GetReceivedFirst(TStringBuf prcvd, TSpMTAType mtaType, TString& ppIp, TString& ppRdns, TString& ppHelo);
    void GetReceivedNext(const TStringBuf& prcvd, TString& ppIp, TString& ppRdns, TString& ppHelo, bool fPrintStat = true);
    bool GetReceivedNext_2(TStringBuf prcvd, TString& ppIp, TString& ppRdns, TString& ppHelo);
    TSpMTAType GetMTAType(const TStringBuf& prcvd);
    bool ParseSiteNetcInfo(TSiteNetcInfo* psni, const char* sitenecinfo);
    bool CheckDomenNameNew(TRengine& rengine, TSiteNetcInfo* sni, const char* pDomen, const char* pDomen_cs, int level, bool fTestTop);
    bool CheckHostReceivedNew(TSiteNetcInfo* sni, int level, const char* domen_level);
    //    void GetBanList();
    static float UnpackYandWeight(ui32 yand_weight);
    bool CheckNewSender(TSpSenderType sendertype, int ind, TSiteNetcInfo* sni);
    void CheckBornDate(const TStringBuf& field);
    int CheckDigitField(const char* fieldkey, const TStringBuf& field);
    void CheckFromSender(TRengine& rengine);
    void SetForwardHost(TStringBuf prcvd, TSpMTAType mtaType);

    struct TDomains {
        using TSpf = TString;
        using TDKim = TString;
        TSpf Spf;
        TDKim Dkim;
    };
    TDomains CheckAuthDomains() const;

public:
    TSpAlg(const TRulesHolder& rulesHolder, const TSoConfig& spTop, TSpStat& pstat, const ip_match& local_matcher, TCurMessageEngine* curMessageContext);
    void CheckMessage(TRengine& rengine);
    void SetField(TSpFields fid, const TStringBuf& field, int FieldNumber, bool fSaveListField, TRengine& rengine);
    bool IsFixedSource() const;
    void AddSiteNetcInfo(TRengine& rengine, const char* pDomen, const char* pDomencs, const char* sitenecinfo);
    void CompareFixMethods();
    void WriteDeliveryStat(bool UseShingler);
    bool CheckAddrInReceived();
    const TString& GetFromAddr() const {
        return m_rgpFields[FD_FROM_ADDR];
    };
    const TString& GetFromDomain() const {
        return m_rgpFields[FD_FROM_DOMAIN];
    };
    const TString& GetFromName() const {
        return m_rgpFields[FD_FROM_NAME];
    };
    const TString& GetToAddr() const {
        return m_rgpFields[FD_TO_ADDR];
    };
    const TString& GetRawSubject() const {
        return m_rgpFields[FD_RAWSUBJECT];
    };
    const TString& GetRealMessageId() const {
        return m_rgpFields[FD_MESSAGE_ID];
    };
    const char* GetMessageId() {
        return m_rgpFields[FD_MESSAGEID].c_str();
    };
    const char* GetPopperSuid() {
        return m_rgpFields[FD_X_YAMAIL_AUTO_REPLY].c_str();
    };
    const char* GetFieldSender() {
        return m_rgpFields[FD_SENDER].c_str();
    };
    const char* GetFieldBeenThere() {
        return m_rgpFields[FD_X_BEENTHERE].c_str();
    };
    const TString& GetFieldList_() const {
        return m_rgpFields[FD_LIST_];
    };
    const TString& GetFieldListPost() const {
        return m_rgpFields[FD_LIST_POST];
    };
    const TString& GetFieldListOwner() const {
        return m_rgpFields[FD_LIST_OWNER];
    };
    const TString& GetFieldListSubscribe() const {
        return m_rgpFields[FD_LIST_SUBSCRIBE];
    };
    const char* GetFieldDeliveredTo() {
        return m_rgpFields[FD_DELIVERED_TO].c_str();
    };
    const TString& GetGeoZone() {
        return m_rgpFields[FD_IY_GEOZONE];
    };
    const char* GetFirstGeoZone() {
        return m_rgpFields[FD_IY_FIRSTGEOZONE].c_str();
    };
    const char* GetReturnPath() {
        return m_rgpFields[FD_RETURN_PATH].c_str();
    };
    const char* GetSubject() {
        return m_rgpFields[FD_SUBJECT].c_str();
    };
    const char* GetXMailer() {
        return m_rgpFields[FD_X_MAILER].c_str();
    };
    const char* GetUserAgent() {
        return m_rgpFields[FD_USER_AGENT].c_str();
    };
    const char* GetQueueID() {
        return m_rgpFields[FD_X_YANDEX_QUEUEID].c_str();
    };
    const char* GetRPOPFolder() {
        return m_rgpFields[FD_X_YANDEX_RPOP_FOLDER].c_str();
    };
    const char* GetFirstRdns() {
        return m_rgpFields[FD_REC_RDNS].c_str();
    };
    ui32 GetNetcSender() {
        return m_cur.rgnet[0];
    };
    int GetMsgDayCount() {
        return m_cur.cMsgDayCount;
    };
    time_t GetBornDate() {
        return m_cur.tBornDate;
    };
    ui32 GetKarma() {
        return m_cur.karma;
    };
    ui32 GetKarmaStatus() {
        return m_cur.karma_status;
    };
    const char* GetHostSender() {
        return m_sRelay.c_str();
    };
    const char* GetIpSender() {
        return m_sIpSender.c_str();
    };
    const TString& GetFieldListAll() const {
        return m_sListAll;
    };
    const char* GetForwardHost() {
        return m_sForwardHost.c_str();
    };
    const char* GetForwardIp() {
        return m_sForwardIp.c_str();
    };
    const char* GetDomainLabel() {
        return m_sDomainLabel.c_str();
    };
    const char* GetIpFirst() {
        return m_sIpFirst.c_str();
    };
    const char* GetHostFirst() {
        return m_sHostFirst.c_str();
    };
    bool GetMailGmailIMAP() {
        return m_cur.fMailGmailIMAP;
    };
};
