#include <util/generic/string.h>
#include "spamstop.h"
#include "sptypes.h"
#include "mail/so/spamstop/tools/so-common/sputil.h"
#include "rengine.h"
#include "sptop.h"
#include "spalg.h"
#include "spstat.h"
#include "sphtml.h"


void SpCheckField(TRengine* sph, TStringBuf pFieldName, TStringBuf pField, TStringBuf pcharset, bool fValid, bool fMime) {
#ifdef SP_DEBUG_PRINT
    sptop.DebugPrintField(pFieldName, pField, FieldLen, pcharset, fValid);
#endif
    if (sph)
        ((TRengine*)sph)->CheckField(pFieldName, pField, pcharset, fValid, fMime);
}

void SpCheckBodyPart(TRengine* sph, const char* pBody, int BodyLen,
                     TBodyPartProperty* property) {
#ifdef SP_DEBUG_PRINT
    sptop.DebugPrintBodyPart(pBody, BodyLen, property);
#endif
    if (sph)
        ((TRengine*)sph)->CheckBodyPart(pBody, BodyLen, property);
}

// check envelope
void SpCheckRcpto(TRengine* sph, TStringBuf rcpt, TStringBuf originalRcpt) {
    if (sph) {
        const auto lowerRcpt = to_lower(TString(rcpt));
        const auto lowerOriginalRcpt = to_lower(TString(originalRcpt));
        ((TRengine*)sph)->CheckRcpt(lowerRcpt, lowerOriginalRcpt);
    }
}

void SpIncrementBlindTo(TRengine* sph) {
    if (sph)
        ((TRengine*)sph)->IncBlindTo();
}

void SpIncrementBlindRcpto(TRengine* sph) {
    if (sph)
        ((TRengine*)sph)->IncBlindRcpto();
}

bool SpPerformedRule(TRengine* sph, const char* sRule) {
    if (sph)
        return ((TRengine*)sph)->m_cur->rulesContext.IsRuleWorked(sRule);
    return false;
}

// set worked rule
void SpSetRule(TRengine* sph, TStringBuf szRuleName) {
    if (sph) {
        ((TRengine*)sph)->m_cur->rulesContext.SetRule(szRuleName);
    }
}

void SpSetRule(TRengine& sph, TStringBuf szRuleName) {
    sph.m_cur->rulesContext.SetRule(szRuleName);
}

void SpAddStatStrInt(TRengine* sph, const char* label, int value) {
    if (sph)
        ((TRengine*)sph)->GetSpStat().AddStat(ST_RBL) << label << value;
}

void SpPrepareSubject(TRengine* sph, const char* ptext, int len) {
    if (sph)
        ((TRengine*)sph)->GetSpHtml()->PrepareSubject(sph, (ui8*)ptext, len);
}

void SpSetSenderUID(TRengine* sph, TString sUID) {
    if (sph)
        ((TRengine*)sph)->SetSenderUID(TUid{std::move(sUID)});
}

void SpSetSenderGeo(TRengine* sph, TStringBuf sGeo) {
    if (sph)
        ((TRengine*)sph)->SetSenderGeo(sGeo);
}

void SpSetShingle36Src(TRengine* sph, const char* shingleSrc) {
    if (sph)
        ((TRengine*)sph)->SetShingle36Src(shingleSrc);
}

/*
FILE *SpGetHttpLog ()
{
    return ((TRengine *)so_glob.gsp [0])->GetSpTop()->GetlogHttp();
}
*/
