#pragma once

#include <mail/so/spamstop/tools/so-common/ares.h>
#include "mail/so/spamstop/tools/so-clients/kshingle.h"
#include "mail/so/spamstop/sp/rulesholder.h"
#include "library/cpp/langs/langs.h"

class TRengine;

//return false - initialization error
// Big Yandex Mail
bool SpOpen(TRengine* * sph, const char *szDirectory);

// message field checking
void SpCheckField(TRengine* sph, TStringBuf pFieldName, TStringBuf pField, TStringBuf coding, bool fValid, bool fMime = true);

// message body part checking (arbitrary type)
void SpCheckBodyPart(TRengine* sph, const char* pBody, int BodyLen,
                     TBodyPartProperty* property);

// check envelope
void SpCheckRcpto(TRengine* sph, TStringBuf rcpt, TStringBuf originalRcpt);

void SpIncrementBlindTo(TRengine* sph);
void SpIncrementBlindRcpto(TRengine* sph);

// set and get worked rule
void SpSetRule(TRengine* sph, TStringBuf szRuleName);
void SpSetRule(TRengine& sph, TStringBuf szRuleName);
bool SpPerformedRule(TRengine* sph, const char* sRule);

// print label and int value to delivery log
void SpAddStatStrInt(TRengine* sph, const char* label, int value);


// return domen name or null if information is not need
// call directly before SpCheckMessage
// while return not null
//const char *GetDomenName(TRengine* sph);

void SpPrepareSubject(TRengine* sph, const char* ptext, int len);

void SpSetSenderUID(TRengine* sph, TString sUID);

void SpSetSenderGeo(TRengine* sph, TStringBuf sGeo);

void SpSetShingle36Src(TRengine* sph, const char* shingleSrc);
