#pragma once

#ifndef __SP_BODY_H__
#define __SP_BODY_H__

#include "sptypes.h"
#include "mail/so/spamstop/tools/so-common/sputil.h"
#include "spamrule.h"
#include "context_symbols.h"

class TRengine;

struct TCurBodyPart {
    TCurBodyPart() = default;
    bool fmicrosoft_executable{};
    bool fmime_base64_encoded_text{};
    bool fmime_faraway_charset{};
    bool fmime_html_no_charset{};
    bool fmime_long_line_qp{};
    bool fmime_suspect_name{};

    double mime_qp_ratio{};
    int mime_body_html_count{};
    int mime_body_text_count{};
    bool fTextHtml{};
    bool fTextPlain{};
};

class TSpBodyPart {
private:
    TCurBodyPart m_cur{};

    static int DelRepeatedSpaces(char* szField);
    void CheckMimeHeader(TBodyPartProperty* prop);
    static void PrepareContextType(TString& ctype);
    void HandleArchive(const TBodyPartProperty* property, TRengine* m_prengine);

public:
    TSpBodyPart() = default;
    void CheckMessage(TRengine* m_prengine);
    void CheckBodyPart(TRengine* m_prengine, const char* pBody, int BodyLen, TBodyPartProperty* property);
};

#endif // __SP_BODY_H__
