#pragma once

#include "rulesholder.h"
#include "splvexpr.h"

struct TKeyNode {
    std::vector<std::reference_wrapper<const TLvPcre>> vrules; // save ref of lvpcre, compensatory rules must be placed ahead
    TStringBuf key;        // key
};

struct TLvLetter {
    TLvLetter() = default;
    size_t c{};
    size_t first{};
};

class TRengine;

class TLingv {
public:
    struct TScores{
        double score{};
    };

    explicit TLingv(const TRulesHolder& rulesHolder);
    ~TLingv();
    void Check(const TStringBuf& text);
    static void CorrectWord(char* it, const char* end) ;
    void InitMessage(TRulesContext* rulesContext);
    const TScores& GetScores() const;


private:
    bool CheckPcre(const TLvPcre& ppcre, const char* begin, const char* it, const char* it_end, const char* end);
    void CheckKey(const TKeyNode& keyNode, const char* begin, const char* it, const char* end);

private:
    TLvLetter m_lets[256];
    char m_big[256][256]; // all perhaps bigramms

    int* m_sortedkeys; // array sorted by keys
    THashMap<int, std::reference_wrapper<const TLvKey>> m_keys;       // key.id -> ind of m_pvLvKeys;
    TKeyNode* m_rgnodes; // key.id -> TKeyNode
    TRulesContext* RulesContext{};

    TScores m_scores{};
    const TRulesHolder &m_pRulesHolder;

    TVector<TLvPcre> lvpcre;
};

