#pragma once

#include <mail/so/spamstop/tools/so-common/sputil.h>
#include <mail/so/spamstop/tools/so-clients/SperrorHolder.h>
#include "spamrule.h"
#include "sptypes.h"
#include "spruler.h"
#include "spstat.h"
#include "processing_context.h"

struct TCurRuler {
    bool fAnti{};
};

class TSpRuler {
public:
    explicit TSpRuler(TSpLogger* pSpLogger, int m_cRulesA, TVector<THolder<TRuleDef>>& m_ppRulesA);
    ecRet SetRules();

    template<typename T> void CheckRange(TCurMessageEngine& curMessageEngine, const TString& key, T value, bool fPrintWarning = false) const {
        auto *pvrange = FindRangeRules(key, fPrintWarning);
        if (!pvrange)
            return;

        for (auto n : *pvrange) {
            auto& rule = m_ppRules[n];
            if (rule->rt == RT_RANGE) {
                if (std::get<TRangeDef>(rule->rules).CheckRange(value))
                    curMessageEngine.rulesContext.WorkedRule(n);
            } else
                if (m_p_sp_logger != nullptr)
                    m_p_sp_logger->splog(TLOG_ERR, "rule type error in range checking: %s", rule->pRuleName.c_str());
        }
    }

    void CheckDateRange(TCurMessageEngine& curMessageEngine, const TString& key, time_t value, bool fPrintWarning = false) const;
    TString CheckLevenstein(TCurMessageEngine& curMessageEngine, const char* key, const char* word) const;

private:

    const std::vector<int>* FindRangeRules(const TString& key, bool fPrintWarning) const;
    const std::vector<int>* FindLevensteinRules(const TString& key, bool fPrintWarning) const;
    size_t GetLevensteinDistance(const TString& src, const TString& dst) const;
private:
    int m_cRules;         // count of rules
    TVector<THolder<TRuleDef>>& m_ppRules; // array of rules
    TSpLogger* m_p_sp_logger;
    TCurRuler m_cur;
    THashMap<TString, std::vector<int>> m_mapKeyRange; // map keys for ranges rules
    THashMap<TString, std::vector<int>> m_mapKeyLevenstein;
};

