#include <string.h>
#include "mail/so/spamstop/tools/so-common/sputil.h"
#include "spamrule.h"
#include "spstat.h"
#include <util/generic/iterator_range.h>
#include <util/string/builder.h>

IOutputStream& operator<<(IOutputStream& stream, const TSpStat::TDlvLogPrinter& p) {
    p.Master.VisitRecords([&stream](const auto& records) mutable {
        for(const auto& [prefix, record] : records) {
            if (record)
                stream << prefix << ": " << record.Str() << '\n';
        }
    });

    return stream << '\n';
}

IOutputStream& operator<<(IOutputStream& stream, const TSpStat::TJsonDlvLogPrinter& p) {
    {
        NJsonWriter::TBuf buf(NJsonWriter::HEM_DONT_ESCAPE_HTML, &stream);

        buf.BeginList();

        p.Master.VisitRecords([&](const auto& records) mutable {
            for (const auto& [prefix, record] : records) {
                if (record) {
                    buf.BeginList();
                    buf.WriteString(StripString(prefix)).WriteString(StripString(record.Str()));
                    buf.EndList();
                }
            }
        });
        buf.EndList();
    }
    return stream << '\n';
}

NJsonWriter::TBuf& PrintJson(const TSpStat::TJsonPrinter& p, NJsonWriter::TBuf& buf) {
    THashMap<TStringBuf, TDeque<TStringBuf>> groupsByPrefix;

    p.Master.VisitRecords([&](const auto& records) mutable {
        for(const auto& [prefix, record] : records) {
            if (record)
                groupsByPrefix[StripString(TStringBuf(prefix))].emplace_back(record.Str());
        }
    });

    buf.BeginObject();
    for(const auto& [prefix, records] : groupsByPrefix) {
        buf.WriteKey(StripString(prefix));
        buf << records;
    }
    buf.EndObject();

    return buf;
}

IOutputStream& operator<<(IOutputStream& stream, const TSpStat::TJsonPrinter& p) {

    NJsonWriter::TBuf buf(NJsonWriter::HEM_DONT_ESCAPE_HTML, &stream);

    buf << p;

    return stream;
}

void TSpStat::TRecord::DoWrite(const void* buf, size_t len) {
    for (char c: MakeArrayRef((const char *) buf, len)) {
        Row << ((0 <= c && c < 32) ? '_' : c);
    }
}
