#pragma once

#include <util/system/mutex.h>
#include <util/network/hostip.h>
#include <util/generic/ptr.h>
#include <library/cpp/logger/all.h>
#include <library/cpp/langs/langs.h>
#include <mail/so/spamstop/tools/so-clients/SperrorHolder.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/config.h>
#include <mail/so/spamstop/tools/simple_shingler/handler_server.h>
#include <mail/so/spamstop/tools/pcre_wrapper/pcre_wrapper.h>
#include <util/folder/path.h>
#include <util/generic/size_literals.h>
#include <mail/so/spamstop/tools/so-common/ipv6.h>
#include "archive_reader.h"

#define Y_REJECT 1
#define Y_DISCARD 2

// must be defined as nullptr
struct TBodyPartProperty {
    TBodyPartProperty() = default;
    const char* pctype{};    // Content-Type
    const char* pcte{};      // Content-Transfer-Encoding
    const char* pcd{};       // Content-Disposition
    const char* pcharset{};  // charset
    const char* pname{};     // name
    const char* pfilename{}; // name
    bool fBase64{};
    const char* pct_raw{}; // all Content-Type text
    ELanguage lang = LANG_UNK;
    std::vector<TArciveItem>* arc_files{}; // archive contents, in case there is an archive in attach
};

typedef enum {
    spTextUnknown,
    spTextPlain,
    spTextHtml
} TSpMesType;

enum TParsLogTypes { log_messsage,
                     log_warning,
                     log_error,
                     log_unlimit_warning,
                     log_unlimit_error,
                     log_exception,
                     log_url };

struct TClientsConfigs {
    TClientsConfigs() = default;
    static TClientsConfigs FromConfig(const NConfig::TDict& config);
    // Http client
    TMaybe<TClientConfig> Http2Config;

    // StatLog client
    TMaybe<TClientConfig> StatlogConfig;
    TMaybe<TClientConfig> SpLoggerConfig;

    //FreeMail Reputation client
    TMaybe<TClientConfig> FreeMailReputationConfig;

    //Sender Reputation client
    TMaybe<TClientConfig> SenderReputationConfig;

    //Url Reputation client
    TMaybe<TClientConfig> UrlReputationConfig;

    // passport-internal client
    TMaybe<TClientConfig> PassInternalConfig;

    //Abuse client
    TMaybe<TClientConfig> AbuseConfig;
    TMaybe<TClientConfig> UserWeightsConfig;
    TMaybe<TClientConfig> UserWeightsNgConfig;

    //UaaS client
    TMaybe<TClientConfig> UaasConfig;

    //LSA client
    TMaybe<TClientConfig> LSAConfig;

    //user reputation client
    TMaybe<TClientConfig> UserReputationConfig;

    //blackbox client
    TMaybe<TClientConfig> BBConfig;

    TMaybe<TClientConfig> RblConfig;

    TMaybe<TClientConfig> Knn;

    TMaybe<TClientConfig> CacheConfig;
    TMaybe<TClientConfig> FastReputationConfig;

    TMaybe<TClientConfig> RblProducerConfig;
    TDuration RblProducerTTL = TDuration::Hours(1);
    TDuration RblProducerPeriod = TDuration::Seconds(5);

    TMaybe<TClientConfig> DkimUpdaterConfig;

    TMaybe<TClientConfig> OcrConfig;
};


struct TTvmConfig{
    static TTvmConfig FromConfig(const NConfig::TConfig& config);

    ui64 Id{};
    TString Secret;
    THashMap<TString, ui64> Services;
};

struct TDeobfuscatorConfig {
    static TDeobfuscatorConfig FromConfig(const NConfig::TConfig& config);
    TFsPath RemapPath;
    TFsPath TriePath;
};

struct TDeobfuscatorConfigs {
    static TDeobfuscatorConfigs FromConfig(const NConfig::TConfig& config);
    TMap<TString, TDeobfuscatorConfig> Configs;
};

class TSoConfig {
public:
    bool is_spk{};

    TVector<TFsPath> dnRules; // rules directory

    bool fCorpMode{}; // true for ya-corp mode

    double score = 9.0;
    double delivery_score = 9.0;
    double LvThreshold{};     // max rules weight for  linguistics rules
    TString fnClassification; // statistics for message classification
    int DeliveryLogRegim = 1; // 0 -  DeliveryLog disable, 1 - enable, 2 - partial enable, if fault http transfer
    TString sStatTimeX;
    TString fnRulesList;         // rules list for encoding
    bool fPersonalFilterDebug{}; // debug print

    TClientsConfigs ClientsConfigs;

    TString ComplLog;
    TString ShortLog;
    TString MLLog;      // Machine Learning rows log
    TString UserRepLog; // user reputation log for fast so-out ML

    // webmail
    bool fWebMail{};

    // dumb mode, disables external data sources
    int dumbMode{};

    // Matrixnet plugin
    TString mnPluginLibDir;
    TString mnConfigPath;

    TString UnistatPrefix;

    TString defDomain;

    bool bSlowlog = false;
    int iSlowlogThreshold = 10;
    TFsPath sSlowlog;

    int fsSh14sLim = 65500;
    int fsSh17sLim = 50000;
    int fsSh17sLim2 = 10000;
    int fsSh17mLim2 = 10000;

    size_t solverThreads = 1;

    ELogPriority logLevel = TLOG_NOTICE;

    int dns_timeout = 100;

#ifdef SO_CMAIL
    int smart_reject = 1;
#else
    int smart_reject = 0;
#endif

    TString fakeSyslog = "cout";

    TString tskvFormat = "mail-so-ml-log";

    TVector<TIpAddr> uNet;  // SubNet address not to check
    TVector<TIpAddr> uMask; // SubNet mask not to check

    TString dnsbl_server;

    TString statFolder;

    int add_rcvd = 1;

    int discard_trusted = 0;

    int bDetectForeignMx = 0;

    THashSet<TString> domesticZones;

    TString fnFilterLog;
    TString fnRulesLog;
    TString fnHttpLog;

    size_t TotalRcptsToProceed = std::numeric_limits<size_t>::max();
    size_t MailTruncateSize = std::numeric_limits<size_t>::max();
    size_t MailProceedSize = 64_KB;
    size_t HeaderMaxSize = 5_KB;

    int corp_mail = 0;

    TString rblHosts;

    TVector<TString> TabPrefixesToCalcTheBest;

    TServerOptions ServerOptions;

    bool NewDlvFormat{};

    TMaybe<TTvmConfig> TvmConfig;

    size_t MinHashSize = 30;

    size_t Hosts2MlLimitation = std::numeric_limits<size_t>::max();

    THashSet<TString, TCIOps, TCIOps> UrlsToExclude;

    TFsPath Text2VecDssm;

    bool PersFilterGetOnly = false;

    TMaybe<TDeobfuscatorConfigs> DeobfuscatorConfigs;

    bool UseDeobfuscatorForNormalizeBeforeRe = false;

    TMaybe<TFsPath> HsRulesCache;

    TFsPath DomenFactorsTrie;

    TDuration UserWeightsFetchingPeriod = TDuration::Minutes(5);

    TMaybe<TFsPath> RulesDictPath;

    TFsPath UidsFeaturesPath;

    TString KasperskyLogger;
    TString JsonMlLog;

    NRegexp::TSettings PcreSettings;

    bool PrintPersonalResolutions{};

    THashMap<TUid, TSpClass> ResolutionsMapping;

    size_t ThreadStackSize = 0;

    TFsPath RecorderDictPath;

    TFsPath TrustedZonesPath;
    TFsPath IntranetZonesPath;
    TFsPath LocalZonesPath;

    TSoConfig() = default;
    explicit TSoConfig(bool spk);
    explicit TSoConfig(const NConfig::TConfig& config);
    TSoConfig(const TSoConfig&) = default;

    double GetLvThreshold() const;
};
