#pragma once

#include <cctype>
#include <vector>
#include <utility>
#include <library/cpp/enumbitset/enumbitset.h>
#include <util/generic/vector.h>
#include <mail/so/spamstop/tools/so-common/tparsedlvlog_data.h>
#include <mail/so/spamstop/tools/so-common/shtime.h>

#define SP_MAX_PATH 256

#ifndef isletter
#define isletter(c) (((c) >= 'A' && (c) <= 'Z') || ((c) >= 'a' && (c) <= 'z'))
#endif

#define legal_variable_char(c) (isletter(c) || isdigit(c) || c == '_')

typedef int ecRet;

typedef enum {
    spRegimeCheckClientRule,
    spRegimeCheckBigMailRule,
    spRegimePackRule,
    spRegimeWork,
    spRegimeUndef,
    spRegimeCheckBigMailAndClientRule
} TSpRegimeType;

#define ecOK 0         // Everything's fine!
#define ecInvalidHex 4 // invalid hex character found in data
#define ecEndOfFile 7  // End of file reached
#define ecNoMem 10     // No memory
#define ecFormat 11    // Format error
#define ecException 12 // Exception
#define ecInternal 13  // Internal error
#define ecCreatingFile 14
#define ecWriting 15
#define ecReading 16
#define ecConfiguration 17
#define ecHtmlParserErr 18
#define ecData 19
#define ecOpen 20
#define ecRusLang 21

#define TRANSIT_ERR(ecarg) \
    if (ecarg != ecOK) {   \
        return ecarg;      \
    }


#ifdef WIN32
#define SP_DEF_FILE_OPEN _open
#define SP_DEF_FILE_CLOSE(fh) \
    if (fh != -1)             \
        _close(fh);
#define SP_DEF_FILE_O_RDONLY _O_RDONLY
#define SP_DEF_FILE_O_WRONLY _O_WRONLY
#define SP_DEF_FILE_O_BINARY _O_BINARY
#define SP_DEF_FILE_O_CREAT _O_CREAT
#define SP_DEF_FILE_O_APPEND _O_APPEND
#else
#define SP_DEF_FILE_OPEN open
#define SP_DEF_FILE_CLOSE(fh) \
    if (fh != -1)             \
        close(fh);
#define SP_DEF_FILE_O_RDONLY O_RDONLY
#define SP_DEF_FILE_O_WRONLY O_WRONLY
#define SP_DEF_FILE_O_BINARY O_BINARY
#define SP_DEF_FILE_O_CREAT O_CREAT
#define SP_DEF_FILE_O_APPEND O_APPEND
#endif

//#ifdef SPK-3

struct TExtRengineData
{
    VP_STR_DBL r_sp_rules;
    VP_STR_DBL r_dl_rules;
    VP_STR_DBL r_nl_rules;

    TExtRengineData()
    {
       Clear();
    }

    void Clear()
    {
       r_sp_rules.clear();
       r_dl_rules.clear();
       r_nl_rules.clear();
    }

    TString GetRSp()
    {
       TString      res = "";
       VPI_STR_DBL it;
       char        tbuff[256];

       it = r_sp_rules.begin();
       while (it != r_sp_rules.end())
       {
           snprintf(tbuff, sizeof(tbuff) - 1, "%s:%f", (*it).first.c_str(), (*it).second);
           if (res.empty())
               res += TString(tbuff);
           else
               res += ";" + TString(tbuff);

           ++it;
        }

        return res;
     }

     TString GetRDl()
     {
        TString     res = "";
        VPI_STR_DBL it;
        char        tbuff[256];

        it = r_dl_rules.begin();
        while (it != r_dl_rules.end())
        {
            snprintf(tbuff, sizeof(tbuff) - 1, "%s:%f", (*it).first.c_str(), (*it).second);
            if (res.empty())
                res += TString(tbuff);
            else
                res += ";" + TString(tbuff);

            ++it;
        }

        return res;
     }

     TString GetRNl()
     {
        TString      res = "";
        VPI_STR_DBL it;
        char        tbuff[256];

        it = r_nl_rules.begin();
        while (it != r_nl_rules.end())
        {
            snprintf(tbuff, sizeof(tbuff) - 1, "%s", (*it).first.c_str());
            if (res.empty())
                res += TString(tbuff);
            else
                res += ";" + TString(tbuff);

            ++it;
        }

        return res;
      }
};

