#include <util/string/ascii.h>
#include "util/system/defaults.h"
#include "tagpars.h"
#include "tagattr.h"
#include "sptypes.h"
#include "mail/so/spamstop/tools/so-common/sputil.h"
#include "sphtml.h"

//**********
// TSpStyleTreating
//**********

TSpStyleTreating::TSpStyleTreating(bool is_spkA) {
    is_spk = is_spkA;
    m_fId = false;
    m_fClass = false;
    m_fTag = false;
}
void TSpStyleTreating::AddStyle(std::vector<TSpStyle>& vStyle) {
    // ������ body, ���� ���� ��������� � ���� �� ��� body
    if (vStyle.size() == 1) {
        TSpStyle& t = vStyle.front();
        if ((t.type == STYLE_CLASS || t.type == STYLE_TAG_CLASS || t.type == STYLE_ID || t.type == STYLE_TAG_ID) && !t.pname)
            t.fValid = false;
        if (!t.fValid)
            return;
        m_pvAlone.push_back(t);
        if (t.type == STYLE_CLASS || t.type == STYLE_TAG_CLASS)
            m_fClass = true;
        if (t.type == STYLE_ID || t.type == STYLE_TAG_ID)
            m_fId = true;
        if (t.type == STYLE_TAG)
            m_fTag = true;
#ifdef STYLE_DEB
        DebugPrint(t);
#endif
    }
#ifdef STYLE_DEB
    else if (vStyle.size() > 1) {
        vector<TSpStyle>::iterator iv;
        for (iv = vStyle.begin(); iv != vStyle.end(); iv++) {
            DebugPrint(*iv);
        }
    }
#endif
}

bool TSpStyleTreating::NeedId() {
    return m_fId;
}

bool TSpStyleTreating::NeedClass() {
    return m_fClass;
}

void TSpStyleTreating::SetColors(TSpStyle& style, ui32* pdwColor, ui32* pdwBgColor) {
    if (*pdwColor == NO_COLOR)
        *pdwColor = style.Color;
    if (*pdwBgColor == NO_COLOR)
        *pdwBgColor = style.BgColor;
}

bool TSpStyleTreating::CompareNames(char* pstname, char* pValue, int ValueLen) {
    if (!strnicmp(pstname, pValue, ValueLen) && pstname[ValueLen] == 0)
        return true;
    return false;
}

void TSpStyleTreating::GetIdValue(HT_TAG enTag, char* pValue, int ValueLen, ui32* pdwColor, ui32* pdwBgColor) {
    std::vector<TSpStyle>::iterator iv;

    // +++ ���� ������� ��������� ���������� id
    // ���� ��������� ���������
    for (iv = m_pvAlone.begin(); iv != m_pvAlone.end(); iv++) {
        if (iv->type == STYLE_ID && CompareNames(iv->pname, pValue, ValueLen))
            SetColors(*iv, pdwColor, pdwBgColor);
        if (iv->type == STYLE_TAG_ID && enTag == iv->idtag && CompareNames(iv->pname, pValue, ValueLen))
            SetColors(*iv, pdwColor, pdwBgColor);
    }
}

void TSpStyleTreating::GetClassValue(HT_TAG enTag, char* pValue, int ValueLen, ui32* pdwColor, ui32* pdwBgColor) {
    std::vector<TSpStyle>::iterator iv;

    // +++ ���� ������� ��������� ���������� id
    // ���� ��������� ���������
    for (iv = m_pvAlone.begin(); iv != m_pvAlone.end(); iv++) {
        if (iv->type == STYLE_CLASS && CompareNames(iv->pname, pValue, ValueLen))
            SetColors(*iv, pdwColor, pdwBgColor);
        if (iv->type == STYLE_TAG_CLASS && enTag == iv->idtag && CompareNames(iv->pname, pValue, ValueLen))
            SetColors(*iv, pdwColor, pdwBgColor);
    }
}

void TSpStyleTreating::GetTagValue(HT_TAG enTag, ui32* pdwColor, ui32* pdwBgColor) {
    std::vector<TSpStyle>::iterator iv;

    for (iv = m_pvAlone.begin(); iv != m_pvAlone.end(); iv++) {
        if (iv->type == STYLE_TAG && enTag == iv->idtag)
            SetColors(*iv, pdwColor, pdwBgColor);
    }
}

void TSpStyleTreating::DebugPrint(TSpStyle& st) {
    const char *p = "", *ptag = "-"; //  , *pname = st.pname ? st.pname : "-";

    if (st.type == STYLE_TAG)
        p = "STYLE_TAG";
    else if (st.type == STYLE_CLASS)
        p = "STYLE_CLASS";
    else if (st.type == STYLE_ID)
        p = "STYLE_ID";
    else if (st.type == STYLE_TAG_CLASS)
        p = "STYLE_TAG_CLASS";
    else if (st.type == STYLE_TAG_ID)
        p = "STYLE_TAG_ID";

    if (st.type != STYLE_CLASS && st.type != STYLE_ID)
        for (int i = 0; httags[i].name[0]; i++) {
            if (httags[i].id == st.idtag) {
                ptag = httags[i].name;
                break;
            }
        }
}

//**********
// TTagAttr
//**********

TTagAttr::TTagAttr(ATagParsing* ptagpars, TMapTag* pmapTags, bool is_spkA) {
    attrsMap.reserve(MAX_ATTRS + 1);

    m_cIndex = 0;
    m_fInit = false;
    m_ptagpars = ptagpars;
    m_pmapTags = pmapTags;
    m_pstyle = 0;

    is_spk = is_spkA;

    InitAttr(false, 0);
}
TTagAttr::~TTagAttr() {
    DELETE_OBJ(m_pstyle);
}

int TTagAttr::AddAttr(const char* AttrName) {
    if (m_cIndex == MAX_ATTRS) {
/*        if (is_spk)
            sperrorK("Couldn't add attribute! Max count of attributes = %d", MAX_ATTRS);
        else
            m_p_sp_logger->splog(TLOG_ERR, "Couldn't add attribute! Max count of attributes = %d", MAX_ATTRS);
            */
        return -1;
    }

    if (attrsMap.contains(AttrName)) {
/*
        if (is_spk)
            sperrorK("Repeating attribute initializaton: %s", AttrName);
        else
            m_p_sp_logger->splog(TLOG_ERR, "Repeating attribute initializaton: %s", AttrName);
            */
        return -1;
    }

    m_AttrLens[m_cIndex] = strlen(AttrName);
    attrsMap.emplace(AttrName, m_cIndex);

    return m_cIndex++;
}

void TTagAttr::InitMessage() {
    DELETE_OBJ(m_pstyle);
    m_fBigFont = false;
}

void TTagAttr::InitAttr(TStringBuf ptag) {
    InitAttr(false, ptag.size());
}
void TTagAttr::InitAttr(bool fClosing, int len) {
    m_cAttrs = 0;
    m_state = ATTR_INIT;
    m_found_attr = false;

    if (!m_fInit) {
        memset(m_pValues, 0, sizeof(m_pValues));
        m_fInit = true;
    }

    if (!fClosing && len > 4) {
        Get("style");
        if (m_pstyle && m_pstyle->NeedId())
            Get("id");
        if (m_pstyle && m_pstyle->NeedClass())
            Get("class");
    } else
        SetParsingBan();
}

bool TTagAttr::SetAttrs() {
    for (int i = 0; i < m_cAttrs; i++) {
        auto it = attrsMap.find(m_pAttrNames[i]);
        if (it != end(attrsMap))
            m_curIndexes[i] = it->second;
        else {
            m_curIndexes[i] = AddAttr(m_pAttrNames[i]);
            if (m_curIndexes[i] == -1)
                return false;
        }
    }
    return true;
}

void TTagAttr::Get(const char* szName) {
    m_pAttrNames[m_cAttrs++] = szName;
}

void TTagAttr::Parse(TStringBuf pTag) {

    if (m_state != ATTR_INIT)
        return;
    if (!SetAttrs())
        return;

    m_state = ATTR_PARSED;

    size_t p = 1;
    while ((p = pTag.find('=', p)) != TStringBuf::npos) {
        size_t pattr = p - 1;
        while (!isletter(pTag[pattr]) && pattr > 0)
            --pattr;
        while (isletter(pTag[pattr]) && pattr > 0)
            --pattr;
        ++pattr;
        TStringBuf attr = pTag.substr(pattr, p - pattr);
        for (int i = 0; i < m_cAttrs; i++) {
            TStringBuf attrName(m_pAttrNames[i], m_AttrLens[m_curIndexes[i]]);
            if (AsciiHasPrefixIgnoreCase(attr, attrName) && !isletter(*(attr.data() + m_AttrLens[m_curIndexes[i]]))) {
                int len = SetValue(m_curIndexes[i], pTag.data() + p + 1);
                if (len)
                    p += len;
                m_found_attr = true;
                break;
            }
        }
        ++p;
    }
}

int TTagAttr::SetValue(int ind, const char* pValue) {
    ui8 q = 0;
    const ui8* p = (const ui8*)pValue;
    const ui8* pV;

    m_fInit = false;

    while (IS_ATTR_SPACE(*p))
        ++p;

    if (IS_ATTR_QUOTE(*p)) {
        q = *p;
        pV = ++p;
        while (*p != q && *p)
            ++p;
    } else {
        pV = p;
        while (!IS_ATTR_SPACE(*p) && *p)
            ++p;
    }

    m_pValues[ind] = (const char*)pV;
    m_pValLen[ind] = p - pV;
    return m_pValLen[ind];
}

const char* TTagAttr::GetValue(const char* szName, int* pValueLen) {
    if(!m_found_attr)
        return nullptr;

    auto it = attrsMap.find(szName);

    if (it != end(attrsMap)) {
        if (m_pValues[it->second] && m_pValLen[it->second] && m_state != ATTR_BAN) {
            *pValueLen = m_pValLen[it->second];
            return m_pValues[it->second];
        }
    }

    return nullptr;
}

bool TTagAttr::GetIntValue(const char* szName, int* pIntValue) {
    int ValueLen;
    const char* pValue = GetValue(szName, &ValueLen);

    if (pValue && m_state != ATTR_BAN && IsInt(pValue)) {
        *pIntValue = atoi(pValue);
        return true;
    }

    return false;
}

// text - (255, 0, 0) or (100%, 0, 0)
bool TTagAttr::GetRgb(const ui8* ptext, ui32* rgb) {
    ui32 val;

    Skipspaces(&ptext);

    if (*ptext++ != '(')
        return false;

    if (!GetRgbVal(&ptext, &val))
        return false;

    *rgb = val << 16;

    if (!GetRgbVal(&ptext, &val))
        return false;

    *rgb += val << 8;

    if (!GetRgbVal(&ptext, &val))
        return false;

    *rgb += val;
    return true;
}

bool TTagAttr::GetRgbVal(const ui8** ptext, ui32* rgb) {
    const ui8* p = *ptext;
    int val;

    Skipspaces(&p);

    if (!IsInt((char*)p))
        return false;
    val = atoi((char*)p);

    if (IS_ATTR_SIGN(*p))
        ++p;
    while (isdigit(*p))
        ++p;
    if (*p == '%') {
        if (val < 0)
            val = 0;
        else if (val > 100)
            val = 100;
        val *= 255;
        val /= 100;
        ++p;
    }

    Skipspaces(&p);

    if (*p == ',')
        ++p;

    *ptext = p;

    *rgb = val;

    return true;
}

bool TTagAttr::GetColorVal(const ui8* sztext, ui32* rgb, bool fQuote) {
    int c;
    ui8 str[6];

    for (c = 0; isxdigit(sztext[c]); c++)
        ;

    if (!CorrectEndOfValue(sztext + c, fQuote))
        return false;

    if (c == 3) // #F00
    {
        str[0] = sztext[0];
        str[1] = sztext[0];
        str[2] = sztext[1];
        str[3] = sztext[1];
        str[4] = sztext[2];
        str[5] = sztext[2];
        StrToHex(str, 6, rgb);
        return true;
    } else if (c == 6) // #FF0000
    {
        StrToHex(sztext, 6, rgb);
        return true;
    }
    return false;
}

bool TTagAttr::GetColor(const ui8* sztext, ui32* rgb, bool fColorAttr) {
    int i;
    bool fQuote = false;

    Skipspaces(&sztext);
    if (*sztext != ':' && *sztext != '=')
        return false;
    ++sztext;
    Skipspaces(&sztext);

    if (!strncmp((const char*) sztext, "rgb", 3)) {
        sztext += 3;
        return GetRgb(sztext, rgb);
    }

    if (IS_ATTR_QUOTE(*sztext)) {
        ++sztext;
        fQuote = true; // must exists closed quote
    }
    if (*sztext == '#') {
        sztext++;
        return GetColorVal(sztext, rgb, fQuote);
    } else // color: red
    {
        char name[256];
        for (i = 0; i < 250 && isletter(sztext[i]); i++)
            name[i] = (char)(sztext[i]);
        name[i] = 0;

        if (i && m_ptagpars->GetRgbByName(name, rgb, fColorAttr)) {
            if (!CorrectEndOfValue(sztext + i, fQuote))
                return false;
            return true;
        }

        return GetColorVal(sztext, rgb, fQuote); // color: FF0000
    }

    return false;
}

void TTagAttr::Skipspaces(const ui8** ptext) {
    while (IS_ATTR_SPACE(**ptext))
        ++(*ptext);
}
void TTagAttr::Skipspaces(const char** ptext) {
    while (IS_ATTR_SPACE_PC(*ptext))
        ++(*ptext);
}

void TTagAttr::Skipquotes(const ui8** ptext) {
    while (IS_ATTR_QUOTE(**ptext))
        ++(*ptext);
}

void TTagAttr::SkipName(const ui8** pptext) {
    const ui8* ptext = *pptext;

    while (isletter(*ptext) || isdigit(*ptext) || *ptext == '-' || *ptext == '_')
        ++ptext;

    *pptext = ptext;
}

void TTagAttr::SkipComment(const ui8** pptext) {
    const ui8* ptext = *pptext;

    if (*ptext == '/') {
        if (ptext[1] == '*') {
            const char* p = (char*)ptext;
            p = strstr(p, "*/");
            if (p)
                ptext = (ui8*)(p + 2);
        }
    }

    *pptext = ptext;
}

bool TTagAttr::CorrectEndOfValue(const ui8* ptext, bool fQuote) {
    if (fQuote) {
        if (!IS_ATTR_QUOTE(*ptext)) // closed quote not exists
            return false;
        ++ptext;
    }

    Skipspaces(&ptext);

    if (*ptext == ';' || *ptext == '}' || *ptext == 0)
        return true;

    return false;
}

const char* TTagAttr::GetStyleAttr(const char* szStyle, const char* p, bool* fValid,
                                   const char* szAttrName, const char* szSuffix) {
    if (!(p = strstr(p, szAttrName)))
        return nullptr;

    if (IsPointToAttrBegin(szStyle, p))
        *fValid = true;
    else
        *fValid = false;

    p += strlen(szAttrName);

    if (szSuffix && *p == '-')
        if (!strncmp(++p, szSuffix, strlen(szSuffix)))
            p += strlen(szSuffix);

    return p;
}

bool TTagAttr::GetStyleColorValues(const char* szStyle, ui32* dwColor, ui32* dwBgColor) {
    bool fres = false;
    ui32 rgb;
    bool fValid;

    *dwColor = NO_COLOR;
    *dwBgColor = NO_COLOR;

    const char* p = szStyle;
    while ((p = GetStyleAttr(szStyle, p, &fValid, "background", "color")))
        if (fValid && GetColor((ui8*)p, &rgb, false)) {
            *dwBgColor = rgb;
            fres = true;
        }

    p = szStyle;
    while ((p = GetStyleAttr(szStyle, p, &fValid, "color", nullptr)))
        if (fValid && GetColor((ui8*)p, &rgb, true)) {
            *dwColor = rgb;
            fres = true;
        }

    if (!m_fBigFont) {
        p = szStyle;
        while ((p = GetStyleAttr(szStyle, p, &fValid, "font", "size")))
            if (fValid)
                CheckSize(p);
    }
    return fres;
}

bool TTagAttr::IsPointToAttrBegin(const char* pStyle, const char* pattr) {
    if (!IS_ATTR_SPACE_PC(pattr - 1) && pattr != pStyle && *(pattr - 1) != ';')
        return false;
    return true;
}

void TTagAttr::CheckSize(const char* p) {
    Skipspaces(&p);
    if (*p != ':' && *p != '=')
        return;
    ++p;
    Skipspaces(&p);

    if (!IsInt(p))
        return;
    int val = atoi((char*)p);
    while (isdigit(*p) || *p == '.')
        ++p;
    Skipspaces(&p);
    if (val > 12 && !strncmp(p, "pt", 2))
        m_fBigFont = true;
}

bool TTagAttr::IsBigFont() {
    return m_fBigFont;
}

void TTagAttr::GetStyle(HT_TAG enTag, ui32* pdwColor, ui32* pdwBgColor) {
    int ValueLen;
    char* pValue;

    pValue = (char*)GetValue("style", &ValueLen);

    if (pValue && m_state != ATTR_BAN) {
        char rem = pValue[ValueLen];
        pValue[ValueLen] = 0;
        strlwr(pValue);
        GetStyleColorValues(pValue, pdwColor, pdwBgColor);
        pValue[ValueLen] = rem;
    }

    if (!m_pstyle)
        return;

    if (m_pstyle->NeedId()) {
        pValue = (char*)GetValue("id", &ValueLen);
        if (pValue)
            m_pstyle->GetIdValue(enTag, pValue, ValueLen, pdwColor, pdwBgColor);
    }

    if (m_pstyle->NeedClass()) {
        pValue = (char*)GetValue("class", &ValueLen);
        if (pValue)
            m_pstyle->GetClassValue(enTag, pValue, ValueLen, pdwColor, pdwBgColor);
    }

    m_pstyle->GetTagValue(enTag, pdwColor, pdwBgColor);
}

void TTagAttr::SetParsingBan() {
    m_state = ATTR_BAN;
}

void TTagAttr::ParseStyle(const TString& styleStr) {
    const char* pBeg;
    std::vector<TSpStyle> vstyles;
    TSpStyle style;
    const char* pStyle = styleStr.c_str();

    while (*pStyle) {
        pBeg = pStyle;
        while (*pStyle != '{' && *pStyle)
            ++pStyle;
        if (*pStyle == '{') {
            int c = 1;
            const char* p = ++pStyle;
            for (; *p; p++) {
                if (*p == '{')
                    ++c;
                if (*p == '}')
                    --c;
                if (!c)
                    break;
            } // found '}'

            char remstyle = *p;
            char* premstyle = (char*)(p);
            *premstyle = 0;
            if (GetStyleColorValues(pStyle, &style.Color, &style.BgColor)) {
                char* prem = (char*)(pStyle - 1);
                *prem = 0;
                bool fBreak;
                while (GetNextName(&pBeg, &style, &fBreak)) {
                    if (fBreak)
                        AddStyle(vstyles);
                    vstyles.push_back(style);
                    DELETE_ARR(style.pname);
                    style.idtag = HT_PCDATA;
                }
                *prem = '{';
            }
            *premstyle = remstyle;
            pStyle = p;
        }

        AddStyle(vstyles);

        if (*pStyle == 0)
            break;
        ++pStyle;
    }
}

bool TTagAttr::GetNextName(const char** pStyle, TSpStyle* pval, bool* pfBreak) {
    const ui8* p = (const ui8*)(*pStyle);
    const ui8* pname;
    bool fTag = false;
    // ���������� ����������������� �������� ���������
    // ���� � �������������� ������� ����������� �������� �
    // ������������

    pval->fValid = true;
    *pfBreak = false;

    Skipspaces(&p);
    SkipComment(&p);
    Skipspaces(&p);
    if (*p == 0)
        return false;
    if (*p == ',') {
        ++p;
        *pfBreak = true;
        Skipspaces(&p);
    }
    Skipquotes(&p);

    if (*p == '#') {
        pval->type = STYLE_ID;
        ++p;
        Skipquotes(&p);
        pname = p;
        SkipName(&p);
        if (p > pname)
            STRDUP(&pval->pname, (char*)pname, p - pname);
    } else if (*p == '.') {
        pval->type = STYLE_CLASS;
        ++p;
        Skipquotes(&p);
        pname = p;
        SkipName(&p);
        if (p > pname)
            STRDUP(&pval->pname, (char*)pname, p - pname);
    } else {
        pval->type = STYLE_TAG;
        pname = p;
        SkipName(&p);
        if (p > pname) {
            fTag = true;
            if ((pval->idtag = m_pmapTags->GetTag((char*)pname, p - pname)) == HT_PCDATA)
                pval->fValid = false;
            if (*p == ':') {
                ++p;
                if (pval->idtag != HT_A || strncmp((char*)p, "link", 4))
                    pval->fValid = false;
                SkipName(&p);
            }
        }
        if (*p == '.') {
            ++p;
            if (*p == '#') {
                pval->type = STYLE_TAG_ID;
                ++p;
            } else
                pval->type = STYLE_TAG_CLASS;
            Skipquotes(&p);
            pname = p;
            SkipName(&p);
            if (p > pname)
                STRDUP(&pval->pname, (char*)pname, p - pname);
        }
    }

    if (*p == ':') {
        ++p;
        if (pval->idtag != HT_A || strncmp((char*)p, "link", 4))
            pval->fValid = false;
        SkipName(&p);
    }
    Skipquotes(&p);
    *pStyle = (const char*)p;
    if (pval->pname || fTag)
        return true;

    return false;
}

void TTagAttr::AddStyle(std::vector<TSpStyle>& vStyles) {
    if (vStyles.empty())
        return;

    if (!m_pstyle)
        m_pstyle = new TSpStyleTreating(is_spk);

    m_pstyle->AddStyle(vStyles);
    vStyles.clear();
}
