#pragma once

#ifndef __TAGATTR_H__
#define __TAGATTR_H__

#include "sptypes.h"
#include "tagpars.h"

#include <mail/so/spamstop/tools/so-common/sputil.h>

#include <library/cpp/html/spec/tags.h>

class ATagParsing;
class TMapTag;

typedef enum {
    STYLE_TAG,
    STYLE_CLASS,
    STYLE_ID,
    STYLE_TAG_CLASS,
    STYLE_TAG_ID
} TStyleType;

typedef struct _TSpStyle {
    TStyleType type;
    HT_TAG idtag;
    char* pname;
    ui32 Color;
    ui32 BgColor;
    bool fValid;
    _TSpStyle() {
        type = STYLE_TAG;
        idtag = HT_PCDATA;
        pname = 0;
        BgColor = NO_COLOR;
        Color = NO_COLOR;
        fValid = true;
    }
    _TSpStyle(const _TSpStyle& s) {
        type = s.type;
        idtag = s.idtag;
        if (s.pname)
            STRDUP(&pname, s.pname, strlen(s.pname));
        else
            pname = 0;
        BgColor = s.BgColor;
        Color = s.Color;
        fValid = s.fValid;
    }
    ~_TSpStyle() {
        DELETE_ARR(pname);
    }
} TSpStyle;

class TSpStyleTreating {
private:
    bool is_spk;

    typedef struct _TStyleComplex {
        std::vector<TSpStyle> vTags;
        int cur_ind;
    } TStyleComplex;

    std::vector<TSpStyle> m_pvAlone;
    //    TStyleComplex    *m_pComplex;
    bool m_fId;
    bool m_fClass;
    bool m_fTag;
    void DebugPrint(TSpStyle& st);
    void SetColors(TSpStyle& style, ui32* pdwColor, ui32* pdwBgColor);
    bool CompareNames(char* pstname, char* pValue, int ValueLen);

public:
    TSpStyleTreating(bool is_spkA);
    void AddStyle(std::vector<TSpStyle>& vStyle);
    bool NeedId();
    bool NeedClass();
    void GetIdValue(HT_TAG enTag, char* pValue, int ValueLen, ui32* pdwColor, ui32* pdwBgColor);
    void GetClassValue(HT_TAG enTag, char* pValue, int ValueLen, ui32* pdwColor, ui32* pdwBgColor);
    void GetTagValue(HT_TAG enTag, ui32* pdwColor, ui32* pdwBgColor);
};

class TTagAttr/*: public SpMapperInt*/ {
private:
    bool is_spk;
#define MAX_ATTRS 50
#define IS_ATTR_SPACE(c) TestHtmlSymbol(c, SP_SPACE)
#define IS_ATTR_SPACE_P(p) TestHtmlSymbol(*(p), SP_SPACE)
#define IS_ATTR_SPACE_PC(p) TestHtmlSymbol(*((ui8*)(p)), SP_SPACE)
#define IS_ATTR_QUOTE(c) TestHtmlSymbol(c, SP_QUOTE)
#define IS_ATTR_SIGN(c) TestHtmlSymbol(c, SP_SIGN)
    typedef enum {
        ATTR_INIT,
        ATTR_BAN,
        ATTR_PARSED
    } TTAttrStates;
    const char* m_pValues[MAX_ATTRS];
    int m_pValLen[MAX_ATTRS];
    int m_AttrLens[MAX_ATTRS];
    int m_curIndexes[MAX_ATTRS];
    const char* m_pAttrNames[MAX_ATTRS];
    int m_cAttrs;
    int m_cIndex;
    bool m_fInit;
    bool m_found_attr;
    bool m_fBigFont;

    THashMap<TString, i32> attrsMap;

    TTAttrStates m_state;
    ATagParsing* m_ptagpars;
    TMapTag* m_pmapTags;
    TSpStyleTreating* m_pstyle;

    int SetValue(int ind, const char* pValue);
    bool SetAttrs();
    int AddAttr(const char* AttrName);
    bool GetRgbVal(const ui8** ptext, ui32* val);
    bool GetRgb(const ui8* ptext, ui32* rgb);
    bool GetColorVal(const ui8* sztext, ui32* rgb, bool fQuote);
    bool GetColor(const ui8* sztext, ui32* rgb, bool fColorAttr);
    void Skipspaces(const ui8** ptext);
    void Skipspaces(const char** ptext);
    void Skipquotes(const ui8** ptext);
    void SkipName(const ui8** ptext);
    void SkipComment(const ui8** pptext);
    bool CorrectEndOfValue(const ui8* ptext, bool fQuote);
    bool GetStyleColorValues(const char* szStyle, ui32* dwColor, ui32* dwBgColor);
    bool IsPointToAttrBegin(const char* pStyle, const char* pattr);
    void CheckSize(const char* p);
    bool GetNextName(const char** pStyle, TSpStyle* stval, bool* pfBreak);
    const char* GetStyleAttr(const char* pStyle, const char* p, bool* fValid,
                             const char* szAttrName, const char* szSuffix);
    void AddStyle(std::vector<TSpStyle>& vStyle);

public:
    TTagAttr(ATagParsing* ptagpars, TMapTag* pmapTags, bool is_spkA);
    ~TTagAttr();
    void InitAttr(bool fClosing, int len);
    void InitAttr(TStringBuf ptag);
    void InitMessage();
    void Get(const char* szName);
    void Parse(TStringBuf pTag);
    const char* GetValue(const char* szName, int* pValueLen);
    bool GetIntValue(const char* szName, int* pValue);
    void GetStyle(HT_TAG enTag, ui32* dwColor, ui32* dwBgColor);
    void SetParsingBan();
    void ParseStyle(const TString& styleStr);
    bool IsBigFont();
};

#endif // __TAGATTR_H__
