#include "sphtml.h"
#include "sptop.h"
#include "sptypes.h"
#include "tagpars.h"

#include <mail/so/spamstop/tools/so-common/sputil.h>

#include <mail/so/libs/protect/protect.h>

static const auto spcolors = MakeTrueConstArray(
    TIdName{0xF0F8FF, "aliceblue"},
    TIdName{0xFAEBD7, "antiquewhite"},
    TIdName{0x00FFFF, "aqua"},
    TIdName{0x7FFFD4, "aquamarine"},
    TIdName{0xF0FFFF, "azure"},
    TIdName{0xF5F5DC, "beige"},
    TIdName{0xFFE4C4, "bisque"},
    TIdName{0x000000, "black"},
    TIdName{0xFFEBCD, "blanchedalmond"},
    TIdName{0x0000FF, "blue"},
    TIdName{0x8A2BE2, "blueviolet"},
    TIdName{0xA52A2A, "brown"},
    TIdName{0xDEB887, "burlywood"},
    TIdName{0x5F9EA0, "cadetblue"},
    TIdName{0x7FFF00, "chartreuse"},
    TIdName{0xD2691E, "chocolate"},
    TIdName{0xFF7F50, "coral"},
    TIdName{0x6495ED, "cornflowerblue"},
    TIdName{0xFFF8DC, "cornsilk"},
    TIdName{0xDC143C, "crimson"},
    TIdName{0x00FFFF, "cyan"},
    TIdName{0x00008B, "darkblue"},
    TIdName{0x008B8B, "darkcyan"},
    TIdName{0xB8860B, "darkgoldenrod"},
    TIdName{0xA9A9A9, "darkgray"},
    TIdName{0x006400, "darkgreen"},
    TIdName{0xBDB76B, "darkkhaki"},
    TIdName{0x8B008B, "darkmagenta"},
    TIdName{0x556B2F, "darkolivegreen"},
    TIdName{0xFF8C00, "darkorange"},
    TIdName{0x9932CC, "darkorchid"},
    TIdName{0x8B0000, "darkred"},
    TIdName{0xE9967A, "darksalmon"},
    TIdName{0x8FBC8F, "darkseagreen"},
    TIdName{0x483D8B, "darkslateblue"},
    TIdName{0x2F4F4F, "darkslategray"},
    TIdName{0x00CED1, "darkturquoise"},
    TIdName{0x9400D3, "darkviolet"},
    TIdName{0xFF1493, "deeppink"},
    TIdName{0x00BFBF, "deepskyblue"},
    TIdName{0x696969, "dimgray"},
    TIdName{0x1E90FF, "dodgerblue"},
    TIdName{0xB22222, "firebrick"},
    TIdName{0xFFFAF0, "floralwhite"},
    TIdName{0x228B22, "forestgreen"},
    TIdName{0xFF00FF, "fuchsia"},
    TIdName{0xDCDCDC, "gainsboro"},
    TIdName{0xF8F8FF, "ghostwhite"},
    TIdName{0xFFD700, "gold"},
    TIdName{0xDAA520, "goldenrod"},
    TIdName{0x808080, "gray"},
    TIdName{0x008000, "green"},
    TIdName{0xADFF2F, "greenyellow"},
    TIdName{0xF0FFF0, "honeydew"},
    TIdName{0xFF69B4, "hotpink"},
    TIdName{0xCD5C5C, "indianred"},
    TIdName{0x4B0082, "indigo"},
    TIdName{0xFFFFF0, "ivory"},
    TIdName{0xF0E68C, "khaki"},
    TIdName{0xE6E6FA, "lavender"},
    TIdName{0xFFF0F5, "lavenderblush"},
    TIdName{0x7CFC00, "lawngreen"},
    TIdName{0xFFFACD, "lemonchiffon"},
    TIdName{0xADD8E6, "lightblue"},
    TIdName{0xF08080, "lightcoral"},
    TIdName{0xE0FFFF, "lightcyan"},
    TIdName{0xFAFAD2, "lightgoldenrodyellow"},
    TIdName{0x90EE90, "lightgreen"},
    TIdName{0xD3D3D3, "lightgrey"},
    TIdName{0xFFB6C1, "lightpink"},
    TIdName{0xFFA07A, "lightsalmon"},
    TIdName{0x20B2AA, "lightseagreen"},
    TIdName{0x87CEFA, "lightskyblue"},
    TIdName{0x778899, "lightslategrey"},
    TIdName{0xB0C4DE, "lightsteelblue"},
    TIdName{0xFFFFE0, "lightyellow"},
    TIdName{0x00FF00, "lime"},
    TIdName{0x32CD32, "limegreen"},
    TIdName{0xFAF0E6, "linen"},
    TIdName{0xFF00FF, "magenta"},
    TIdName{0x800000, "maroon"},
    TIdName{0x66CDAA, "mediumaquamarine"},
    TIdName{0x0000CD, "mediumblue"},
    TIdName{0xBA55D3, "mediumorchid"},
    TIdName{0x9370DB, "mediumpurple"},
    TIdName{0x3CB371, "mediumseagreen"},
    TIdName{0x7B68EE, "mediumslateblue"},
    TIdName{0x00FA9A, "mediumspringgree"},
    TIdName{0x48D1CC, "mediumturquoise"},
    TIdName{0xC71585, "mediumvioletred"},
    TIdName{0x191970, "midnightblue"},
    TIdName{0xF5FFFA, "mintcream"},
    TIdName{0xFFE4E1, "mistyrose"},
    TIdName{0xFFE4B5, "moccasin"},
    TIdName{0xFFDEAD, "navajowhite"},
    TIdName{0x000080, "navy"},
    TIdName{0xFDF5E6, "oldlace"},
    TIdName{0x808000, "olive"},
    TIdName{0x6B8E23, "olivedrab"},
    TIdName{0xFFA500, "orange"},
    TIdName{0xFF4500, "orangered"},
    TIdName{0xDA70D6, "orchid"},
    TIdName{0xEEE8AA, "palegoldenrod"},
    TIdName{0x98FB98, "palegreen"},
    TIdName{0xAFEEEE, "paleturquoise"},
    TIdName{0xDB7093, "palevioletred"},
    TIdName{0xFFEFD5, "papayawhip"},
    TIdName{0xFFDAB9, "peachpuff"},
    TIdName{0xCD853F, "peru"},
    TIdName{0xFFC0CB, "pink"},
    TIdName{0xDDA0DD, "plum"},
    TIdName{0xB0E0E6, "powderblue"},
    TIdName{0x800080, "purple"},
    TIdName{0xFF0000, "red"},
    TIdName{0xBC8F8F, "rosybrown"},
    TIdName{0x4169E1, "royalblue"},
    TIdName{0x8B4513, "saddlebrown"},
    TIdName{0xFA8072, "salmon"},
    TIdName{0xF4A460, "sandybrown"},
    TIdName{0x2E8B57, "seagreen"},
    TIdName{0xFFF5EE, "seashell"},
    TIdName{0xA0522D, "sienna"},
    TIdName{0xC0C0C0, "silver"},
    TIdName{0x87CEEB, "skyblue"},
    TIdName{0x6A5ACD, "slateblue"},
    TIdName{0x708090, "slategray"},
    TIdName{0xFFFAFA, "snow"},
    TIdName{0x00FF7F, "springgreen"},
    TIdName{0x4682B4, "steelblue"},
    TIdName{0xD2B48C, "tan"},
    TIdName{0x008080, "teal"},
    TIdName{0xD8BFD8, "thistle"},
    TIdName{0xFF6347, "tomato"},
    TIdName{0x40E0D0, "turquoise"},
    TIdName{0xEE82EE, "violet"},
    TIdName{0xF5DEB3, "wheat"},
    TIdName{0xFFFFFF, "white"},
    TIdName{0xF5F5F5, "whitesmoke"},
    TIdName{0xFFFF00, "yellow"},
    TIdName{0x9ACD32, "yellowgreen"}
);

// *************
// AStackColors
// *************

//-----------------------------------------------------------------------------
// Fnc: AStackColors
// For: Create AStackColors object.
// Get:
// Ret: code err
//-----------------------------------------------------------------------------

AStackColors::AStackColors() {
    tagAttribute Attribute = {0, 0xFFFFFF, 3, 3, 0, 0, '!', 0, 0xFFFFFF, HT_PCDATA, false, 0};

    OpenTableCount = 0;
    BodyColor = 0;
    BodyBgColor = 0xFFFFFF;
    m_fBigFont = false;
    push_back(Attribute);

    maxDepth = 0;

    return;
}
//-----------------------------------------------------------------------------
// Fnc: GetIteratorToAttribute
// For: ���� ��������� �� ������� �������� ������
// Get:
// Ret: ��������� �� ������� �������� ������
//-----------------------------------------------------------------------------
inline ATTR_ITER AStackColors::GetIteratorToAttribute(void) {
    if (empty())
        return end(); //nullptr;
    ATTR_ITER ai = end();
    --ai;

    return ai;
}
//-----------------------------------------------------------------------------
// Fnc: GetAttribute
// For: ���� ������� �������� ������
// Get:
// Ret: Attribute
//-----------------------------------------------------------------------------
void AStackColors::GetAttribute(tagAttribute* Attribute) {
    if (empty()) {
        memset(Attribute, 0, sizeof(tagAttribute));
        return;
    }
    ATTR_ITER ai = GetIteratorToAttribute();
    *Attribute = *ai;
}

void AStackColors::SetColor(tagAttribute& Attribute) {
    if (Attribute.InpColor != NO_COLOR)
        Attribute.Color = Attribute.InpColor;
    if (Attribute.InpBgColor != NO_COLOR)
        Attribute.BgColor = Attribute.InpBgColor;
}

//-----------------------------------------------------------------------------
// Fnc: PushAttribute
// For: ���������� � ���� ��������� ������
// Get: Attribute   -  ����������� �������� ������
//      PopInd      -  ���� == -1, ��������� � ����� ����� ����� �������
//                  -  ���� >   0, ����������������� �������� �������� ���
//                     ������� ����� PopInd (PopInd > 0 ������ ��� ������
//                     �� �-�� PopAttribute  )
//      Count  - ���������� ����� ����
// Ret:
//-----------------------------------------------------------------------------
void AStackColors::PushAttribute(tagAttribute Attribute, ATTR_ITER ai) {
    //tagAttribute *pAttribute;
    i16 fontsize;
    ui8 BaseValue;

    if (empty()) {
        push_back(Attribute);
        if (GetSize() > maxDepth)
            maxDepth = GetSize();
        return;
    }
    if (ai == begin()) {
        insert(ai, Attribute);
        return;
    }

    --ai;

    switch (Attribute.enValue) {
        case HT_BODY:
            if (Attribute.InpColor != NO_COLOR)
                BodyColor = Attribute.InpColor;
            if (Attribute.InpBgColor != NO_COLOR)
                BodyBgColor = Attribute.InpBgColor;
            break;
        case HT_TABLE:
            Attribute.IsTd = false;
            Attribute.Size = 3;
            Attribute.Color = 0;
            Attribute.BgColor = 0xFFFFFF;
            Attribute.BaseFontSize = 3;
            Attribute.PlusSize = 0;
            if (BodyColor != NO_COLOR)
                Attribute.Color = BodyColor;
            if (BodyBgColor != NO_COLOR)
                Attribute.BgColor = BodyBgColor;
            if (OpenTableCount)
                Attribute.BgColor = (*ai).BgColor;
            OpenTableCount++;
            SetColor(Attribute);
            goto INSERT_OPERATION;
        case HT_TR:
            Attribute.IsTd = false;
            SetColor(Attribute);
        case HT_TD:
            if (Attribute.enValue == HT_TD)
                Attribute.IsTd = true;
            Attribute.Size = (*ai).Size;
            Attribute.BaseFontSize = (*ai).BaseFontSize;
            Attribute.PlusSize = (*ai).PlusSize;
            Attribute.Color = (*ai).Color;
            Attribute.BgColor = (*ai).BgColor;
            SetColor(Attribute);
            goto INSERT_OPERATION;
        default:
            break;
    }
    // setting font size
    Attribute.BaseFontSize = (*ai).BaseFontSize;
    Attribute.PlusSize = (*ai).PlusSize;
    Attribute.Color = (*ai).Color;
    Attribute.BgColor = (*ai).BgColor;
    Attribute.IsTd = (*ai).IsTd;
    SetColor(Attribute);

    if (Attribute.InpPlus) {
        if (Attribute.InpPlus == '!')
            fontsize = Attribute.InpSize;
        else {
            if (Attribute.enValue == HT_FONT)
                BaseValue = (*ai).BaseFontSize + Attribute.PlusSize;
            else
                BaseValue = (*ai).Size + Attribute.PlusSize;
            if (Attribute.InpPlus == '+') {
                fontsize = BaseValue + Attribute.InpSize;
                if (Attribute.enValue != HT_FONT)
                    Attribute.PlusSize += Attribute.InpSize;
            } else // if  (Plus == '-')
                fontsize = BaseValue - Attribute.InpSize;
        }
        if (fontsize <= 0)
            fontsize = 1;
        else if (fontsize > 255)
            fontsize = 255;
        // size ����� ���� > 7
        if (Attribute.enValue == HT_BASEFONT)
            Attribute.BaseFontSize = Attribute.InpSize;
    } else
        fontsize = (*ai).Size; // �������� �� ����������

    Attribute.Size = (ui8)fontsize;
    if (fontsize > 3)
        m_fBigFont = true;

INSERT_OPERATION:

    if (++ai == end()) {
        push_back(Attribute);
        if (GetSize() > maxDepth)
            maxDepth = GetSize();
    } else
        insert(ai, Attribute);
}

//-----------------------------------------------------------------------------
// Fnc: DeleteLastAttribute
// For: ������� ��������� ������� �����
// Get:
// Ret:
//-----------------------------------------------------------------------------
inline void AStackColors::DeleteLastAttribute(void) {
    if (!empty())
        pop_back();
}

//-----------------------------------------------------------------------------
// Fnc: PopAttribute
// For: ���������� �� ����� ���������
// Get: enTagValue - ��� ���� ������������ � �����
// Ret:
//-----------------------------------------------------------------------------
bool AStackColors::PopAttribute(HT_TAG enValue) {
    bool fdel = false;
    if (empty())
        return true;

    ATTR_ITER ai = GetIteratorToAttribute();

    if (enValue != HT_TABLE && enValue != HT_TR && enValue != HT_TD) {
        if ((*ai).enValue == enValue) {
            DeleteLastAttribute();
            fdel = true;

        } else if (ai != begin()) {
            for (--ai;; --ai) {
                if ((*ai).enValue == HT_TABLE ||
                    (*ai).enValue != HT_TR ||
                    (*ai).enValue != HT_TD ||
                    (*ai).enValue != enValue)
                    break;
                if (ai == begin())
                    break;
            }
            //         for (i= StackAttr->Count - 2; i > 0; i--)
            //         {
            //            pAttribute = (tagAttribute *)StackAttr->At(i);
            //            if (pAttribute->enValue == enTable ||
            //                pAttribute->enValue != enTr    ||
            //                pAttribute->enValue != enTd    ||
            //                pAttribute->enValue != enValue)
            //                break;
            //         }
            if ((*ai).enValue == enValue) {
                erase(ai);
                fdel = true;
                //            for ( ; i < StackAttr->Count; i++)
                //            {
                //                pAttribute = (tagAttribute *)StackAttr->At(i);
                //                PushAttribute(*pAttribute,i);
                //            }
            }
        }
        return fdel;
    }

    if (!OpenTableCount)
        return true;

    switch (enValue) {
        case HT_TABLE:
            OpenTableCount--;
            while (ai != begin() && (*ai).enValue != HT_TABLE) {
                --ai;
                DeleteLastAttribute();
                fdel = true;
            }
            if ((*ai).enValue == HT_TABLE)
                DeleteLastAttribute();
            break;
        case HT_TR:
            while (ai != begin() && (*ai).enValue != HT_TABLE && (*ai).enValue != HT_TR) {
                --ai;
                DeleteLastAttribute();
                fdel = true;
            }
            if ((*ai).enValue == HT_TR) {
                DeleteLastAttribute();
                fdel = true;
            }
            break;
        case HT_TD:
            while (ai != begin() &&
                   (*ai).enValue != HT_TABLE &&
                   (*ai).enValue != HT_TR &&
                   (*ai).enValue != HT_TD) {
                --ai;
                DeleteLastAttribute();
                fdel = true;
            }
            if ((*ai).enValue == HT_TD) {
                DeleteLastAttribute();
                fdel = true;
            }
            break;
        default:
            break;
    }

    return fdel;
}

//-----------------------------------------------------------------------------
// Fnc: IsVisibleText
// For: ��������� �������� �� ����� �������
// Get:
// Ret: ���� ����� - ������� �� result == true
//-----------------------------------------------------------------------------
bool AStackColors::IsVisibleText(bool* pfNear) {
    if (empty())
        return true;
    ATTR_ITER ai = GetIteratorToAttribute();
    //   bool res = (*ai).Color != (*ai).BgColor  || (OpenTableCount && !(*ai).IsTd);

    *pfNear = false;
    if (OpenTableCount && !(*ai).IsTd)
        return true;
    if ((*ai).Color == (*ai).BgColor)
        return false;

    if (IsNearColors()) {
        *pfNear = true;
        return false;
    }
    return true;
#ifdef UNVISIBLE_DEB
    if (!res)
        spprinttext("\nColor: %x  ", (*ai).Color);
#endif
    //   return res;
}

//-----------------------------------------------------------------------------
// Fnc: IsNearColors
// For: ��������� �������� �� ����� �������������� �� ������ ����
// Get:
// Ret: ���� ����� - ������� �� result == true
//-----------------------------------------------------------------------------
bool AStackColors::IsNearColors(void) {
    bool res = false;
    if (empty())
        return false;
    ATTR_ITER ai = GetIteratorToAttribute();
    if (OpenTableCount && !(*ai).IsTd)
        return false;
    ui32 Color = (*ai).Color;
    ui32 BgColor = (*ai).BgColor;

    ui8 r, g, b;
    ui8 fr, fg, fb;
    int r1, g1, b1;

    ColorToRGB(Color, &r, &g, &b);
    ColorToRGB(BgColor, &fr, &fg, &fb);

    r1 = ((int)r - (int)fr);
    g1 = ((int)g - (int)fg);
    b1 = ((int)b - (int)fb);
    double c = 255 * 255;

    double d = (r1 * r1) / c + (g1 * g1) / c + (b1 * b1) / c;
    if (d < 0.06)
        res = true;

#ifdef UNVISIBLE_DEB
    if (res)
        spprinttext("\nNear colors: BgColor = %x  Color = %x", (*ai).BgColor, (*ai).Color);
#endif
    return res;
}

void AStackColors::ColorToRGB(ui32 color, ui8* r, ui8* g, ui8* b) {
    *r = color & 0xff;
    color >>= 8;
    *g = color & 0xff;
    color >>= 8;
    *b = color & 0xff;
}

ui32 AStackColors::GetTextColor() {
    if (empty())
        return 0;
    ATTR_ITER ai = GetIteratorToAttribute();
    return (*ai).Color;
}

ui8 AStackColors::GetSize() {
    if (empty())
        return 3;
    ATTR_ITER ai = GetIteratorToAttribute();
    return (*ai).Size;
}

// *************
// ATagParsing
// *************

//-----------------------------------------------------------------------------
// Fnc: ATagParsing
// For: Create ATagParsing object.
// Get: hInstance
// Ret: code err
//-----------------------------------------------------------------------------

ATagParsing::ATagParsing(int MaxTag) {
    StackColors = nullptr;
    pColorMap = nullptr;
    pSpamColors = nullptr;
    memset(SizeCount, 0, sizeof(SizeCount));

    pColorMap = new ColorMapper(&spcolors[0], TStdArraySize<decltype(spcolors)::value_type>::size);

    pSpamColors = new ColorMapper();
    pSpamColors->AddColor("navy");
    pSpamColors->AddColor("gray");
    pSpamColors->AddColor("red");
    pSpamColors->AddColor("white");

    m_MaxTag = MaxTag;
    m_pStTags.resize(MaxTag);

    return;
}
ATagParsing::~ATagParsing() {
    if (StackColors)
        delete StackColors;
    if (pColorMap)
        delete pColorMap;
    DELETE_OBJ(pSpamColors);
};

//-----------------------------------------------------------------------------
// Fnc: DeleteAll
// For: ������������� �������
// Get:
// Ret: code err
//-----------------------------------------------------------------------------

void ATagParsing::InitMessage() {
    TagCount = 0;
    NotVisbleCount = 0;
    IsAlwaysVisible = false;
    IsLink = false;
    IsStyle = false;

    m_fSpamNames = false;
    m_fColor_unknown = false;

    LastAttribute = {};
    m_pStTags.assign(m_MaxTag, 0);

    if (StackColors)
        delete StackColors;
    StackColors = new AStackColors();
    return;
}
//-----------------------------------------------------------------------------
// Fnc: IsTagWhiteSpace
// For: Symbol checking  on tag whitespace
// Get: cur - symbol
// Ret: if symbol is tag whitespace return true
//-----------------------------------------------------------------------------
bool ATagParsing::IsTagWhiteSpace(unsigned char cur) {
    if (!cur || cur == 32 || cur == 160 || cur == 10 || cur == 13 || cur == 9 || cur == '"' || cur == '\'')
        return true;
    else
        return false;
}
//-----------------------------------------------------------------------------
// Fnc: IsWhiteSpace
// For: Symbol checking  on  whitespace
// Get: cur - symbol
// Ret: if symbol is whitespace return true
//-----------------------------------------------------------------------------
bool ATagParsing::IsWhiteSpace(unsigned char cur) {
    if (cur == 32 || cur == 160 || cur == 10 || cur == 13 || cur == 9)
        return true;
    else
        return false;
}

void ATagParsing::SetContent(const char* pTag, int len) {
    if (len < 2)
        m_entcont = enCempty;
    else {
        m_entcont = enCset;
        STRNCPYLWR(m_sztag_content, pTag, MAX_TAG_CONTENT, len);
    }
}

bool ATagParsing::ExistsTagOption(const char* pTag, int len, char* pszOptionName) {
    if (m_entcont == enCunset)
        SetContent(pTag, len);
    if (m_entcont == enCempty)
        return false;

    return (strstr(m_sztag_content, pszOptionName)) ? true : false;
}

bool ATagParsing::GetTagOption(const char* pTag, int len, char* pszOptionName, char* pszOptionValue) {
    if (m_entcont == enCunset)
        SetContent(pTag, len);
    if (m_entcont == enCempty)
        return false;

    return GetTagOption(m_sztag_content, pszOptionName, pszOptionValue);
}
//-----------------------------------------------------------------------------
// Fnc: GetTagOption
// For: Get value  of tag option
// Get: pszTag        - tag name
//      pszOptionName - option name
// Ret: if option exists return true
//      pszOptionValue - option value
//-----------------------------------------------------------------------------
bool ATagParsing::GetTagOption(const char* pTag, char* pszOptionName, char* pszOptionValue) {
    bool res = false;
    i32 iCount;
    ui32 OptionNameLen = strlen(pszOptionName);
    const char* pszOption;

    *pszOptionValue = 0;

    if (!(pszOption = strstr(pTag, pszOptionName)))
        return res; // option is not found

    // To distinguish options "BGCOLOR" and "COLOR" and other
    if (!IsTagWhiteSpace(*(pszOption - 1)) ||
        !(pszOption[OptionNameLen] == '=' || IsTagWhiteSpace(pszOption[OptionNameLen]))) {
        res = GetTagOption(pszOption + 1, pszOptionName, pszOptionValue);
        return res;
    }

    // now is founded  and value is readed
    pszOption += OptionNameLen;
    while (*pszOption == '=' || IsTagWhiteSpace(*pszOption))
        pszOption++;
    for (iCount = 0; iCount < MaxLenTagValue - 1; iCount++)
        if (IsTagWhiteSpace(pszOption[iCount]))
            break;
    memcpy(pszOptionValue, pszOption, iCount);
    pszOptionValue[iCount] = 0;
    res = true;

    return res;
}

// Normalize string #tsff00 => #00ff00
void NormalizeStr(char* str) {
    char ch;
    for (int i = 0; i < 8; i++) {
        ch = str[i];
        if (!ch)
            break;
        if (!(ch >= '0' && ch <= '9' ||
              ch >= 'a' && ch <= 'f'))
            str[i] = '0';
    }
    return;
}
//-----------------------------------------------------------------------------
// Fnc: GetColorOption
// For: Get value  of tag color option
// Get: pszTag        - tag name
//      pszOptionName - option name
// Ret: if option exists return true
//      dwOptionValue - color value
//-----------------------------------------------------------------------------
bool ATagParsing::GetColorOption(const char* pTag, int len, char* pszOptionName, ui32* dwOptionValue, bool fColorAttr) {
    bool res = false;
    char szOptionValue[MaxLenTagValue], *pszOptionValue = szOptionValue + 1;

    res = GetTagOption(pTag, len, pszOptionName, szOptionValue);
    if (!res)
        return res;

    if (strchr(szOptionValue, '.'))
        IsAlwaysVisible = true;

    if (*szOptionValue == '#') // is numeric ffff0000
    {
        NormalizeStr(pszOptionValue);
        StrToHexCommon(pszOptionValue, dwOptionValue);
        if (!(*dwOptionValue) && strlen(pszOptionValue))
            if (pszOptionValue[strlen(pszOptionValue) - 1] != '0')
                *dwOptionValue = 1;
    } else { // is mnemonic - "red"

        const auto lowered = to_lower(TString(szOptionValue));
        auto it = pColorMap->find(lowered);
        if (it != std::end(*pColorMap)) {
            *dwOptionValue = it->second;
            if (fColorAttr && !m_fSpamNames && !pSpamColors->contains(lowered))
                m_fSpamNames = true;
        } else {
            NormalizeStr(pszOptionValue);
            StrToHexCommon(pszOptionValue, dwOptionValue);
            if (!(*dwOptionValue) && strlen(pszOptionValue))
                if (pszOptionValue[strlen(pszOptionValue) - 1] != '0')
                    *dwOptionValue = 1;
        }
    }

    return res;
}

//-----------------------------------------------------------------------------
// Fnc: GetSizeOption
// For: Get value  of tag size option
// Get: pszTag        - tag name
// Get: pszOptionName - option name
// Ret: if option exists return true
//      SizeValue,Plus - option value
//      SizeValue may be from 1 to 7 , Plus = {'!','+','-',0}
//-----------------------------------------------------------------------------
bool ATagParsing::GetSizeOption(const char* pTag, int len, ui8* SizeValue, char* Plus) {
    bool res = false;
    char szOptionValue[MaxLenTagValue], *pszOptionValue = szOptionValue;

    res = GetTagOption(pTag, len, (char*)"size", szOptionValue);
    if (!res)
        return res;

    if (*pszOptionValue == '+' || *pszOptionValue == '-')
        *Plus = *pszOptionValue++;
    else
        *Plus = '!';

    if (*pszOptionValue >= '0' && *pszOptionValue <= '7')
        *SizeValue = *pszOptionValue - '0';
    else
        *SizeValue = 3;

    return res;
}

void ATagParsing::SetColor(tagAttribute& Attribute, ui32 StColor, ui32 StBgColor, bool* fStColorSet) {
    *fStColorSet = true;
    if (StColor != NO_COLOR)
        Attribute.InpColor = StColor;
    if (StBgColor != NO_COLOR)
        Attribute.InpBgColor = StBgColor;
}

//-----------------------------------------------------------------------------
// Fnc: TreatTag
// For: �������� ������� ��������� ����
// Get: pszTag - ��������� �� ������ ����
//      bool   - ������� ������������ ����
// Ret:
//-----------------------------------------------------------------------------
void ATagParsing::TreatTag(HT_TAG enValue, int flag, const char* pTag, int len,
                           bool fClosing, ui32 StColor, ui32 StBgColor) {
    const ui8 BoldSize = 1, BigSize = 1, ThSize = 1;
    ui32 ColorValue;
    ui8 SizeValue;
    char Plus;
    bool fStColorSet = false;
    tagAttribute Attribute = {0, 0, 0, 0, 0, 0, 0, NO_COLOR, NO_COLOR, enValue, false, TagCount};

    TagCount++;
    m_entcont = enCunset;

    // ��������� �� �����
    if (fClosing) {
        switch (enValue) {
            case HT_A:
                IsLink = false;
                break;
            case HT_STYLE:
                IsStyle = false;
                break;
            default:
                break;
        }

        if (STACK_TAG(flag))
            StackColors->PopAttribute(enValue);
        if (m_pStTags[enValue] > 0 && StackColors->PopAttribute(enValue))
            --m_pStTags[enValue];
        return;
    }

    switch (enValue) {
        case HT_A:
            IsLink = true;
            break;
        case HT_STYLE:
            //             IsStyle = true;
            //             IsAlwaysVisible = true;
            break;
        case HT_DIV:
            //             if (GetTagOption(pTag, len, "style", m_szOptionValue) && strstr(m_szOptionValue,"color"))
            //                 IsAlwaysVisible = true;
            break;
        case HT_B:
        case HT_STRONG:
            SetH(BoldSize);
            break;
        case HT_BIG:
            SetH(BigSize);
            break;
        case HT_BODY:
            if (GetColorOption(pTag, len, (char*)OP_BGCOLOR, &ColorValue, false))
                Attribute.InpBgColor = ColorValue;
            if (GetColorOption(pTag, len, (char*)OP_TEXT, &ColorValue, true)) // ?
                Attribute.InpColor = ColorValue;
            SetColor(Attribute, StColor, StBgColor, &fStColorSet);
            //             GetColorOption(pTag, len, (char *)OP_BACKGROUND, &ColorValue);
            break;
        case HT_BASEFONT:
            if (GetSizeOption(pTag, len, &SizeValue, &Plus)) {
                Attribute.InpPlus = '!';
                Attribute.InpSize = SizeValue;
            }
            if (GetColorOption(pTag, len, (char*)OP_COLOR, &ColorValue, true)) {
                Attribute.InpColor = ColorValue;
            }
            SetColor(Attribute, StColor, StBgColor, &fStColorSet);
            break;
        case HT_FONT:
            if (GetSizeOption(pTag, len, &SizeValue, &Plus)) {
                Attribute.InpPlus = Plus;
                Attribute.InpSize = SizeValue;
            }
            if (GetColorOption(pTag, len, (char*)OP_COLOR, &ColorValue, true))
                Attribute.InpColor = ColorValue;
            SetColor(Attribute, StColor, StBgColor, &fStColorSet);
            break;
        case HT_TH:
            if (GetColorOption(pTag, len, (char*)OP_BGCOLOR, &ColorValue, false))
                Attribute.InpBgColor = ColorValue;
            SetH(ThSize);
            SetColor(Attribute, StColor, StBgColor, &fStColorSet);
            break;
        case HT_TABLE:
        case HT_TR:
        case HT_TD:
            if (GetColorOption(pTag, len, (char*)OP_BGCOLOR, &ColorValue, false))
                Attribute.InpBgColor = ColorValue;
            SetColor(Attribute, StColor, StBgColor, &fStColorSet);
            break;
        case HT_H1:
            SetH(6);
            break;
        case HT_H2:
            SetH(5);
            break;
        case HT_H3:
            SetH(4);
            break;
        case HT_H4:
            SetH(3);
            break;
        case HT_H5:
            SetH(2);
            break;
        case HT_H6:
            SetH(1);
            break;
        default:
            break;
    }

    if (STACK_TAG(flag))
        StackColors->PushAttribute(Attribute, StackColors->end());
    if (!fStColorSet && (StColor != NO_COLOR || StBgColor != NO_COLOR)) {
        ++m_pStTags[enValue];
        tagAttribute AttributeSt =
            {0, 0, 0, 0, 0, 0, 0, StColor, StBgColor, enValue, false, TagCount};
        StackColors->PushAttribute(AttributeSt, StackColors->end());
    }
    return;
}
//-----------------------------------------------------------------------------
// Fnc: SetFont
// For: Set current text attribute
// Get: IsTagTesting - may be true only in test exe module
// Ret: false - carrent text attribute and previous is same
//      IsVisible == true - text is visible
//      CurrentFontSize   - text font size
//      buf  - buffer with output information
//-----------------------------------------------------------------------------
bool ATagParsing::SetFont(bool* IsVisible, ui8* CurrentFontSize, bool /*IsTagTesting*/, bool* OutIsStyle) {
    tagAttribute Attribute;

    *OutIsStyle = IsStyle;

    bool fNear;

    StackColors->GetAttribute(&Attribute);
    if (Attribute.Color == LastAttribute.Color && Attribute.BgColor == LastAttribute.BgColor && Attribute.Size == LastAttribute.Size)
        return false;
    else {
        LastAttribute.Color = Attribute.Color;
        LastAttribute.BgColor = Attribute.BgColor;
        LastAttribute.Size = Attribute.Size;
    }
    *IsVisible = StackColors->IsVisibleText(&fNear) | IsLink;
    if (IsAlwaysVisible) {
        *IsVisible = true;
    } else if (!*IsVisible) {
        //      Color[8] = 0;
        //      BgColor[8] = 0;
        //      HexToStr(Color,Attribute.Color);
        //      HexToStr(BgColor,Attribute.BgColor);
        if (!IsStyle)
            NotVisbleCount++;
    }

    *CurrentFontSize = Attribute.Size;
    //   if ( IsTagTesting) // only test filthtm.exe code
    //   {
    //      if (!*IsVisible)
    //      {
    //         if (Attribute.BgColor > 0xffff)
    //           strcpy(buf,"<font color = 0x000000>  TEXT IS NOT VISIBLE  </font>");
    //         else
    //            strcpy(buf,"<font color = 0xffffff>  TEXT IS NOT VISIBLE  </font>");
    //      }
    //      else
    //        *buf = 0;
    //     sprintf(buf + strlen(buf),"  TN = %u TSIZE = %u  ",Attribute.Count,Attribute.Size);
    //   }
    //   else
    //   {
    //      buf[0] = LABEL_OF_FONT_SIZE;
    //      buf[1] = Attribute.Size;
    //      buf[2] = 0;
    //   }

    return true;
}
/*
//-----------------------------------------------------------------------------
// Fnc: GetSummary
// For: Set current text attribute
// Get: IsTagTesting - may be true only in test exe module
//      MiddleFontSize  - average text font size
//      FileName        - document file name
// Ret: buf  - buffer with output information
//-----------------------------------------------------------------------------
void ATagParsing::GetSummary(char * buf,char *FileName,bool IsTagTesting)
{
tagAttribute  Attribute;

 MiddleFontSize = CalcMiddleFontSize();

 if (IsTagTesting)
 {
    StackColors->GetAttribute(&Attribute);
    if (Attribute.BgColor > 0xffff)
      strcpy(buf,"<br><font color = 0x000000>");
    else
      strcpy(buf,"<br><font color = 0xffffff>");
    sprintf(buf + strlen(buf)," NOT VISIBLE TEXT FRAGMENT COUNT = %u  <br>",NotVisbleCount);
    sprintf(buf + strlen(buf),"Middle font size = %u </font> <br>",MiddleFontSize);
 }
 else
 {
    buf[0] = (char)MiddleFontSize;
    if (NotVisbleCount)
       logfsto ("filt_vis.log", "%u not visible fragment in file = %s",NotVisbleCount,FileName);
 }
}
*/
//-----------------------------------------------------------------------------
// Fnc: CalcMiddleFontSize
// For: Calculate middle document text font size
// Get:
// Ret: Middle document text font size
//-----------------------------------------------------------------------------
ui8 ATagParsing::CalcMiddleFontSize(void) {
    ui8 i;
    ui8 ExtremeIndex = 1;

    for (i = 2; i < MaxFontSize; i++)
        if (SizeCount[ExtremeIndex] <= SizeCount[i])
            ExtremeIndex = i;

    return ExtremeIndex;
}
/*
//-----------------------------------------------------------------------------
// Fnc: SetWeigts
// For: Settingt text weight
// Get: size  - text font size
// Ret: Text weight
//-----------------------------------------------------------------------------
ui8 ATagParsing::GetWeight(ui8 size)
{
  enText_Weights  TextWeight = Weight_Normal;

    if (size + 1 < MiddleFontSize)
       TextWeight = Weight_Low;
    else if (size < MiddleFontSize + 2)
       TextWeight = Weight_Normal;
    else if (size < MiddleFontSize + 4)
       TextWeight = Weight_Heavy;
    else
       TextWeight = Weight_Super;
    if (size > 7)
       size = 7;
    else if (size < 1)
       size = 1;
    size <<= 2;
    size += TextWeight;

    return size;
}
*/

void ATagParsing::StrToHexCommon(char* str, ui32* value) {
    ui32 b = 0;
    int c = 0;

    ui8* p = (ui8*)str;

    while (*p && isxdigit(*p)) {
        ++c;
        b = b << 4;
        b += (xdigit(*p));
        p++;
    }

    if (c != 6)
        m_fColor_unknown = true;

    *value = b;
}

bool ATagParsing::GetRgbByName(char* szname, ui32* rgb, bool fColorAttr) {
    const auto lowered = to_lower(TString(szname));
    auto it = pColorMap->find(lowered);
    if (it != pColorMap->end()) {
        *rgb = it->second;
        if (fColorAttr && !m_fSpamNames) {
            it = pSpamColors->find(lowered);

            if (it == pColorMap->end())
                m_fSpamNames = true;
            else
                *rgb = it->second;
        }

        return true;
    }

    return false;
}
