#pragma once

#ifndef __TAGPARS_H__
#define __TAGPARS_H__

#include <list>
//#ifdef SO_OLD_BUILD
//#  include "ht_tags.h"
//#else
#include "library/cpp/html/spec/tags.h"
//#endif
#include "mail/so/spamstop/tools/so-common/sputil.h"

static constexpr int MaxLenTagValue = 32;
static constexpr int ResourceSize = 2644;

#define OP_COLOR "color"
#define OP_BGCOLOR "bgcolor"
#define OP_BACKGROUND "background"
#define OP_TEXT "text"

#define NO_COLOR 0xFFFFFFFF

struct tagAttribute {
    ui32 Color{};       // ����  ������
    ui32 BgColor{};     // ���� ����
    ui8 Size{};         // ������ ������
    ui8 BaseFontSize{}; // ������ ���������� BaseFont
    ui8 PlusSize{};     // ������ ���������� ������ ���� <b>
    ui8 InpSize{};      // ������ �������� ������
    char InpPlus{};    // ������ ������
    ui32 InpColor{};    // ����  ������
    ui32 InpBgColor{};  // ���� ����
    HT_TAG enValue{};  // ��� ����
    bool IsTd{};       // ����� ���  <td>
    ui32 Count{};       // ���������� ����� ����
};

// Color,BgColor,Size,BaseFontSize - ��������� ����� ���������
// InpColor,InpBgColor,InpSize,InpPlus  -  ��������� ���
// InpPlus = {'+','-','!',0}
// '+' - InpSize ���� ��������
// '-' - InpSize ���� �������
// '!' - InpSize ���� ����������
//  0  - ��� �� ������ ������ ������
//  ���� InpColor,InpBgColor == NO_COLOR (0xFFFFFFFF) ��� �� ������ ���������������� �����

typedef std::list<tagAttribute>::iterator ATTR_ITER;

#define MaxFontSize 255

class TMapTag;

//
// AStackColors - ����� ��� ����������� ��������� ��������� ������:
//    ���� ������, ���� ����, ������ ������.
//
class AStackColors: public std::list<tagAttribute> {
    ui16 OpenTableCount; // ���������� �������� ������
    ui32 BodyColor;      // ���� ������ ���������� ����� Body
    ui32 BodyBgColor;    // ���� ���� ���������� ����� Body
    bool m_fBigFont;
    int maxDepth;

    void SetColor(tagAttribute& Attribute);
    void ColorToRGB(ui32 color, ui8* r, ui8* g, ui8* b);

public:
    AStackColors();
    inline ATTR_ITER GetIteratorToAttribute(void);
    inline void DeleteLastAttribute(void);
    void GetAttribute(tagAttribute* Attribute);
    void PushAttribute(tagAttribute Attribute, ATTR_ITER ai);
    bool PopAttribute(HT_TAG enTagValue);
    bool IsVisibleText(bool* pfNear);
    bool IsNearColors(void);
    bool IsBigFont() {
        return m_fBigFont;
    }
    ui8 GetSize();
    ui32 GetTextColor();
    int GetMaxDepth() {
        return maxDepth;
    };
};

struct TIdName {
    const ui32 Id;
    const char *const Name;
};

#define MAX_TAG_CONTENT 4096
#define MAX_OPTION_VALUE 1024

class ColorMapper : public THashMap<TString, ui32> {
public:
    ColorMapper(const TIdName* rg, size_t cnt) {
        for (size_t i = 0; i < cnt; i++)
            emplace(rg[i].Name, rg[i].Id);
    }
    ColorMapper() = default;

    void AddColor(const char* name) {
        emplace(name, 0);
    }
};

class ATagParsing {
    ColorMapper* pColorMap;
    ColorMapper* pSpamColors;
    size_t TagNamesLens[64];    // ����� ���� ����� � ������� TagNames
    ui32 TagCount;               // ���������� ����� ����
    tagAttribute LastAttribute; //��������� ������������� � ������ ���
    ui32 NotVisbleCount;         // ���������� ��������� ���������� ������

    AStackColors* StackColors; // ���� ��� �������� ����� ���� ������ ������
    ui8 MiddleFontSize;         // Middle fony size by document

    bool IsLink;          // ���������� ����� �����
    bool IsAlwaysVisible; // = true, ���� ������������ �����
    bool IsStyle;         // define tag <style>
    enum TagContentState { enCunset,
                           enCset,
                           enCempty } m_entcont;
    char m_sztag_content[MAX_TAG_CONTENT + 1];
    char m_szOptionValue[MAX_OPTION_VALUE + 1];
    TVector<int> m_pStTags;
    int m_MaxTag;
    ui32 dwOptionValue;

    bool m_fSpamNames;
    bool m_fColor_unknown;

    bool IsTagWhiteSpace(unsigned char);
    bool IsWhiteSpace(unsigned char);
    bool ExistsTagOption(const char* pTag, int len, char* pszOptionName);
    bool GetTagOption(const char* pTag, int len, char* pszOptionName, char* pszOptionValue);
    bool GetTagOption(const char* pTag, char* pszOptionName, char* pszOptionValue);
    bool GetColorOption(const char* pTag, int len, char* pszOptionName,
                        ui32* dwOptionValue, bool fColorAttr);
    bool GetSizeOption(const char* pTag, int len, ui8* SizeValue, char* Plus);
    void SetContent(const char* pTag, int len);
    ui8 CalcMiddleFontSize(void);
    void StrToHexCommon(char* str, ui32* value);
    void SetColor(tagAttribute& Attribute, ui32 StColor, ui32 StBgColor, bool* fStColorSet);

public:
    ui32 SizeCount[MaxFontSize]; // Counter - how much letters with that (index) size
    ATagParsing(int MaxTag);
    ~ATagParsing();
    void InitMessage();
    void TreatTag(HT_TAG enValue, int flag, const char* pTag, int len,
                  bool fClosing, ui32 Color, ui32 BgColor);
    void GetAttribute(tagAttribute* Attribute);
    bool SetFont(bool* IsVisible, ui8* CurrentFontSize, bool IsTagTesting, bool* OutIsStyle);
    bool IsVisibleText(bool* pfNear) {
        return IsAlwaysVisible | StackColors->IsVisibleText(pfNear);
    }
    ui8 GetSize() {
        return StackColors->GetSize();
    }
    bool IsBigFont() {
        return StackColors->IsBigFont();
    }
    bool IsSpamName() {
        return m_fSpamNames;
    }
    bool IsColorUnknown() {
        return m_fColor_unknown;
    }
    bool GetRgbByName(char* szname, ui32* rgb, bool fColor);
    ui32 GetTextColor() {
        return StackColors->GetTextColor();
    }
    int GetHTMLDepth() {
        return StackColors->GetMaxDepth();
    }
};

#define SetH(num)            \
    Attribute.InpPlus = '+'; \
    Attribute.InpSize = num;

#endif
