#include <library/cpp/testing/unittest/registar.h>
#include "dkim_signature.h"

Y_UNIT_TEST_SUITE(Dkim) {

    Y_UNIT_TEST(Parse) {
        const TStringBuf dkimSrc = "DKIM-Signature: v=1; a=rsa-sha1; q=dns/txt; l=45769; s=ljcomprod;\n"
                                   "c=simple/simple;\n"
                                   "h=From:To;\n"
                                   "d=livejournal.com\t; i=@livejournal.com;\n"
                                   "bh=agFuLSy2JNbSifiQb0Mx1YJFepw=;\n"
                                   "b=dl8Ds/LpVPlIG9Itsw/7HqzSCmjYBzXDVSf8NfaAxf+5wP9DmPH/e/ptPYBOk85zIHDod4KeXQrrMaTGQ6Un2SrOIY2d96RWbNtSfapaXHcBGSU8VVnQLCmPaN/At+QAjzk9oj+kCWytvI8E+Gx6U7FIPH3XGj609USknDq5I0SdfbnpGNiSvZnpCkEh/gjHu2txuX/kQIpdh0RaIYuu7mrBok01nEwsiJgK7bCkeC++PML30d51bRwHIT7rya5a";
        const auto dkim = TDkim::Parse(dkimSrc);

        UNIT_ASSERT_VALUES_EQUAL(dkim.GetB(), "dl8Ds/LpVPlIG9Itsw/7HqzSCmjYBzXDVSf8NfaAxf+5wP9DmPH/e/ptPYBOk85zIHDod4KeXQrrMaTGQ6Un2SrOIY2d96RWbNtSfapaXHcBGSU8VVnQLCmPaN/At+QAjzk9oj+kCWytvI8E+Gx6U7FIPH3XGj609USknDq5I0SdfbnpGNiSvZnpCkEh/gjHu2txuX/kQIpdh0RaIYuu7mrBok01nEwsiJgK7bCkeC++PML30d51bRwHIT7rya5a");
        UNIT_ASSERT_VALUES_EQUAL(dkim.GetDomain(), "livejournal.com");
        UNIT_ASSERT_VALUES_EQUAL(dkim.GetS(), "ljcomprod");
    }
}

