#include <library/cpp/testing/unittest/registar.h>

#include "models.h"


Y_UNIT_TEST_SUITE(TDict) {
    Y_UNIT_TEST(SuccessLoadCatboostDict) {

        const TString test = "0\tLabel\n"
                             "1\tNum\tDNSBL_0\n"
                             "2\tNum\tDNSBL_1\n"
                             "3\tNum\tDNSBL_T\n";

        TStringInput input(test);

        const auto dict = LoadCatboostDict(input, 3);

        UNIT_ASSERT_EQUAL(dict.maxIndex, 3);

        const THashMap<TString, size_t> expected{
                {"DNSBL_0", 0},
                {"DNSBL_1", 1},
                {"DNSBL_T", 2},
        };

        UNIT_ASSERT_EQUAL(dict.featuresIndexesMap, expected);
    }
    Y_UNIT_TEST(FailLoadCatboostDict) {
        {
            const TString test = "0\tLabel\n"
                                 "1\tCateg\tDNSBL_0\n"
                                 "2\tNum\tDNSBL_1\n"
                                 "3\tNum\tDNSBL_T\n";

            TStringInput input(test);

            UNIT_ASSERT_EXCEPTION(LoadCatboostDict(input, 0), yexception);
        }
        {
            const TString test = "0\tLabel\n"
                                 "1\tNum\tDNSBL_T\n"
                                 "2\tNum\tDNSBL_1\n"
                                 "3\tNum\tDNSBL_T\n";

            TStringInput input(test);

            UNIT_ASSERT_EXCEPTION(LoadCatboostDict(input, 0), yexception);
        }
    }

    Y_UNIT_TEST(SuccessLoadMatrixnetDict) {

        const TString test = "1\tDNSBL_0\t1\n"
                             "2\tDNSBL_1\t1\n"
                             "3\tDNSBL_T\t1\n"
                             "3\tDNSBL_T\t0\n";

        TStringInput input(test);

        const auto dict = LoadMatrixnetDict(input);

        UNIT_ASSERT_EQUAL(dict.maxIndex, 3);

        const THashMap<TString, size_t> expected{
                {"DNSBL_0", 1},
                {"DNSBL_1", 2},
                {"DNSBL_T", 3},
        };

        UNIT_ASSERT_EQUAL(dict.featuresIndexesMap, expected);
    }
    Y_UNIT_TEST(FailLoadMatrixnetDict) {
        {
            const TString test = "1\tDNSBL_0\t1\n"
                                 "2\tDNSBL_1\t1\n"
                                 "3\tDNSBL_T\t1\n"
                                 "4\tDNSBL_T\t1\n";

            TStringInput input(test);

            UNIT_ASSERT_EXCEPTION(LoadMatrixnetDict(input), yexception);
        }
        {
            const TString test = "1\tDNSBL_0\t0\n"
                                 "2\tDNSBL_1\t0\n"
                                 "3\tDNSBL_T\t0\n"
                                 "4\tDNSBL_T\t0\n";

            TStringInput input(test);

            UNIT_ASSERT_EXCEPTION(LoadMatrixnetDict(input), yexception);
        }
    }
};

