#include <library/cpp/testing/unittest/registar.h>
#include "sphtml.h"

Y_UNIT_TEST_SUITE(SpHtmlTest) {
    Y_UNIT_TEST(RemoveEol) {

        for(const auto& [src, expected]: std::initializer_list<std::tuple<TStringBuf, TStringBuf>>{
            {"", ""},
            {" ", " "},
            {"                     ", " "},
            {" test", " test"},
            {"             test", " test"},
            {"test ", "test "},
            {"test                  ", "test "},
            {"te st", "te st"},
            {"te            st", "te st"},
            {"          te            st          ", " te st "},
        }) {
            TString dup(src);
            TSpHtml::RemoveEol(dup);
            UNIT_ASSERT_EQUAL_C(dup, expected, "from '" << src << "' got '" << dup << "' expected '" << expected << "'");
        }
    }
}

