LIBRARY()

OWNER(g:so)

PEERDIR(
    catboost/libs/model
    contrib/libs/cld2
    contrib/libs/icu
    kernel/factor_slices
    kernel/matrixnet
    library/cpp/charset
    library/cpp/digest/old_crc
    library/cpp/html/blob
    library/cpp/html/dehtml
    library/cpp/html/html5
    library/cpp/json
    library/cpp/lua
    library/cpp/vowpalwabbit
    library/cpp/iterator
    library/cpp/shingles
    library/cpp/enumbitset
    library/cpp/uri
    library/cpp/ipmath
    library/cpp/digest/lower_case
    mail/so/spamstop/tools/lsa/data
    mail/so/spamstop/tools/pcre_wrapper
    mail/so/spamstop/tools/so-clients
    mail/so/spamstop/tools/so-common
    mail/so/spamstop/tools/text2shingles/lib
    mail/so/spamstop/tools/simple_shingler
    mail/so/libs/talkative_config
    mail/so/libs/min_hash
    mail/so/libs/primitives
    mail/so/libs/protect
    mail/so/spamstop/tools/knn_data
    kernel/dssm_applier/nn_applier/lib
    library/cpp/regex/hyperscan
    mlp/mail/text_deobfuscator/lib
    mlp/mail/aspam/domen_factors/lib
    mail/so/libs/lua_rules
    mail/so/spamstop/tools/uids_features_reader/lib
    mlp/mail/aspam/user_factors/lib
    mail/so/libs/mhash
    contrib/libs/libarchive
    contrib/deprecated/mimepp
    dict/recognize/docrec
    dict/dictutil
    library/cpp/threading/atomic_shared_ptr
    library/cpp/svnversion
    library/cpp/monlib/metrics
)

SRCS(
    rengine.cpp
    setrules.cpp
    sphtml.cpp
    sptop.cpp
    tagpars.cpp
    bform.cpp
    arform.cpp
    spamstop.cpp
    spalg.cpp
    spamrule.cpp
    tagattr.cpp
    spbody.cpp
    spstat.cpp
    splingv.cpp
    spruler.cpp
    setlistrule.cpp
    context_symbols.cpp
    spk3.cpp
    rulesholder.cpp
    processing_context.cpp
    rules.cpp
    ip_match.cpp
    archive_reader.cpp
    dkim_signature.cpp
    models.cpp
    chars.cpp
)

CFLAGS(
    -DENV_UNIX
    -DPCRE_STATIC
    -DSO_WITH_IPV6
    -DVERSION_TAG
    -DSO_CMAIL
    -DSPAMSTOP
    -DMIMEPP_STATIC
)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(fields.h)
GENERATE_ENUM_SERIALIZATION_WITH_HEADER(spstat.h)
GENERATE_ENUM_SERIALIZATION_WITH_HEADER(rules_key_words.h)
GENERATE_ENUM_SERIALIZATION_WITH_HEADER(spamrule.h)
GENERATE_ENUM_SERIALIZATION_WITH_HEADER(list_types.h)
GENERATE_ENUM_SERIALIZATION(models.h)

END()
