#include <library/cpp/http/server/response.h>
#include <mail/so/libs/scheduler/scheduler.h>
#include <util/stream/file.h>
#include <util/thread/pool.h>
#include <mail/so/spamstop/tools/simple_shingler/handler_server.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/config/config.h>
#include <mail/so/libs/curl/curl.h>

int main(int argc, const char** argv)
//try
{
    argc--;
    argv++;

    if(argc < 1) {
        Cerr << "Usage: prog <conf.json>" << Endl;
        return 1;
    }

    NConfig::TConfig config;
    {
        TFileInput input(*argv);
        config = NConfig::TConfig::FromJson(input);
    }

    TAdaptiveThreadPool threadPool;

    threadPool.Start(16, 256);

    TSimpleScheduler scheduler(threadPool);


    TServerOptions options;
    options.Port = config["port"].As<ui16>();
    THandlerServer server(
        options,
            &threadPool
    );

    NCurl::TPool pool(TPoolParams(32, TDuration::MilliSeconds(50)));
    const NCurl::TPoolTraits poolTraits(NCurl::TOptions()
                                          .SetMaxAliveConnections(128)
                                          .SetParseBody(true)
                                          .SetParseHeaders(false)
    );


    auto pingHandler = MakeAtomicShared<TPingHandler>();
    server.On("/stop", MakeAtomicShared<TStopServerHandler>(&server, pingHandler))
            .On("/rotate_logs", MakeAtomicShared<TReopenLogHandler>(&server))
            .On("/ping", pingHandler)
            .On("/activ_mail", [&pool, &poolTraits, config](THandleContext &&handleContext, Y_DECLARE_UNUSED void* tsr){
//application/json
                if(!handleContext.cgiParameters.Has("uid"))
                    THttpResponse(HTTP_BAD_REQUEST).SetContent("cannot find uid param", "plain/text").OutTo(handleContext.output);

                ui64 uid = {};

                if(!TryFromString(handleContext.cgiParameters.Get("uid"), uid))
                    THttpResponse(HTTP_BAD_REQUEST).SetContent("cannot parse uid", "plain/text").OutTo(handleContext.output);

                TStringStream request;
                {
                    request << "[\n"
                               "  {\n"
                               "    \"type\": \"Get\",\n"
                               "    \"scheme\": \"activity\",\n"
                               "    \"fields\": [\n"
                               "      {\n"
                               "        \"uid\": " << uid << "\n"
                               "      }\n"
                               "    ]\n"
                               "  }\n"
                               "]";
                }

                NCurl::TPoolItemHolder holder;
                if(!pool.get(poolTraits, holder))
                    THttpResponse(HTTP_INTERNAL_SERVER_ERROR).SetContent("busy", "plain/text").OutTo(handleContext.output);


                auto & curl = holder.Get();

                NCurl::TSimpleArtifacts artifacts;

                curl.Setup(
                    std::move(NCurl::TRequestContext()
                                  .SetHost(config["proxy_host"].As<TString>())
                                  .SetContentType("application/json")
                                  .SetPostData(std::move(request.Str()))));
                if(auto error = curl.Perform(artifacts)) {
                    Cerr << error << Endl;
                    THttpResponse(HTTP_INTERNAL_SERVER_ERROR).SetContent(TString{error->AsStrBuf()}, "plain/text").OutTo(handleContext.output);
                    return;
                }
//{"activ_mail":{"uid":123,"empty":0,"notfound":0,"spam_report":12345678,"settings":12345678,"mobile":12345678,"yserver_imap":12345678,"wmi":12345678,"mailbox_oper":12345678,"yserver_pop":0,"daria":0,"liza":0,"touch":0,"lite":0,"mobile_ios":0,"mobile_android":0,"tablet_ios":0,"tablet_android":0}}

//                [
//                {
//                    "scheme":"activity",
//                            "find":
//                    [
//                    {
//                        "last_dt":1514235600,

                if(artifacts.code != 200) {
                    Cerr << artifacts.code << ", " << artifacts.body.Str() << Endl;
                    THttpResponse(static_cast<HttpCodes>(artifacts.code)).SetContent(artifacts.body.Str()).OutTo(handleContext.output);
                    return;
                }

                const NJson::TJsonValue & value = NJson::ReadJsonTree(&artifacts.body, true);

                NJson::TJsonValue newValue;

                newValue["uid"] = 0;
                newValue["empty"] = 1;
                newValue["notfound"] = 1;
                newValue["spam_report"] = 0;
                newValue["settings"] = 0;
                newValue["mobile"] = 0;
                newValue["yserver_imap"] = 0;
                newValue["wmi"] = 0;
                newValue["mailbox_oper"] = 0;
                newValue["yserver_pop"] = 0;
                newValue["daria"] = 0;
                newValue["liza"] = 0;
                newValue["touch"] = 0;
                newValue["lite"] = 0;
                newValue["mobile_ios"] = 0;
                newValue["mobile_android"] = 0;
                newValue["tablet_ios"] = 0;
                newValue["tablet_android"] = 0;

                for(const auto & item : value.GetArraySafe().front()["find"].GetArraySafe()) {
//                    {
//                        last_dt: 1529564400,
//                            module: "hound",
//                                uid: 575077500
//                    },
                    newValue["empty"] = 0;
                    newValue["notfound"] = 0;
                    newValue["uid"] = item["uid"].GetUIntegerRobust();
                    newValue[item["module"].GetStringRobust()] = item["last_dt"].GetUIntegerRobust();
                }

                TString result;
                {
                    TStringOutput resultStream(result);
                    resultStream << newValue;
                }
                THttpResponse(HTTP_OK).SetContent(result).OutTo(handleContext.output);
            });


    Y_VERIFY(server.Start());

    server.Wait();

    return 0;
}
//catch (const yexception& e) {
//    Cerr << e.what() << Endl;
//    throw e;
//}
//catch (const std::exception& e) {
//    Cerr << e.what() << Endl;
//    throw e;
//}
