#include <fstream>
#include "mimeproc.h"

const size_t BLOCK_SIZE = 1024 * 1024;

std::string ReadStdin()
{
    std::string ret;
    char buf[ BLOCK_SIZE ];
    while( !feof( stdin ) )
    {
        int read = fread( buf, 1, sizeof( buf ), stdin );
        ret += std::string( buf, read );
    }
    return ret;
}

int main()
{
    std::string data = ReadStdin();
    const mimepp::String result = CleanupParts(data.c_str());
    const char* start = result.c_str();

    for( size_t offset = 0; offset < result.size(); offset += BLOCK_SIZE )
        fwrite( start + offset, 1, std::min( BLOCK_SIZE, result.size() - offset ), stdout );

    return 0;
}

