#include "mimeproc.h"

void CleanupParts( mimepp::Body& body )
{
    for( int i = 0; i < body.numBodyParts(); i++ )
    {
        mimepp::BodyPart& part = body.bodyPartAt( i );

        if( part.headers().contentType().type() == "multipart" )
            CleanupParts( part.body() );
        else if( part.headers().contentType().type() == "message" )
        {
            mimepp::Message* msg = part.body().message();
            if( msg )
                CleanupParts( msg->body() );
        }
        else if( part.headers().contentType().type().find( "text" ) == mimepp::String::npos )
            part.body().setString( "" );
    }
}

const mimepp::String CleanupParts(const char* data)
{
    mimepp::Message msg;
    msg.setString(data);
    msg.parse();
    CleanupParts(msg.body());
    msg.assemble();
    return msg.getString();
}
