#include "Python.h"
#include "../mimeproc.h"

static PyObject * attach_rm(PyObject *self, PyObject *args)
{
    const char* msgdata;

    if (!PyArg_Parse(args, "s", &msgdata))
        return NULL;
    mimepp::String result = CleanupParts(msgdata);

    return Py_BuildValue("s", result.c_str());
}

static PyMethodDef AttachRmMethods[] = {
    {"attach_rm", attach_rm, METH_O, "Removes attaches from RFC822 messages."},
    {NULL, NULL, 0, NULL}
};

PyMODINIT_FUNC
init_attach_rm(void)
{
    PyObject *m;

    m = Py_InitModule("_attach_rm", AttachRmMethods);
    if (m == NULL)
        return;
}

