import os
from setuptools import setup, Extension

current_dir = os.path.join(
        os.path.dirname(os.path.abspath(__file__)).split("pyattach_rm")[0],
        "pyattach_rm")

setup(name = 'attach_rm',
      version = '1.0.1',
      description = 'Deleting attaches from RFC822 messages',
      long_description = 'Simple module with one function attach_rm that deletes attaches from RFC822 messages.',
      platforms = "x86_64",
      author = 'Yaroslav Klimik',
      author_email = 'klimiky@yandex-team.ru',
      license = "Yandex LLC",
      url = "https://a.yandex-team.ru/arc/trunk/arcadia/mail/so/spamstop/complhandler/attach_rm/pyattach_rm",
      ext_modules = [Extension('_attach_rm',
          [os.path.join(current_dir, 'pyattach_rm.cpp'),
           os.path.join(current_dir,'../mimeproc.cpp')],
          include_dirs = [os.path.join(current_dir, "..")],
          extra_compile_args = ["-fPIC"],
          extra_link_args = ["-fPIC", os.path.join(current_dir, "../lib/libmimepp.a")])],
      include_dirs = [os.path.join(current_dir, "../../../../../../contrib/deprecated/mimepp/mimepp")],
      py_modules = ['attach_rm'],
)
