#include "antiddosstor.h"

//******************************************************************************
//                                TAntoDDOSStorage
//******************************************************************************

TAntiDDOSStorage::TAntiDDOSStorage() {
    m_live_period = CACHE_LIVE_PERIOD_SEC_DEFAULT;
}

TAntiDDOSStorage::~TAntiDDOSStorage() {
}

void TAntiDDOSStorage::Init(ui32 live_period_sec) {
    m_live_period = live_period_sec;
}

void TAntiDDOSStorage::Add(const TString& so_service, TStorType type, ui64 key_shingle, ui32 counter) {
    ui64 soservice_shingle = 0;
    TAntiDDOSServiceHashIt srvc_it;
    TAntiDDOSKeyValueHashIt kv_it;

    soservice_shingle = ShingleFromStroka(so_service);
    if (type < TAntiDDOSStorage::ST_END) {
        srvc_it = storage[type].find(soservice_shingle);
        if (srvc_it != storage[type].end()) {
            kv_it = (*srvc_it).second.find(key_shingle);
            if (kv_it != (*srvc_it).second.end()) {
                (*kv_it).second.m_date = time(NULL);
                (*kv_it).second.m_count = counter;

            } else {
                (*srvc_it).second[key_shingle] = TAntiDDOSKeyValue(counter);
            }

        } else {
            //storage[type][soservice_shingle] = TAntiDDOSKeyValueHash();
            srvc_it = storage[type].insert(TAntiDDOSServiceHash::value_type(soservice_shingle, TAntiDDOSKeyValueHash())).first;
            if (srvc_it != storage[type].end())
                (*srvc_it).second[key_shingle] = TAntiDDOSKeyValue(counter);
        }
    }
}

bool TAntiDDOSStorage::Get(const TString& so_service, TStorType type, ui64 key_shingle, ui32& counter, int& remain_sec) {
    bool res = false;
    ui64 soservice_shingle = 0;
    TAntiDDOSServiceHashIt srvc_it;
    TAntiDDOSKeyValueHashIt kv_it;
    ui32 current_time = time(NULL);
    int elapsed_time = 0;

    remain_sec = -1;
    soservice_shingle = ShingleFromStroka(so_service);
    if (type < TAntiDDOSStorage::ST_END) {
        srvc_it = storage[type].find(soservice_shingle);
        if (srvc_it != storage[type].end()) {
            kv_it = (*srvc_it).second.find(key_shingle);
            if (kv_it != (*srvc_it).second.end()) {
                if (current_time > (*kv_it).second.m_date)
                    elapsed_time = current_time - (*kv_it).second.m_date;

                if ((elapsed_time > 0) && (elapsed_time < (int)m_live_period)) {
                    remain_sec = m_live_period - elapsed_time;
                    counter = (*kv_it).second.m_count;
                    res = true;

                } else {
                    remain_sec = 0;
                    (*srvc_it).second.erase(kv_it);
                }
            }
        }
    }

    return res;
}

//******************************************************************************
