#pragma once

#include "util/generic/hash.h"
#include "util/generic/string.h"
#include <time.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>

//******************************************************************************
//                                TAntiDDOSStorage
//******************************************************************************

struct TAntiDDOSCriterionInfo {
    bool m_action;
    TString m_so_service;
    TString m_field_key;
    int m_criterion_number;
    ui32 m_criterion_tick;
    ui32 m_all_tick;
    int m_remain_sec;

    TAntiDDOSCriterionInfo() {
        Clear();
    }

    void Clear() {
        m_action = false;
        m_so_service = "";
        m_field_key = "";
        m_criterion_number = -1;
        m_criterion_tick = 0;
        m_all_tick = 0;
        m_remain_sec = -1;
    }

    TString GetReport() {
        char tbuff[2048];

        tbuff[0] = 0x00;
        snprintf(tbuff, sizeof(tbuff) - 1, "%s - FASTREJECT:'%s',cr=%d,remn_sec=%d,cr_tick=%u,all_tick=%u", m_so_service.c_str(), m_field_key.c_str(), m_criterion_number, m_remain_sec, m_criterion_tick, m_all_tick);
        tbuff[sizeof(tbuff) - 1] = 0x00;

        return TString(tbuff);
    }

    TString GetReportControlLog() {
        if (!m_action) {
            return "";

        } else {
            char tbuff[2048];

            tbuff[0] = 0x00;
            snprintf(tbuff, sizeof(tbuff) - 1, "(FASTREJECT:'%s',cr=%d,remn_sec=%d,cr_tick=%u,all_tick=%u)", m_field_key.c_str(), m_criterion_number, m_remain_sec, m_criterion_tick, m_all_tick);
            tbuff[sizeof(tbuff) - 1] = 0x00;

            return TString(tbuff);
        }
    }
};

struct TAntiDDOSKeyValue {
    ui32 m_date;
    ui32 m_count;

    TAntiDDOSKeyValue() {
        Clear();
    }

    TAntiDDOSKeyValue(ui32 value) {
        m_date = time(NULL);
        m_count = value;
    }

    void Clear() {
        m_date = 0;
        m_count = 0;
    }
};

typedef THashMap<ui64, TAntiDDOSKeyValue> TAntiDDOSKeyValueHash;
typedef TAntiDDOSKeyValueHash::iterator TAntiDDOSKeyValueHashIt;

typedef THashMap<ui64, TAntiDDOSKeyValueHash> TAntiDDOSServiceHash;
typedef TAntiDDOSServiceHash::iterator TAntiDDOSServiceHashIt;

class TAntiDDOSStorage {
public:
    static const int CACHE_LIVE_PERIOD_SEC_DEFAULT = /*3600*/ 60;
    enum TStorType { ST_IP,
                     ST_LOGIN,
                     ST_XMPPSERVERNAME,
                     ST_NICK,
                     ST_COMMENT,
                     ST_SUBJECT,
                     ST_END };

private:
    TAntiDDOSServiceHash storage[ST_END];
    ui32 m_live_period;

public:
    TAntiDDOSStorage();
    ~TAntiDDOSStorage();

    void Init(ui32 live_period_sec);
    void Add(const TString& so_service, TStorType type, ui64 key_shingle, ui32 counter);
    bool Get(const TString& so_service, TStorType type, ui64 key_shingle, ui32& counter, int& remain_sec);
};

//******************************************************************************
