#include <mail/so/spamstop/tools/so-common/shtime.h>
#include "kclasses.h"

//****************************************************************************************
//                               KItemStore
//****************************************************************************************

template <class TKey, class TValue>
KItemStore<TKey, TValue>::KItemStore() {
    m_pItemToday = new TKItemHash(INIT_HASH_SIZE);
    m_pItemYesterday = new TKItemHash(INIT_HASH_SIZE);
}

template <class TKey, class TValue>
KItemStore<TKey, TValue>::~KItemStore() {
    delete m_pItemToday;
    delete m_pItemYesterday;
}

template <class TKey, class TValue>
void KItemStore<TKey, TValue>::Lock() {
    //m_Mutex.Acquire();
}

template <class TKey, class TValue>
void KItemStore<TKey, TValue>::UnLock() {
    //m_Mutex.Release();
}

template <class TKey, class TValue>
void KItemStore<TKey, TValue>::Clear() {
    Lock();

    m_pItemToday->clear();
    m_pItemYesterday->clear();

    UnLock();
}

template <class TKey, class TValue>
bool KItemStore<TKey, TValue>::Exists(const TKey Key) {
    typename TKItemHash::iterator i = m_pItemToday->find(Key);
    if (i == m_pItemToday->end())
        return false;
    else
        return true;
}

template <class TKey, class TValue>
bool KItemStore<TKey, TValue>::Add(TKey Key, TValue Val) {
    Lock();

    typename TKItemHash::iterator i = m_pItemToday->find(Key);
    if (i == m_pItemToday->end()) {
        (*m_pItemToday)[Key] = Val;

        UnLock();
        return true;
    } else {
        i->second.Update(Val);

        UnLock();
        return false;
    }
}

template <class TKey, class TValue>
bool KItemStore<TKey, TValue>::Del(TKey Key) {
    Lock();

    typename TKItemHash::iterator i;

    i = m_pItemToday->find(Key);
    if (i != m_pItemToday->end())
        m_pItemToday->erase(i);

    i = m_pItemYesterday->find(Key);
    if (i != m_pItemYesterday->end())
        m_pItemYesterday->erase(i);

    UnLock();

    return true;
}

template <class TKey, class TValue>
size_t KItemStore<TKey, TValue>::Midnight() {
    Lock();

    m_pItemYesterday->clear();
    delete m_pItemYesterday;
    m_pItemYesterday = m_pItemToday;
    m_pItemToday = new TKItemHash(INIT_HASH_SIZE);

    UnLock();

    return m_pItemYesterday->size();
}

template <class TKey, class TValue>
void KItemStore<TKey, TValue>::GetStat(const TKey Ip, TValue& Stat) {
    Stat.Init();

    typename TKItemHash::iterator i = m_pItemToday->find(Ip);
    if (i != m_pItemToday->end())
        Stat.Update(i->second);

    i = m_pItemYesterday->find(Ip);
    if (i != m_pItemYesterday->end())
        Stat.Update(i->second);
}

template <class TKey, class TValue>
void KItemStore<TKey, TValue>::GetStatSeparate(const TKey Ip, TValue& TodayStat, TValue& YesterdayStat) {
    TodayStat.Init();
    YesterdayStat.Init();

    typename TKItemHash::iterator i = m_pItemToday->find(Ip);
    if (i != m_pItemToday->end())
        TodayStat.Update(i->second);

    i = m_pItemYesterday->find(Ip);
    if (i != m_pItemYesterday->end())
        YesterdayStat.Update(i->second);
}

template <class TKey, class TValue>
void KItemStore<TKey, TValue>::GetStatToday(const TKey Ip, TValue& Stat) {
    Stat.Init();

    typename TKItemHash::iterator i = m_pItemToday->find(Ip);
    if (i != m_pItemToday->end())
        Stat.Update(i->second);
}

template <class TKey, class TValue>
size_t KItemStore<TKey, TValue>::GetSize() {
    return (m_pItemToday->size() + m_pItemYesterday->size());
}

template <class TKey, class TValue>
size_t KItemStore<TKey, TValue>::GetSizeToday() {
    return (m_pItemToday->size());
}

template <class TKey, class TValue>
TValue* KItemStore<TKey, TValue>::Find(TKey Key) {
    TValue* res;

    res = NULL;
    typename TKItemHash::iterator i = m_pItemToday->find(Key);
    if (i != m_pItemToday->end())
        res = &i->second;

    return res;
}

template <class TKey, class TValue>
TValue* KItemStore<TKey, TValue>::FindPrev(TKey Key) {
    TValue* res;

    res = NULL;
    typename TKItemHash::iterator i = m_pItemYesterday->find(Key);
    if (i != m_pItemYesterday->end())
        res = &i->second;

    return res;
}

template <class TKey, class TValue>
void KItemStore<TKey, TValue>::WriteDumpSizes(const TString& YesterdayFilename, const TString& TodayFilename) {
    if (YesterdayFilename.size() > 0) {
        typename TKItemHash::iterator i;
        size_t t1 = 0, t2 = 0;

        FILE* yfhandle = fopen(YesterdayFilename.c_str(), "wb");
        if (yfhandle != NULL) {
            i = m_pItemYesterday->begin();
            while (i != m_pItemYesterday->end()) {
                t1 = i->first.size();
                t2 = i->second.size();
                fprintf(yfhandle, "%u - %u\n", t1, t2);
                ++i;
            }
            fclose(yfhandle);
        }

        FILE* tfhandle = fopen(TodayFilename.c_str(), "wb");
        if (tfhandle != NULL) {
            i = m_pItemToday->begin();
            while (i != m_pItemToday->end()) {
                fprintf(tfhandle, "%u - %u\n", i->first.size(), i->second.size());
                ++i;
            }
            fclose(tfhandle);
        }
    }
}

template <class TKey, class TValue>
bool KItemStore<TKey, TValue>::WriteDump(const TString& YesterdayFilename, const TString& TodayFilename) {
    bool res = true;

    Lock();

    if ((YesterdayFilename.size() > 0) && (TodayFilename.size() > 0)) {
        typename TKItemHash::iterator i;
        size_t t1 = 0, t2 = 0;
        size_t count1 = 0, count2 = 0, count3 = 0;
        char* BUFF;
        size_t BuffSize = 0;
        ui32 crc32 = 0;
        TString ident = TString(ISFILEIDENTF);
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;

        FILE* yfhandle = fopen(YesterdayFilename.c_str(), "wb");
        if (yfhandle != NULL) {
            i = m_pItemYesterday->begin();
            while (i != m_pItemYesterday->end()) {
                t1 = i->first.size();
                t2 = i->second.size();
                keysize = t1;
                valsize = t2;
                bodysize = t1 + t2;
                prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);

                BuffSize = prefix_size + t1 + t2;
                if (BuffSize > 0) {
                    BUFF = new char[BuffSize];
                    try {
                        count1 = i->first.GetBuffer(BUFF + prefix_size, BuffSize - prefix_size);
                        if (count1 == t1) {
                            count2 = i->second.GetBuffer(BUFF + prefix_size + count1, BuffSize - prefix_size - count1);
                            if (count2 == t2) {
                                memcpy(BUFF, ident.c_str(), ident.size());
                                memcpy(BUFF + ident.size(), &bodysize, sizeof(bodysize));
                                crc32 = 0;
                                for (int i = prefix_size; i < BuffSize; i++)
                                    crc32 += BUFF[i];
                                memcpy(BUFF + ident.size() + sizeof(bodysize), &crc32, sizeof(crc32));
                                memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32), &keysize, sizeof(keysize));
                                memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), &valsize, sizeof(valsize));

                                count3 = fwrite(BUFF, 1, BuffSize, yfhandle);
                                if (count3 != BuffSize) {
                                    res = false;
                                    break;
                                }
                            }
                        }

                        delete[] BUFF;
                        BUFF = NULL;
                    } catch (...) {
                        delete[] BUFF;
                        BUFF = NULL;
                    }
                }
                ++i;
            }
            fclose(yfhandle);
        }

        if (res) {
            FILE* tfhandle = fopen(TodayFilename.c_str(), "wb");
            if (tfhandle != NULL) {
                i = m_pItemToday->begin();
                while (i != m_pItemToday->end()) {
                    t1 = i->first.size();
                    t2 = i->second.size();
                    keysize = t1;
                    valsize = t2;
                    bodysize = t1 + t2;
                    prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);

                    BuffSize = prefix_size + t1 + t2;
                    if (BuffSize > 0) {
                        BUFF = new char[BuffSize];
                        try {
                            count1 = i->first.GetBuffer(BUFF + prefix_size, BuffSize - prefix_size);
                            if (count1 == t1) {
                                count2 = i->second.GetBuffer(BUFF + prefix_size + count1, BuffSize - prefix_size - count1);
                                if (count2 == t2) {
                                    memcpy(BUFF, ident.c_str(), ident.size());
                                    memcpy(BUFF + ident.size(), &bodysize, sizeof(bodysize));
                                    crc32 = 0;
                                    for (int i = prefix_size; i < BuffSize; i++)
                                        crc32 += BUFF[i];
                                    memcpy(BUFF + ident.size() + sizeof(bodysize), &crc32, sizeof(crc32));
                                    memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32), &keysize, sizeof(keysize));
                                    memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), &valsize, sizeof(valsize));

                                    count3 = fwrite(BUFF, 1, BuffSize, tfhandle);
                                    if (count3 != BuffSize) {
                                        res = false;
                                        break;
                                    }
                                }
                            }

                            delete[] BUFF;
                            BUFF = NULL;
                        } catch (...) {
                            delete[] BUFF;
                            BUFF = NULL;
                        }
                    }
                    ++i;
                }
                fclose(tfhandle);
            }
        }
    }

    UnLock();

    return res;
}

template <class TKey, class TValue>
bool KItemStore<TKey, TValue>::ReadDump(const TString& YesterdayFilename, const TString& TodayFilename) {
    bool res = true;

    Lock();

    if ((YesterdayFilename.size() > 0) && (TodayFilename.size() > 0)) {
        typename TKItemHash::iterator i;
        size_t count1 = 0, count2 = 0;
        char* BUFF;
        size_t BuffSize = 0;
        ui32 crc32 = 0, crc32_a = 0;
        TString ident = TString(ISFILEIDENTF);
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;
        char ShapBuff[1600];

        FILE* yfhandle = fopen(YesterdayFilename.c_str(), "rb");
        if (yfhandle != NULL) {
            prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);
            while (!feof(yfhandle)) {
                count1 = fread(ShapBuff, 1, prefix_size, yfhandle);
                if (count1 == prefix_size) {
                    if (memcmp(ShapBuff, ident.c_str(), ident.size()) == 0) {
                        memcpy(&bodysize, ShapBuff + ident.size(), sizeof(bodysize));
                        memcpy(&crc32, ShapBuff + ident.size() + sizeof(bodysize), sizeof(crc32));
                        memcpy(&keysize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32), sizeof(keysize));
                        memcpy(&valsize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), sizeof(valsize));
                        if ((bodysize > 0) && (bodysize < 100000000) && (bodysize == (keysize + valsize))) //������ �� ����
                        {
                            BuffSize = bodysize;
                            BUFF = new char[BuffSize];
                            try {
                                count2 = fread(BUFF, 1, BuffSize, yfhandle);
                                if (count2 == BuffSize) {
                                    crc32_a = 0;
                                    for (int i = 0; i < BuffSize; i++)
                                        crc32_a += BUFF[i];
                                    if (crc32 == crc32_a) {
                                        (*m_pItemYesterday)[TKey(BUFF, keysize)] = TValue(BUFF + keysize, valsize);

                                    } else
                                        res = false;
                                } else
                                    res = false;

                                delete[] BUFF;
                                BUFF = NULL;
                            } catch (...) {
                                delete[] BUFF;
                                BUFF = NULL;
                            }
                            if (res == false)
                                break;
                        } else {
                            res = false;
                            break;
                        }
                    }
                }
            }
            fclose(yfhandle);
        }

        FILE* tfhandle = fopen(TodayFilename.c_str(), "rb");
        if (tfhandle != NULL) {
            prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);
            while (!feof(yfhandle)) {
                count1 = fread(ShapBuff, 1, prefix_size, tfhandle);
                if (count1 == prefix_size) {
                    if (memcmp(ShapBuff, ident.c_str(), ident.size()) == 0) {
                        memcpy(&bodysize, ShapBuff + ident.size(), sizeof(bodysize));
                        memcpy(&crc32, ShapBuff + ident.size() + sizeof(bodysize), sizeof(crc32));
                        memcpy(&keysize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32), sizeof(keysize));
                        memcpy(&valsize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), sizeof(valsize));
                        if ((bodysize > 0) && (bodysize < 100000000) && (bodysize == (keysize + valsize))) //������ �� ����
                        {
                            BuffSize = bodysize;
                            BUFF = new char[BuffSize];
                            try {
                                count2 = fread(BUFF, 1, BuffSize, tfhandle);
                                if (count2 == BuffSize) {
                                    crc32_a = 0;
                                    for (int i = 0; i < BuffSize; i++)
                                        crc32_a += BUFF[i];
                                    if (crc32 == crc32_a) {
                                        //TKey a(BUFF, keysize);
                                        //TValue b(BUFF + keysize, valsize);

                                        //(*m_pItemToday)[a] = b;

                                        (*m_pItemToday)[TKey(BUFF, keysize)] = TValue(BUFF + keysize, valsize);

                                    } else
                                        res = false;
                                } else
                                    res = false;

                                delete[] BUFF;
                                BUFF = NULL;
                            } catch (...) {
                                delete[] BUFF;
                                BUFF = NULL;
                            }
                            if (res == false)
                                break;
                        } else {
                            res = false;
                            break;
                        }
                    }
                }
            }
            fclose(tfhandle);
        }
    }

    UnLock();

    return res;
}

template <class TKey, class TValue>
bool KItemStore<TKey, TValue>::ReadDump2(const TString& YesterdayFilename, const TString& TodayFilename, ui32& delay, ui32& readcount) {
    bool res = true;
    ui32 read_count_element = 0;
    ui32 m_BeginProcTime = CShingleTime::GetMs();
    delay = 0;
    readcount = 0;

    Lock();

    if ((YesterdayFilename.size() > 0) && (TodayFilename.size() > 0)) {
        TKItemHash* ihash = NULL;
        TString filename = "";
        typename TKItemHash::iterator i;
        size_t count1 = 0, count4 = 0;
        char* BUFF;
        size_t BuffSize = 0;
        ui32 crc32 = 0, crc32_a = 0;
        TString ident = TString(ISFILEIDENTF);
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;
        char ShapBuff[1600];
        char* SPEEDBUFF = NULL;
        ui32 SPEEDBUFFSize = MAXREADDUMPBUFFER;
        ui32 inSPEEDBUFF = 0;
        ui32 SPEEDBUFFpos = 0;

        for (int i = 0; i < 2; i++) {
            switch (i) {
                case 0:
                    ihash = m_pItemYesterday;
                    filename = YesterdayFilename;
                    break;
                case 1:
                    ihash = m_pItemToday;
                    filename = TodayFilename;
                    break;
            };
            FILE* yfhandle = fopen(filename.c_str(), "rb");
            if (yfhandle != NULL) {
                SPEEDBUFF = new char[SPEEDBUFFSize];
                SPEEDBUFFpos = 0;
                while (!feof(yfhandle)) {
                    if ((SPEEDBUFFSize - inSPEEDBUFF) > 0) {
                        count4 = fread(SPEEDBUFF + inSPEEDBUFF, 1, SPEEDBUFFSize - inSPEEDBUFF, yfhandle);
                        inSPEEDBUFF += count4;
                    }
                    if (inSPEEDBUFF > 0) {
                        prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);
                        while ((inSPEEDBUFF - SPEEDBUFFpos) > 0) {
                            if ((inSPEEDBUFF - SPEEDBUFFpos) < prefix_size)
                                break;
                            memcpy(ShapBuff, SPEEDBUFF + SPEEDBUFFpos, prefix_size);
                            if (memcmp(ShapBuff, ident.c_str(), ident.size()) == 0) {
                                memcpy(&bodysize, ShapBuff + ident.size(), sizeof(bodysize));
                                memcpy(&crc32, ShapBuff + ident.size() + sizeof(bodysize), sizeof(crc32));
                                memcpy(&keysize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32), sizeof(keysize));
                                memcpy(&valsize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), sizeof(valsize));
                                if ((bodysize > 0) && (bodysize < 100000000) && (bodysize == (keysize + valsize))) //������ �� ����
                                {
                                    if ((inSPEEDBUFF - SPEEDBUFFpos) < (prefix_size + bodysize))
                                        break;

                                    BuffSize = bodysize;
                                    BUFF = new char[BuffSize];
                                    try {
                                        memcpy(BUFF, SPEEDBUFF + SPEEDBUFFpos + prefix_size, bodysize);
                                        SPEEDBUFFpos += prefix_size + bodysize;
                                        crc32_a = 0;
                                        for (size_t i = 0; i < BuffSize; i++)
                                            crc32_a += BUFF[i];
                                        if (crc32 == crc32_a) {
                                            (*ihash)[TKey(BUFF, keysize)] = TValue(BUFF + keysize, valsize);
                                            read_count_element = IncMax32(read_count_element, 1);

                                        } else
                                            res = false;

                                        delete[] BUFF;
                                        BUFF = NULL;
                                    } catch (...) {
                                        delete[] BUFF;
                                        BUFF = NULL;
                                    }
                                    if (res == false)
                                        goto MEND;
                                } else {
                                    res = false;
                                    goto MEND;
                                }
                            }
                        }
                    }
                    count1 = inSPEEDBUFF - SPEEDBUFFpos;
                    if (count1 > 0) {
                        char* tbuff = new char[count1];
                        try {
                            memcpy(tbuff, SPEEDBUFF + SPEEDBUFFpos, count1);
                            memcpy(SPEEDBUFF, tbuff, count1);
                            inSPEEDBUFF = count1;
                            SPEEDBUFFpos = 0;

                            delete[] tbuff;
                            tbuff = NULL;
                        } catch (...) {
                            delete[] tbuff;
                            tbuff = NULL;
                        }
                    } else {
                        inSPEEDBUFF = 0;
                        SPEEDBUFFpos = 0;
                    }
                }
            MEND:
                fclose(yfhandle);
                if (SPEEDBUFF != NULL) {
                    delete[] SPEEDBUFF;
                    SPEEDBUFF = NULL;
                    inSPEEDBUFF = 0;
                }
            }
        }
    }

    UnLock();

    m_BeginProcTime = CShingleTime::GetMs() - m_BeginProcTime;
    delay = m_BeginProcTime;
    readcount = read_count_element;

    return res;
}

template <class TKey, class TValue>
bool KItemStore<TKey, TValue>::ListDump(const TString& YesterdayFilename, const TString& TodayFilename) {
    bool res = true;

    if ((YesterdayFilename.size() > 0) && (TodayFilename.size() > 0)) {
        typename TKItemHash::iterator i;
        TString ident = TString(ISFILEIDENTF);

        FILE* yfhandle = fopen(YesterdayFilename.c_str(), "wb");
        if (yfhandle != NULL) {
            i = m_pItemYesterday->begin();
            while (i != m_pItemYesterday->end()) {
                fprintf(yfhandle, "[beginrecord]\n");
                fprintf(yfhandle, "[key]\n");
                i->first.listdump(yfhandle);
                fprintf(yfhandle, "[value]\n");
                i->second.listdump(yfhandle);
                fprintf(yfhandle, "[endrecord]\n\n");

                ++i;
            }
            fclose(yfhandle);
        }

        if (res) {
            FILE* tfhandle = fopen(TodayFilename.c_str(), "wb");
            if (tfhandle != NULL) {
                i = m_pItemToday->begin();
                while (i != m_pItemToday->end()) {
                    fprintf(tfhandle, "[beginrecord]\n");
                    fprintf(tfhandle, "[key]\n");
                    i->first.listdump(tfhandle);
                    fprintf(tfhandle, "[value]\n");
                    i->second.listdump(tfhandle);
                    fprintf(tfhandle, "[endrecord]\n\n");
                    ++i;
                }
                fclose(tfhandle);
            }
        }
    }
    return res;
}

//***************************************************************************************
