#pragma once

#include "util/generic/string.h"
#include "util/system/mutex.h"
#include "util/generic/hash.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>

#define MAXREADDUMPBUFFER 5000000

//***************************************************************************************
//                               kui32
//***************************************************************************************

class kui32 {
private:
    ui32 value;

public:
    kui32() {
        value = 0;
    }
    kui32(ui32 valueA) {
        value = valueA;
    }
    kui32(char* BUFF, ui32 BuffSize) {
        value = 0;

        if (BuffSize >= sizeof(value))
            memcpy(&value, BUFF, sizeof(value));
    }

    operator ui32() const {
        return value;
    }
    size_t size() const {
        return sizeof(value);
    }
    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;

        if (BuffSize >= (int)sizeof(value)) {
            memcpy(BUFF, &value, sizeof(value));
            res = sizeof(value);
        }

        return res;
    }
    void listdump(FILE* handle) const {
        if (handle != NULL)
            fprintf(handle, "%u\n", value);
    }
};

//***************************************************************************************
//                               kui64
//***************************************************************************************

class kui64 {
private:
    ui64 value;

public:
    kui64() {
        value = 0;
    }
    kui64(ui64 valueA) {
        value = valueA;
    }
    kui64(char* BUFF, ui32 BuffSize) {
        value = 0;

        if (BuffSize >= (int)sizeof(value))
            memcpy(&value, BUFF, sizeof(value));
    }

    operator ui64() const {
        return value;
    }
    size_t size() const {
        return sizeof(value);
    }
    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;

        if (BuffSize >= (int)sizeof(value)) {
            memcpy(BUFF, &value, sizeof(value));
            res = sizeof(value);
        }

        return res;
    }
    void listdump(FILE* handle) const {
        if (handle != NULL)
            fprintf(handle, "%lu\n", value);
    }
};

//*************************************************************************************
//                                  KStroka
//*************************************************************************************

class KStroka {
private:
    TString value;

public:
    KStroka() {
        value = "";
    }
    KStroka(const TString& valueA) {
        value = valueA;
    }
    KStroka(const KStroka& valueA) {
        value.assign(valueA.value);
    }
    KStroka(char* BUFF, ui32 BuffSize) {
        value.assign(BUFF, BuffSize);
    }

    operator TString() const {
        return value;
    }
    operator size_t() const {
        return value.size();
    }
    size_t size() const {
        return value.size();
    }

    bool operator==(const KStroka& valueA) const {
        bool res = false;

        res = (value == valueA.value);
        return res;
    }

    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;

        if (BuffSize >= (int)value.size()) {
            memcpy(BUFF, value.c_str(), value.size());
            res = value.size();
        }

        return res;
    }

    void listdump(FILE* handle) const {
        if (handle != NULL)
            fprintf(handle, "%s\n", value.c_str());
    }
};

//*****************************************************************************************
//                               KItemStore
//*****************************************************************************************

#define ISFILEIDENTF "KBI"

template <class TKey, class TValue>
class KItemStore {
public:
    static const ui32 INIT_HASH_SIZE = 100000;
    KItemStore();
    ~KItemStore();

    bool Exists(const TKey Key);
    bool Add(TKey Key, TValue Val);
    size_t Midnight();
    void GetStat(const TKey Key, TValue& Stat);
    void GetStatSeparate(const TKey Key, TValue& TodayStat, TValue& YesterdayStat);
    void GetStatToday(const TKey Key, TValue& Stat);
    size_t GetSize();
    size_t GetSizeToday();
    TValue* Find(TKey Key);
    TValue* FindPrev(TKey Key);
    bool Del(TKey Key);
    void Clear();
    void WriteDumpSizes(const TString& YesterdayFilename, const TString& TodayFilename);
    bool WriteDump(const TString& YesterdayFilename, const TString& TodayFilename);
    bool ReadDump(const TString& YesterdayFilename, const TString& TodayFilename);
    bool ReadDump2(const TString& YesterdayFilename, const TString& TodayFilename, ui32& delay, ui32& readcount);
    bool ListDump(const TString& YesterdayFilename, const TString& TodayFilename);

private:
    typedef THashMap<TKey, TValue> TKItemHash;
    TKItemHash* m_pItemToday;
    TKItemHash* m_pItemYesterday;

    TMutex m_Mutex;
    void Lock();
    void UnLock();
};

//***********************************************************************************************************************
//                                               TRuleInfo
//***********************************************************************************************************************

/*struct TRuleInfo
{
   ui32 fulltime;
   ui32 count;

   TRuleInfo()
   {
      fulltime = 0;
      count    = 0;
   }

   TRuleInfo(ui32 countA, ui32 fulltimeA)
   {
      fulltime = fulltimeA;
      count    = countA;
   }

   void AppendTime(ui32 addtimeA)
   {
      fulltime = IncMax32(fulltime, addtimeA);
      count    = IncMax32(count, 1);
   }
};

typedef THashMap<TString, TRuleInfo> TRuleInfoHash;
typedef TRuleInfoHash::iterator      TRuleInfoHashIt;*/

//****************************************************************************************
