#pragma once

#include <util/generic/string.h>
#include "util/string/util.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>

//****************************************************************************************************************************************
//                                                       TDriverRqstPoolStat
//****************************************************************************************************************************************

namespace qustat {
    enum QFIELD_TYPE { INPUT_ALL,
                       INPUT_LOST,
                       COUNT,
                       OUTPUT_ALL,
                       RQST_OK,
                       RQST_ERR,
                       TM_0_10,
                       TM_10_20,
                       TM_20_50,
                       TM_50_100,
                       TM_100_150,
                       TM_150_190,
                       TM_190_500,
                       TM_MORE500,
                       QEND };

    struct TDriverRqstPoolStat {
        ui64 params[QEND];

        TDriverRqstPoolStat() {
            Clear();
        }

        void Clear() {
            for (size_t i = 0; i < QEND; i++)
                params[i] = 0;
        }

        TDriverRqstPoolStat& operator+=(const TDriverRqstPoolStat& value) {
            for (size_t i = 0; i < QEND; i++)
                params[i] = IncMax64(params[i], value.params[i]);

            return *this;
        }

        void IncrementInputAll() {
            params[INPUT_ALL] = IncMax64(params[INPUT_ALL], 1);
        }
        void IncrementInputLost() {
            params[INPUT_LOST] = IncMax64(params[INPUT_LOST], 1);
        }
        void IncrementOutputAll() {
            params[OUTPUT_ALL] = IncMax64(params[OUTPUT_ALL], 1);
        }
        void IncrementRequestOK() {
            params[RQST_OK] = IncMax64(params[RQST_OK], 1);
        }
        void IncrementRequestErr() {
            params[RQST_ERR] = IncMax64(params[RQST_ERR], 1);
        }

        void AddTime(ui32 tick) {
            if ((tick >= 0) && (tick < 10))
                params[TM_0_10] = IncMax64(params[TM_0_10], 1);
            else if ((tick >= 10) && (tick < 20))
                params[TM_10_20] = IncMax64(params[TM_10_20], 1);
            else if ((tick >= 20) && (tick < 50))
                params[TM_20_50] = IncMax64(params[TM_20_50], 1);
            else if ((tick >= 50) && (tick < 100))
                params[TM_50_100] = IncMax64(params[TM_50_100], 1);
            else if ((tick >= 100) && (tick < 150))
                params[TM_100_150] = IncMax64(params[TM_100_150], 1);
            else if ((tick >= 150) && (tick < 190))
                params[TM_150_190] = IncMax64(params[TM_150_190], 1);
            else if ((tick >= 190) && (tick < 500))
                params[TM_190_500] = IncMax64(params[TM_190_500], 1);
            else
                params[TM_MORE500] = IncMax64(params[TM_MORE500], 1);
        }

        TString CountToTString(ui64 value) {
            if (value == 0)
                return "-";
            else
                return UI64ToStroka(value);
        }

        ui64 GetInputAll() {
            return params[INPUT_ALL];
        }
        ui64 GetInputLost() {
            return params[INPUT_LOST];
        }
        ui64 GetCount() {
            return params[COUNT];
        }
        ui64 GetOutputAll() {
            return params[OUTPUT_ALL];
        }
        ui64 GetRequestOK() {
            return params[RQST_OK];
        }
        ui64 GetRequestErr() {
            return params[RQST_ERR];
        }

        TString GetInputAll_s() {
            return CountToTString(params[INPUT_ALL]);
        }
        TString GetInputLost_s() {
            return CountToTString(params[INPUT_LOST]);
        }
        TString GetCount_s() {
            return CountToTString(params[COUNT]);
        }
        TString GetOutputAll_s() {
            return CountToTString(params[OUTPUT_ALL]);
        }
        TString GetRequestOK_s() {
            return CountToTString(params[RQST_OK]);
        }
        TString GetRequestErr_s() {
            return CountToTString(params[RQST_ERR]);
        }

        ui64 GetCount_0_10() {
            return params[TM_0_10];
        }
        ui64 GetCount_10_20() {
            return params[TM_10_20];
        }
        ui64 GetCount_20_50() {
            return params[TM_20_50];
        }
        ui64 GetCount_50_100() {
            return params[TM_50_100];
        }
        ui64 GetCount_100_150() {
            return params[TM_100_150];
        }
        ui64 GetCount_150_190() {
            return params[TM_150_190];
        }
        ui64 GetCount_190_500() {
            return params[TM_190_500];
        }
        ui64 GetCount_MORE500() {
            return params[TM_MORE500];
        }

        TString GetCount_0_10_s() {
            return CountToTString(params[TM_0_10]);
        }
        TString GetCount_10_20_s() {
            return CountToTString(params[TM_10_20]);
        }
        TString GetCount_20_50_s() {
            return CountToTString(params[TM_20_50]);
        }
        TString GetCount_50_100_s() {
            return CountToTString(params[TM_50_100]);
        }
        TString GetCount_100_150_s() {
            return CountToTString(params[TM_100_150]);
        }
        TString GetCount_150_190_s() {
            return CountToTString(params[TM_150_190]);
        }
        TString GetCount_190_500_s() {
            return CountToTString(params[TM_190_500]);
        }
        TString GetCount_MORE500_s() {
            return CountToTString(params[TM_MORE500]);
        }

        TString GetMonStat() {
            TString res = "";

            for (size_t i = 0; i < QEND; i++) {
                if (res.empty())
                    res += UI64ToStroka(params[i]);
                else
                    res += "-" + UI64ToStroka(params[i]);
            }

            return res;
        }
    };

    struct TDriverRqstPoolStatFour {
        TDriverRqstPoolStat m_today_fastput;
        TDriverRqstPoolStat m_yesterday_fastput;

        TDriverRqstPoolStatFour() {
            Clear();
        }

        void Clear() {
            m_today_fastput.Clear();
            m_yesterday_fastput.Clear();
        }
    };

} // namespace qustat

//****************************************************************************************************************************************
