#pragma once

#define KPHAM 0
#define KPSPAM 85
#define KPMALIC 100
#define KPUNKNOWN 101

#define MAXREADDUMPBUFFER 5000000

#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>

//***********************************************************************************************************
//                                        kui32
//***********************************************************************************************************
/*
class kui32
{
private:
        ui32 value;
public:
        kui32(){ value = 0; }
        kui32(ui32 valueA){ value = valueA; }
        kui32(char *BUFF, ui32 BuffSize)
        {
           value = 0;

           if (BuffSize >= sizeof(value))
              memcpy(&value, BUFF, sizeof(value));
        }

        operator ui32() const { return value; }
        size_t size() const { return sizeof(value); }
        size_t GetBuffer(char *BUFF, int BuffSize) const
        {
            size_t res = 0;

            if (BuffSize >= sizeof(value))
            {
               memcpy(BUFF, &value, sizeof(value));
               res = sizeof(value);
            }

            return res;
        }
        void listdump(FILE *handle) const
        {
            if (handle != NULL)
               fprintf(handle, "%u\n", value);
        }
};
*/
//*****************************************************************************************************************
//                                              KTString
//*****************************************************************************************************************

class KTString {
private:
    TString value;

public:
    KTString() {
        value = "";
    }
    KTString(TString& valueA) {
        value = valueA;
    }
    KTString(const TString& valueA) {
        value = valueA;
    }
    KTString(const KTString& valueA) {
        value.assign(valueA.value);
    }
    KTString(char* BUFF, ui32 BuffSize) {
        value.assign(BUFF, BuffSize);
    }

    operator TString() const {
        return value;
    }
    operator size_t() const {
        return value.size();
    }
    size_t size() const {
        return value.size();
    }

    bool operator==(const KTString& valueA) const {
        bool res = false;

        res = (value == valueA.value);
        return res;
    }

    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;

        if (BuffSize >= (int)value.size()) {
            memcpy(BUFF, value.c_str(), value.size());
            res = value.size();
        }

        return res;
    }

    void listdump(FILE* handle) const {
        if (handle != NULL)
            fprintf(handle, "%s\n", value.c_str());
    }

    ui64 Shingle() const {
        ui64 res = 0;
        ui64 tres = 0;
        char sshingle[32];

        if (!value.empty()) {
            if (value.length() >= 4) {
                calc_strcrc64(value.c_str(), value.length(), sshingle);
                sscanf(sshingle, "%lx", &res);
            } else {
                for (int i = 0; i < (int)value.length(); i++) {
                    tres = value[i];
                    tres = tres << (i * 8);
                    res = res + tres;
                }
            }
        }

        return res;
    }
};

//****************************************************************************************************************
//                                                TPackHint
//****************************************************************************************************************

class TPackHint {
private:
    ui64 part1;
    ui64 part2;

public:
    TPackHint() {
        Clear();
    }
    TPackHint(ui64 part1A, ui64 part2A) {
        Clear();
        part1 = part1A;
        part2 = part2A;
    }
    ~TPackHint() {
    }

    void Clear() {
        part1 = 0;
        part2 = 0;
    }
    bool operator==(const TPackHint& value) const {
        return ((part1 == value.part1) && (part2 == value.part2));
    }
    TString GetStr() const {
        return UnPack64Compat(part1) + "." + UnPack64Compat(part2);
    }
};

//******************************************************************************
//                               TCountValue
//******************************************************************************

class TCountValue {
private:
    ui32 m_Count;

public:
    TCountValue() {
        Init();
    };
    TCountValue(ui32 value) {
        m_Count = value;
    };
    TCountValue(char* BUFF, int SizeBuff) {
        Init();
        if (SizeBuff >= (int)sizeof(m_Count))
            memcpy(&m_Count, BUFF, sizeof(m_Count));
    };

    void Init() {
        m_Count = 0;
    };
    void Update(const TCountValue& Stat) {
        m_Count += Stat.m_Count;
    };
    ui32 GetCount(void) const {
        return m_Count;
    };
    size_t size() const {
        return sizeof(m_Count);
    };
    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;

        if (BuffSize >= (int)sizeof(m_Count)) {
            memcpy(BUFF, &m_Count, sizeof(m_Count));
            res = sizeof(m_Count);
        }

        return res;
    }
    void listdump(FILE* handle) const {
        if (handle != NULL)
            fprintf(handle, "%u\n", m_Count);
    }

    TCountValue operator+(TCountValue& value) {
        m_Count += value.m_Count;
        return *this;
    }
};

//******************************************************************************
//                             TCountAndIPValue
//******************************************************************************

class TCountAndIPValue {
private:
    ui32 m_Count;
    TKIPv6 m_ip;

public:
    TCountAndIPValue() {
        Init();
    }
    TCountAndIPValue(ui32 value, TKIPv6 ip) {
        m_Count = value;
        m_ip = ip;
    }
    TCountAndIPValue(char* BUFF, int SizeBuff) {
        Init();
        if (SizeBuff >= (int)(sizeof(m_Count) + sizeof(m_ip))) {
            memcpy(&m_Count, BUFF, sizeof(m_Count));
            memcpy(&m_ip, BUFF + sizeof(m_Count), sizeof(m_ip));
        }
    };

    void Init() {
        m_Count = 0;
        m_ip = TKIPv6();
    }
    void Update(const TCountAndIPValue& Stat) {
        m_Count += Stat.m_Count;
        m_ip = Stat.m_ip;
    }
    ui32 GetCount(void) const {
        return m_Count;
    }
    TKIPv6 GetIP(void) const {
        return m_ip;
    }
    size_t size() const {
        return (sizeof(m_Count) + sizeof(m_ip));
    }
    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;

        if (BuffSize >= (int)(sizeof(m_Count) + sizeof(m_ip))) {
            memcpy(BUFF, &m_Count, sizeof(m_Count));
            memcpy(BUFF + sizeof(m_Count), &m_ip, sizeof(m_ip));
            res = sizeof(m_Count) + sizeof(m_ip);
        }

        return res;
    }
    void listdump(FILE* handle) const {
        if (handle != NULL) {
            TString ips = m_ip.toStroka();
            fprintf(handle, "%u-%s\n", m_Count, ips.c_str());
        }
    }

    TCountAndIPValue operator+(TCountAndIPValue& value) {
        m_Count += value.m_Count;
        return *this;
    }
};

//*****************************************************************************************************************
//                                                 TExpStruct
//*****************************************************************************************************************

class TExpStruct {
private:
    TString flogin;
    ui32 fuid;
    ui8 fweight;
    ui8 fbackalg;
    bool fpdd;

public:
    TExpStruct(const TString& login, ui32 uid, ui8 weight, ui8 backalg, bool pdd) {
        flogin = login;
        fuid = uid;
        fweight = weight;
        fbackalg = backalg;
        fpdd = pdd;
    }

    TString login(void) const {
        return flogin;
    }
    ui32 uid(void) const {
        return fuid;
    }
    ui8 weight(void) const {
        return fweight;
    }
    ui8 backalg(void) const {
        return fbackalg;
    }
    bool pdd(void) const {
        return fpdd;
    }
    TString uids(void) const {
        TString res = "";
        char m[16];

        memset(m, 0, sizeof(m));
        snprintf(m, sizeof(m) - 1, "%u", fuid);
        res.assign(m);
        return res;
    }
    TString weights(void) const {
        TString res = "";
        char m[16];

        memset(m, 0, sizeof(m));
        snprintf(m, sizeof(m) - 1, "%u", fweight);
        res.assign(m);
        return res;
    }
    TString pdds(void) const {
        TString res = "";

        if (fpdd)
            res = " pdd=\"yes\" ";

        return res;
    }
};

typedef std::list<TExpStruct> TExpList;

//****************************************************************************************************************
