#include "tmakerequest.h"
#include "tgeneralobject.h"
#include "tserviceobject.h"
#include "tfcgiserver.h"

#define MAX_STACK_SIZE 512
int fd_devnull = -1;

void StartMakeMeDaemon();
int FinishMakeMeDaemon();

#define SERVER_NAME "Checkform 2.07"

TServiceObject ServiceObject;
TFCGIServer fcgi_serv(ServiceObject);

/*HANDLE*/ void* hEventLog = NULL;

#ifndef _win_
void ShutdownHandler(int signo) {
    switch (signo) {
        case SIGTERM:
            fcgi_serv.Shutdown();
            signal(SIGTERM, ShutdownHandler);
            break;
        case SIGUSR1:
            //fcgi_serv.SendSIGUSR1();
            //signal(SIGUSR1, ShutdownHandler);
            break;
    };
}
#endif

int main(int argc, char* argv[]) {
    Y_VERIFY(setlocale(LC_CTYPE, "ru_RU.cp1251"));

    int ret_code = 0;

    printf("\n%s\n", SERVER_NAME);

    if (argc < 2) {
        printf("\nUsage: sonline <config_file>\n");
        exit(1);
    }

    Openlog("cerr", TLOG_INFO);
#ifdef _win_
    WSADATA dummy;
    WSAStartup(MAKEWORD(2, 2), &dummy);
#endif

    if (ServiceObject.InitBeforeFork(argv[0], argv[1], SERVER_NAME)) {
#ifndef _win_
        struct sigaction sa;
        sa.sa_handler = ShutdownHandler;
        sigemptyset(&sa.sa_mask);
        sa.sa_flags = 0;
        sigaction(SIGUSR1, &sa, NULL);
        sigaction(SIGTERM, &sa, NULL);
#endif

        if (fcgi_serv.InitBeforeFork()) {
#ifndef _win_
            if (ServiceObject.Daemonize()) {
                StartMakeMeDaemon(); //fork
                signal(SIGPIPE, SIG_IGN);
            }
#endif

            fcgi_serv.InitAfterFork();

#ifndef _win_
            if (ServiceObject.Daemonize())
                fd_devnull = FinishMakeMeDaemon();
            fcgi_serv.WritePid();
#endif
            fcgi_serv.Wait();

            fcgi_serv.Close();
        } else {
            printf("Server not started - initialization error, see logs for details\n");
            ret_code = 1;
        }

    } else {
        printf("Server not started - initialization error, see logs for details\n");
        ret_code = 1;
    }

    ServiceObject.Close();

#ifdef _win_
    WSACleanup();
#endif

#ifndef _win_
    if (fd_devnull >= 0)
        close(fd_devnull);
    close(0);
    close(1);
    close(2);
#endif

    exit(ret_code);
}
