#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/local_cache_template.h>
#include <mail/so/spamstop/tools/so-common/tphoneparser.h>
#include <mail/so/spamstop/tools/so-common/urlparser.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/tnetipv6.h>
#include <mail/so/spamstop/tools/so-common/get_zone_time.h>
#include <mail/so/spamstop/tools/so-common/tpoolhttpclients.h>
#include <mail/so/spamstop/tools/so-common/get_zone_time.h>
#include <mail/so/spamstop/tools/so-common/tresolvcache.h>
#include <mail/so/spamstop/tools/so-common/trblhostclass.h>
#include <mail/so/spamstop/tools/so-common/tkinifile.h>
#include <mail/so/spamstop/tools/so-common/tspamstatclient.h>
#include <mail/so/spamstop/tools/so-common/receipt.h>
#include <mail/so/spamstop/tools/fcgiserver_base/sotypes.h>
#include "tipcache.h"
#include "tsignatureclass.h"
#include "theavystat.h"
#include "tstorebase.h"
#include "tcheckform_types.h"
#include "trenginepool_cf.h"
#include "tgroupfilter.h"
#include <mail/so/spamstop/tools/so-common/local_cache_template.h>
#include "tstorebase_data.h"
#include "tparams.h"

//*****************************************************************************************************************
//                                                 CSoFilterCF
//*****************************************************************************************************************

struct TResolution {
    TString service = "";
    bool Spam = false;
    TString formname = "";
    bool Skeep = false;
    bool dirtyword = false;
    bool banrule = false;
    TCheckformResponceType format;
    TAntiDDOSCriterionInfo antiddos;
};



class CSoFilterCF {
private:
    static const ui32 MAX_FIELD_SIZE = 32000;
    static const ui32 MAX_COMMENT_LOG = 2048;
    static const int MAX_PARSE_URLMAIL_COUNT = 30;

protected:
    TKConfig* m_configobj;
    TLogsGroupCF* LogsGroup;
    TGroupFilter* GroupFilter;
    TKIniFile* FieldCheck;
    TKIniFile* LoginCheck;
    TKIniFile* AntiDDOSList;
    TNetIPv6* BlackList;
    TNetIPv6* WhiteList;

    TRBLHostClass* RBLHostObj;
    TResolvCache* AsyncResolvCache;
    bool m_async_resolv;

    THolder<NFuncClient::TRbl> rblClient;

    TReqValues exclude_field_list;

    THolder<NFuncClient::CBB> bbClient;
    THolder<NFuncClient::TLogoutUser> logoutClient;
    TString cleanWebHost{};
    TString cleanWebCACert{};
    THolder<NFuncClient::TUrlReputation> urlReputationClient;
    THolder<NCurl::TPoolTraits> poolTraits;
    NCurl::TPool curlPool;

    TAdaptiveThreadPool threadPool;
    TBBCache bbCache;

    using TCleanWebCache = NCache::TCacheBase<ui64, TString>;
    TCleanWebCache cleanWebCache;

    bool ExcludeKey(const TString& so_service, const TString& skey_field);
    ui32 ParseHostsMailsPhones(TReqParams* pReqParams, const TString& so_service, TZoneDetector::TKUrlHash& urls_hash, bool& urlmail_parse_max, TZoneDetector::TStrokaHash& host_list, ui32& max_host_count_in_field, TZoneDetector::TStrokaHash& mail_list, ui32& max_email_count_in_field, common::TPhoneParser::TPhoneList& phone_list, ui32& max_phone_count_in_field, stordata::TStorDataByHMP& stordata_hmp);

    ui64 CreateShingleWithService(TKIPv6 ip, const TString& so_service);
    ui64 CreateShingleWithService(const TString& text, const TString& so_service);
    ui64 CreateShingleWithService(ui64 shingle, const TString& so_service);

    void CreateServiceShingleList(stordata::TShingleDataList& srvc_shingles_list, TObrabParams& odata);
    void CreateShingleListMSearchFound(stordata::TShingleDataList& srvc_shingles_list, TObrabParams& odata);
    void CreateCommonShingleList(stordata::TShingleDataList& common_shingles_list, TObrabParams& odata, bool up);
    void CreateStatShingleList(stordata::TShingleDataList& common_shingles_list, TObrabParams& odata);
    ui32 GetServiceStorage(const TString& NumbRequest, TStoreBase* store, TObrabParams& odata, ui32& service_stat_collision_count, ui32& shingles_collision_count);
    TAtomicSharedPtr<NBlackbox2::TResponse> GetBB(const NFuncClient::CBB::TBbKey& key);
    TString CleanWebRequest(const TString& comment);
    ui32 UpdateServiceStorage(const TString& NumbRequest, TStoreBase* store, TObrabParams& odata, const TString& normtext, bool Spam, int rcpt_count, chkfrm::TDelayClass& DelayClass);
    void AddStatError(const TString& NumbRequest, TStoreBase* store, TObrabParams& odata, ui16 rcpt_count);
    ui32 UpdateMSearchFound(const TString& NumbRequest, TStoreBase* store, TObrabParams& odata, bool Spam, int rcpt_count, chkfrm::TDelayClass& DelayClass);

    ui32 GetLongIPStat(const TString& NumbRequest, TStoreBase* store, const TString& so_service, const TString& ip, TLongIPData& longipdata, ui32& ipstat_collision_count);
    ui32 UpdateLongIPStat(const TString& NumbRequest, TStoreBase* store, const TString& so_service, const TString& ip, stordata::TLongIPCnt cnt_type);

    TFilterResult AppleFilter(
            const TString& sid,
            const NJson::TJsonValue& js,
            const TString& filter_index,
            TReqParams* pReqParams,
            TRengine* m_hSp,
            TObrabParams& odata,
            chkfrm::TDelayClass& DelayClass,
            ui32& filter_work_tick,
            TMaybe<TReceipt>& receipt,
            TLogsGroupCF* logsGroup,
            const TString& service);

public:
    CSoFilterCF();
    ~CSoFilterCF();

    bool InitBeforeFork(TKConfig* configobjA, TLogsGroupCF* LogsGroupA, TSignatureClass* m_signhashA, STORAGETYPE storagetypeA, TGroupFilter* GroupFilterA, TKIniFile* FieldCheckA, TString& ipcachedump, TKIniFile* LoginCheckA, TKIniFile* AntiDDOSListA);
    bool InitAfterFork(void* pStorNoSqlA);

    int Chec2(TReqParams* pReqParams, const NJson::TJsonValue& js, bool& Spam, const TString& id, chkfrm::TDelayClass& DelayClass, TString& service, TString& formname_s, bool& skeep, bool& dirtyword, bool& banrule, TCheckformResponceType& format, TAntiDDOSCriterionInfo& antiddos, TMaybe<TReceipt>& receipt);
    int CreateServiceN(TString& ServiceName, TString& score, TString& rules);
    bool Reset();
    TResetResponceCF ReloadRules();
    void Close();
    void CleanStore();
    void Midnight();
    void Shutdown();
    void EventTick();
    void WriteToLog(const TLogStatus LogLevel, const TString& NumbRequest, const char* msg, ...);
    TReqParams* DecodeParams(const TString& Numbrequest, TReqParams* pReqParams);
    void DeleteParams(TReqParams* pReqParamsNew);
    TString GetKey(TReqParams::iterator& it);
    TString GetValue(TReqParams::iterator& it);
    void ReloadBlackList(void);
    void ReloadWhiteList(void);

    bool ReadDump() {
        return true;
    }
    bool WriteDump() {
        return true;
    }
    bool ListDump() {
        return true;
    }

    TIPCacheIPv6 ipcache;
    ui32 IPCacheSize() {
        return ipcache.Size();
    }

    STORAGETYPE m_storagetype;
    TSignatureClass* m_signhash;

    THeavyStat normtext_heavystat;
    THeavyStat suid_heavystat;
    THeavyStat ip_heavystat;

    ui64 CalcGeoShingle(TString& geos);
    ui64 CalcGeoCountryShingle(TString& geos);
    TString GetDomen2level(const TString& host);
    TString GetDomen3level(const TString& host);

    ui32 SpCheckFieldTick(TRengine* sph, const char* pFieldName, const char* pField, int FieldLen, const char* coding, bool fValid, bool fMime, chkfrm::TRuleInfoHash* ruleshash);

    TGroupFilter* GetGroupFilter() {
        return GroupFilter;
    }
    bool RunAntiDDOSItem(const TString& job, const TString& field_value, ui32 storvalue, ui32& tick, bool skeep_cnt, bool skeep_in, bool skeep_re);
    bool RunAntiDDOSActionOther(const TString& so_service, const TString& field_name, const TString& field_value, TAntiDDOSCriterionInfo& antiddos);
    bool NeedAddCntAntiDDOSAction(const TString& so_service, const TString& field_name);

    bool RunAntiDDOSActionIP(TStoreBase* store, const TString& so_service, TKIPv6 ip, TAntiDDOSCriterionInfo& antiddos);                             //"~ip"
    bool RunAntiDDOSActionLogin(TStoreBase* store, const TString& so_service, const TString& login, TAntiDDOSCriterionInfo& antiddos);               //"~login"
    bool RunAntiDDOSActionXMPPServerName(TStoreBase* store, const TString& so_service, ui64 xmpp_srvname_shingle, TAntiDDOSCriterionInfo& antiddos); //"~xmpp_srvname"
    bool RunAntiDDOSActionNick(TStoreBase* store, const TString& so_service, ui64 nick_shingle, TAntiDDOSCriterionInfo& antiddos);                   //"~nick"
    bool RunAntiDDOSActionComment(TStoreBase* store, const TString& so_service, ui64 comment_shingle, TAntiDDOSCriterionInfo& antiddos);             //"~comment"
    bool RunAntiDDOSActionSubject(TStoreBase* store, const TString& so_service, ui64 subject_shingle, TAntiDDOSCriterionInfo& antiddos);             //"~subject"

    void AddAntiDDOSActionIP(TStoreBase* store, const TString& so_service, TKIPv6 ip, TCountersStatEx value);
    void AddAntiDDOSActionLogin(TStoreBase* store, const TString& so_service, const TString& login, TCountersStat value);
    void AddAntiDDOSActionLogin(TStoreBase* store, const TString& so_service, const TString& login, TCountersStatEx value);
    void AddAntiDDOSActionNick(TStoreBase* store, const TString& so_service, ui64 nick_shingle, TCountersStatEx value);
    void AddAntiDDOSActionXMPPServerName(TStoreBase* store, const TString& so_service, ui64 xmpp_srvname_shingle, TCountersStat value);
    void AddAntiDDOSActionXMPPServerName(TStoreBase* store, const TString& so_service, ui64 xmpp_srvname_shingle, TCountersStatEx value);
    void AdddAntiDDOSActionComment(TStoreBase* store, const TString& so_service, ui64 comment_shingle, TCountersStatEx value);
    void AdddAntiDDOSActionSubject(TStoreBase* store, const TString& so_service, ui64 subject_shingle, TCountersStat value);
    void AdddAntiDDOSActionSubject(TStoreBase* store, const TString& so_service, ui64 subject_shingle, TCountersStatEx value);

    TString ViewResolvWebStat(const TString& ipfromcache_form);
    TString GetRslvIPFromCache(TKIPv6 ip);

    void GetUdnsServicesIPData(const TString& NumbRequest, TKIPv6 ip, TSummDataUdnsList& stat_list);

    TString GetServicesStatistik();

    using TResCache = NCache::TCacheBase<size_t, TResolution>;

    TResCache resCache;
};
