#pragma once

#include <set>
#include <time.h>
#include <util/generic/string.h>
#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include "util/string/util.h"

class TStatDataSet {
private:
    time_t time;
    ui32 allreg;
    ui32 spamreg;
    ui32 errorreg;

public:
    TStatDataSet(time_t timeA, ui32 allregA, ui32 spamregA, ui32 errorregA) {
        time = timeA;
        allreg = allregA;
        spamreg = spamregA;
        errorreg = errorregA;
    }
    ~TStatDataSet(){};

    bool operator<(const TStatDataSet& value) const {
        return (time < value.time);
    }

    time_t gettime() const {
        return time;
    };
    ui32 getallreg() const {
        return allreg;
    };
    ui32 getspamreg() const {
        return spamreg;
    };
    ui32 geterrorreg() const {
        return errorreg;
    };
};

typedef std::set<TStatDataSet> TStatDataSetS;
typedef std::set<TStatDataSet>::iterator TStatDataSetSIt;

class TStatShap {
private:
    time_t ftime;

public:
    TStatShap() {
        ftime = 0;
    };

    TStatShap(time_t t) {
        tm tv;

        tv = *localtime(&t);
        tv.tm_min = 0;
        tv.tm_sec = 0;
        ftime = mktime(&tv);
    }

    operator size_t() const {
        return sizeof(ftime);
    }

    time_t time() const {
        return ftime;
    }

    bool operator==(const TStatShap value) const {
        return (ftime == value.ftime);
    }

    bool operator<(const TStatShap value) const {
        return (ftime < value.ftime);
    }
};

struct TStatAvr {
    ui32 all;
    ui32 spam;
    ui32 error;
    ui32 ham;

    TStatAvr() {
        all = 0;
        spam = 0;
        error = 0;
        ham = 0;
    }

    TStatAvr(ui32 allA, ui32 spamA, ui32 errorA, ui32 hamA) {
        all = allA;
        spam = spamA;
        error = errorA;
        ham = hamA;
    }
};

class TStatData {
public:
    ui32 reg_count;
    ui32 spam_count;
    ui32 error_count;

    TStatData() {
        reg_count = 0;
        spam_count = 0;
        error_count = 0;
    }
    TStatData(ui32 reg_countA, ui32 spam_countA, ui32 error_countA) {
        reg_count = reg_countA;
        spam_count = spam_countA;
        error_count = error_countA;
    }
    TString GetData() {
        TString res = "";
        char BUFF[256];

        memset(BUFF, 0, sizeof(BUFF));
        snprintf(BUFF, sizeof(BUFF) - 1, "%u, %u, %u", reg_count, spam_count, error_count);
        res = TString(BUFF);

        return res;
    }
};

typedef THashMap<TStatShap, TStatData> TStatOData;
typedef TStatOData::iterator TStatODataIt;

class TStatO {
private:
    TStatOData data;
    TMutex m_Mutex;
    FILE* log;
    time_t ttemp;
    TString Filenamelog;

    void Lock();
    void UnLock();

public:
    TStatO();
    ~TStatO();

    void Init(TString FilenamelogA);
    void AddAll(time_t t);
    void AddSpam(time_t t);
    void AddError(time_t t);

    bool GetData(int yearA, int monA, int dayA, int hourA, time_t t);
    bool GetDataI(time_t t, TStatDataSetS& statlist);

    bool WriteDump(TString dump_filename);
    bool ReadDump(TString dump_filename);

    TStatAvr GetAverage(time_t t);
    TStatAvr GetNow(time_t t);
};
