#include "tallowservice.h"

//*********************************************************************************
//                                   TAllowService
//*********************************************************************************

TAllowService::TAllowService() {
}

TAllowService::~TAllowService() {
    data.clear();
}

void TAllowService::Lock() {
    m_Mutex.Acquire();
}

void TAllowService::UnLock() {
    m_Mutex.Release();
}

bool TAllowService::LoadServices(const TString& service_str) {
    bool res = false;
    char buff[1024];
    char sbuff1[256];
    char sbuff2[256];
    char* pb = NULL;
    char* pe = NULL;
    int count = 0;
    TString sservice = "", sservice_l = "";
    TServiceListIt it;
    TString unknown_service = UNKNOWNSERVICE;

    Lock();

    data.clear();

    if (!service_str.empty()) {
        res = true;
        memset(buff, 0, sizeof(buff));
        strncpy(buff, service_str.c_str(), sizeof(buff) - 1);
        pb = buff;
        pe = strstr(pb, ",");
        while (pe != NULL) {
            memset(sbuff1, 0, sizeof(sbuff1));
            count = pe - pb;
            if (count < (int)sizeof(sbuff1)) {
                memset(sbuff2, 0, sizeof(sbuff2));
                memcpy(sbuff1, pb, count);
                sscanf(sbuff1, " %s ", sbuff2);
                sservice = TString(sbuff2);
                if (!sservice.empty()) {
                    sservice_l = sservice;
                    sservice.to_upper(0, sservice.length());
                    it = data.find(sservice);
                    if (it == data.end())
                        data[sservice] = sservice_l;
                }
            }
            pb = pe + 1;
            pe = strstr(pb, ",");
        }

        memset(sbuff1, 0, sizeof(sbuff1));
        memset(sbuff2, 0, sizeof(sbuff2));
        strncpy(sbuff1, pb, sizeof(sbuff1) - 1);
        sscanf(sbuff1, " %s ", sbuff2);
        sservice = TString(sbuff2);
        if (!sservice.empty()) {
            sservice_l = sservice;
            sservice.to_upper(0, sservice.length());
            it = data.find(sservice);
            if (it == data.end())
                data[sservice] = sservice_l;
        }

        if (!unknown_service.empty()) {
            it = data.find(unknown_service);
            if (it == data.end())
                data[unknown_service] = unknown_service;
        }
    }

    UnLock();

    return res;
}

bool TAllowService::ExistsService(const TString& service) {
    bool res = false;
    TServiceListIt it;

    Lock();

    it = data.find(service);
    if (it != data.end())
        res = true;

    UnLock();

    return res;
}

void TAllowService::ServiceList(TServiceListT& list) {
    Lock();

    TServiceListIt it;

    list.clear();
    it = data.begin();
    while (it != data.end()) {
        list.push_back((*it).second);
        ++it;
    }

    UnLock();
}

//**********************************************************************************
