#pragma once

#include "util/system/mutex.h"
#include "util/generic/string.h"
#include "util/generic/hash.h"
#include <list>

#define SUMMARYUNIT "<COMMON>"
#define SUMMARYUNITDUMP "COMMON"
#define UNKNOWNSERVICE "_UNKNOWN_"
#define UNKNOWNSERVICE_DIR "UNKNOWN"

//*********************************************************************************
//                                   TAllowService
//*********************************************************************************

typedef THashMap<TString, TString> TServiceList;
typedef TServiceList::iterator TServiceListIt;

typedef std::list<TString> TServiceListT;
typedef TServiceListT::iterator TServiceListTIt;

class TAllowService {
private:
    TServiceList data;
    TMutex m_Mutex;

    void Lock();
    void UnLock();

public:
    TAllowService();
    ~TAllowService();

    bool LoadServices(const TString& service_str);
    bool ExistsService(const TString& service);
    void ServiceList(TServiceListT& list);
};

//**********************************************************************************
