#include "tallowuser.h"

TAllowUser::TAllowUser() {
}

TAllowUser::~TAllowUser() {
}

void TAllowUser::Lock() {
    m_Mutex.Acquire();
}

void TAllowUser::UnLock() {
    m_Mutex.Release();
}

ui64 TAllowUser::CalcShingle(const TString& login) {
    ui64 res = 0;
    char sshingle[32];
    TString stemp = "";

    if (!login.empty()) {
        stemp = Trim(login);
        to_lower_k(stemp);
        memset(sshingle, 0, sizeof(sshingle));
        calc_strcrc64(stemp.c_str(), stemp.size(), sshingle);
        sscanf(sshingle, "%lx", &res);
    }

    return res;
}

bool TAllowUser::ExistsLogin(const TString& login) {
    bool res = false;
    ui64 shingle = 0;
    TAllowUserDataHashIt it;
    time_t current_time = time(NULL);
    TString m_login = "";

    m_login = Trim(login);
    if (!m_login.empty()) {
        to_lower_k(m_login);

        shingle = CalcShingle(m_login);
        if (shingle != 0) {
            Lock();

            it = data.find(shingle);
            if (it != data.end()) {
                if ((*it).second.m_login == m_login) {
                    if (current_time <= ((*it).second.m_add_time + (*it).second.m_lifetime)) {
                        res = true;
                    } else {
                        data.erase(it);
                    }
                }
            }

            UnLock();
        }
    }

    return res;
}

void TAllowUser::AddLogin(const TString& login, ui32 lifetime) {
    ui64 shingle = 0;
    TAllowUserDataHashIt it;
    time_t current_time = time(NULL);
    TString m_login = "";

    m_login = Trim(login);
    if (!m_login.empty()) {
        to_lower_k(m_login);

        shingle = CalcShingle(m_login);
        if (shingle != 0) {
            Lock();

            it = data.find(shingle);
            if (it != data.end()) {
                if ((*it).second.m_login == m_login) {
                    (*it).second.m_add_time = current_time;
                    (*it).second.m_lifetime = lifetime;
                }

            } else {
                data[shingle] = TAllowUserData(m_login, lifetime, current_time);
            }

            UnLock();
        }
    }
}

bool TAllowUser::RemoveLogin(const TString& login) {
    bool res = false;
    ui64 shingle = 0;
    TAllowUserDataHashIt it;
    TString m_login = "";

    m_login = Trim(login);
    if (!m_login.empty()) {
        to_lower_k(m_login);

        shingle = CalcShingle(m_login);
        if (shingle != 0) {
            Lock();

            it = data.find(shingle);
            if (it != data.end()) {
                data.erase(it);
                res = true;
            }

            UnLock();
        }
    }

    return res;
}

TAllowUserData TAllowUser::Get(const TString& login) {
    TAllowUserData res;
    ui64 shingle = 0;
    TAllowUserDataHashIt it;
    TString m_login = "";
    time_t current_time = time(NULL);

    m_login = Trim(login);
    if (!m_login.empty()) {
        to_lower_k(m_login);

        shingle = CalcShingle(m_login);
        if (shingle != 0) {
            Lock();

            it = data.find(shingle);
            if (it != data.end()) {
                if ((*it).second.m_login == m_login) {
                    if (current_time <= ((*it).second.m_add_time + (*it).second.m_lifetime)) {
                        res = (*it).second;
                    } else {
                        data.erase(it);
                    }
                }
            }

            UnLock();
        }
    }

    return res;
}

void TAllowUser::Midnight() {
    TAllowUserDataHashIt it;
    time_t current_time = time(NULL);

    Lock();

    it = data.begin();
    while (it != data.end()) //������� �������� ���������, �.�. ��������������, ��� ������ ����� ���������
    {
        if (current_time > ((*it).second.m_add_time + (*it).second.m_lifetime)) {
            data.erase(it++);
            continue;
        }

        ++it;
    }

    UnLock();
}

bool TAllowUser::ReadDump(const TString& Filename) {
    bool res = true;

    Lock();

    if (Filename.size() > 0) {
        size_t count1 = 0, count4 = 0;
        char* BUFF;
        size_t BuffSize = 0;
        ui32 crc32 = 0, crc32_a = 0;
        TString ident = "KBI";
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;
        char ShapBuff[1600];
        char* SPEEDBUFF = NULL;
        ui32 SPEEDBUFFSize = MAXREADDUMPBUFFERU;
        ui32 inSPEEDBUFF = 0;
        ui32 SPEEDBUFFpos = 0;
        ui64 shingle = 0;

        FILE* yfhandle = fopen(Filename.c_str(), "rb");
        if (yfhandle != NULL) {
            SPEEDBUFF = new char[SPEEDBUFFSize];
            SPEEDBUFFpos = 0;
            while (!feof(yfhandle)) {
                if ((SPEEDBUFFSize - inSPEEDBUFF) > 0) {
                    count4 = fread(SPEEDBUFF + inSPEEDBUFF, 1, SPEEDBUFFSize - inSPEEDBUFF, yfhandle);
                    inSPEEDBUFF += count4;
                }
                if (inSPEEDBUFF > 0) {
                    prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);
                    while ((inSPEEDBUFF - SPEEDBUFFpos) > 0) {
                        if ((inSPEEDBUFF - SPEEDBUFFpos) < prefix_size)
                            break;
                        memcpy(ShapBuff, SPEEDBUFF + SPEEDBUFFpos, prefix_size);
                        if (memcmp(ShapBuff, ident.c_str(), ident.size()) == 0) {
                            memcpy(&bodysize, ShapBuff + ident.size(), sizeof(bodysize));
                            memcpy(&crc32, ShapBuff + ident.size() + sizeof(bodysize), sizeof(crc32));
                            memcpy(&keysize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32), sizeof(keysize));
                            memcpy(&valsize, ShapBuff + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), sizeof(valsize));
                            if ((bodysize > 0) && (bodysize < 100000000) && (bodysize == (keysize + valsize))) //������ �� ����
                            {
                                if ((inSPEEDBUFF - SPEEDBUFFpos) < (prefix_size + bodysize))
                                    break;
                                BuffSize = bodysize;
                                BUFF = new char[BuffSize];
                                try {
                                    memcpy(BUFF, SPEEDBUFF + SPEEDBUFFpos + prefix_size, bodysize);
                                    SPEEDBUFFpos += prefix_size + bodysize;

                                    crc32_a = 0;
                                    for (int i = 0; i < (int)BuffSize; i++)
                                        crc32_a += BUFF[i];
                                    if (crc32 == crc32_a) {
                                        if (keysize == sizeof(shingle)) {
                                            memcpy(&shingle, BUFF, keysize);
                                            data[shingle] = TAllowUserData(BUFF + keysize, valsize);

                                        } else
                                            res = false;

                                    } else
                                        res = false;

                                    delete[] BUFF;
                                    BUFF = NULL;
                                } catch (...) {
                                    delete[] BUFF;
                                    BUFF = NULL;
                                }
                                if (res == false)
                                    goto MEND;
                            } else {
                                res = false;
                                goto MEND;
                            }
                        }
                    }
                }
                count1 = inSPEEDBUFF - SPEEDBUFFpos;
                if (count1 > 0) {
                    char* tbuff = new char[count1];
                    try {
                        memcpy(tbuff, SPEEDBUFF + SPEEDBUFFpos, count1);
                        memcpy(SPEEDBUFF, tbuff, count1);
                        inSPEEDBUFF = count1;
                        SPEEDBUFFpos = 0;

                        delete[] tbuff;
                        tbuff = NULL;
                    } catch (...) {
                        delete[] tbuff;
                        tbuff = NULL;
                    }
                } else {
                    inSPEEDBUFF = 0;
                    SPEEDBUFFpos = 0;
                }
            }
        MEND:
            fclose(yfhandle);
            if (SPEEDBUFF != NULL) {
                delete[] SPEEDBUFF;
                SPEEDBUFF = NULL;
                inSPEEDBUFF = 0;
            }
        }
    }

    UnLock();

    return res;
}

bool TAllowUser::WriteDump(const TString& Filename, ui32& reccount) {
    bool res = true;

    Lock();

    reccount = 0;
    if (Filename.size() > 0) {
        TAllowUserDataHashIt it;
        size_t t1 = 0, t2 = 0;
        size_t count1 = 0, count2 = 0, count3 = 0;
        char* BUFF = NULL;
        size_t BuffSize = 0;
        ui32 crc32 = 0;
        TString ident = "KBI";
        ui16 prefix_size = 0;
        ui32 bodysize = 0;
        ui32 keysize = 0, valsize = 0;
        ui64 shingle = 0;

        FILE* yfhandle = fopen(Filename.c_str(), "wb");
        if (yfhandle != NULL) {
            it = data.begin();
            while (it != data.end()) {
                t1 = sizeof(it->first);
                t2 = it->second.size();
                keysize = t1;
                valsize = t2;
                bodysize = t1 + t2;
                prefix_size = ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize) + sizeof(valsize);

                BuffSize = prefix_size + t1 + t2;
                if (BuffSize > 0) {
                    BUFF = new char[BuffSize];
                    try {
                        shingle = it->first;
                        if (sizeof(shingle) <= (BuffSize - prefix_size)) {
                            memcpy(BUFF + prefix_size, &shingle, sizeof(shingle));
                            count1 = sizeof(shingle);
                        } else
                            count1 = 0;
                        //count1 = it->first.GetBuffer(BUFF + prefix_size, BuffSize - prefix_size);
                        if (count1 == t1) {
                            count2 = it->second.GetBuffer(BUFF + prefix_size + count1, BuffSize - prefix_size - count1);
                            if (count2 == t2) {
                                memcpy(BUFF, ident.c_str(), ident.size());
                                memcpy(BUFF + ident.size(), &bodysize, sizeof(bodysize));
                                crc32 = 0;
                                for (int i = prefix_size; i < (int)BuffSize; i++)
                                    crc32 += BUFF[i];
                                memcpy(BUFF + ident.size() + sizeof(bodysize), &crc32, sizeof(crc32));
                                memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32), &keysize, sizeof(keysize));
                                memcpy(BUFF + ident.size() + sizeof(bodysize) + sizeof(crc32) + sizeof(keysize), &valsize, sizeof(valsize));

                                count3 = fwrite(BUFF, 1, BuffSize, yfhandle);
                                if (count3 != BuffSize) {
                                    res = false;
                                    break;
                                } else {
                                    reccount++;
                                }
                            }
                        }

                        delete[] BUFF;
                        BUFF = NULL;
                    } catch (...) {
                        delete[] BUFF;
                        BUFF = NULL;
                    }
                }
                ++it;
            }
            fclose(yfhandle);
        }
    }

    UnLock();

    return res;
}

ui32 TAllowUser::Size() {
    ui32 res = 0;

    Lock();

    res = data.size();

    UnLock();

    return res;
}
