#pragma once

#include "util/generic/hash.h"
#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>

struct TAllowUserData {
    ui32 m_lifetime;   //lifetime in sec
    time_t m_add_time; //create time
    TString m_login;   //login

    TAllowUserData() {
        m_login = "";
        m_lifetime = 0;
    }

    TAllowUserData(const TString& login, ui32 lifetime, time_t add_time) {
        m_login = login;
        m_lifetime = lifetime;
        m_add_time = add_time;
    }

    TAllowUserData(const char* BUFF, int SizeBUFF) {
        if (SizeBUFF >= (int)(sizeof(m_lifetime) + sizeof(m_add_time))) {
            memcpy(&m_lifetime, BUFF, sizeof(m_lifetime));
            memcpy(&m_add_time, BUFF + sizeof(m_lifetime), sizeof(m_add_time));
            m_login = TString(BUFF + sizeof(m_lifetime) + sizeof(m_add_time), SizeBUFF - sizeof(m_lifetime) - sizeof(m_add_time));
        }
    }

    size_t size() const {
        size_t res = 0;

        res = sizeof(m_lifetime) + sizeof(m_add_time) + m_login.length();

        return res;
    }

    size_t GetBuffer(char* BUFF, int BuffSize) const {
        size_t res = 0;

        res = sizeof(m_lifetime) + sizeof(m_add_time) + m_login.length();
        if ((int)res <= BuffSize) {
            memcpy(BUFF, &m_lifetime, sizeof(m_lifetime));
            memcpy(BUFF + sizeof(m_lifetime), &m_add_time, sizeof(m_add_time));
            memcpy(BUFF + sizeof(m_lifetime) + sizeof(m_add_time), m_login.c_str(), m_login.length());

        } else
            res = 0;

        return res;
    }
};

typedef THashMap<ui64, TAllowUserData> TAllowUserDataHash;
typedef TAllowUserDataHash::iterator TAllowUserDataHashIt;

class TAllowUser {
private:
    static const ui32 MAXREADDUMPBUFFERU = 1000000;

private:
    TAllowUserDataHash data;
    TMutex m_Mutex;

    void Lock();
    void UnLock();
    ui64 CalcShingle(const TString& login);

public:
    TAllowUser();
    ~TAllowUser();

    bool ExistsLogin(const TString& login);
    void AddLogin(const TString& login, ui32 lifetime);
    bool RemoveLogin(const TString& login);
    void Midnight();
    bool ReadDump(const TString& Filename);
    bool WriteDump(const TString& Filename, ui32& reccount);
    TAllowUserData Get(const TString& login);
    ui32 Size();
};
