#pragma once

#include <vector>
#include <util/generic/string.h>
#include "util/system/defaults.h"
#include "util/string/util.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/sobase64.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>

#define CST_ID "id"
#define CST_LASTDATE "ld"
#define CST_HOSTNAME "shn"
#define CST_CODE "sc"
#define CST_STARTTIME "sst"
#define CST_VERSION "sv"
#define CST_RATEMODE "rm"
#define CST_CHECK "fg"
#define CST_RCPT "fp"
#define CST_CORRLS "cg"
#define CST_RESERV "cp"

struct TConsoleStatDataItem {
    char m_cps[128];
    ui64 m_today_rqst;
    ui64 m_lost_rqst;
    ui64 m_yesterday_rqst;
    ui64 m_yesterday_lost;
    ui64 m_today_putqueue_count;
    ui64 m_today_putqueue_lost;
    ui64 m_yesterday_putqueue_count;
    ui64 m_yesterday_putqueue_lost;

    TConsoleStatDataItem() {
        Clear();
    }

    void Clear() {
        memset(m_cps, 0, sizeof(m_cps));
        m_today_rqst = 0;
        m_lost_rqst = 0;
        m_yesterday_rqst = 0;
        m_yesterday_lost = 0;
        m_today_putqueue_count = 0;
        m_today_putqueue_lost = 0;
        m_yesterday_putqueue_count = 0;
        m_yesterday_putqueue_lost = 0;
    }

    TString GetTodayLostStat() {
        TString res = "-";
        float rps = 0;

        if (m_lost_rqst > 0) {
            if (m_today_rqst > 0)
                rps = static_cast<float>(m_lost_rqst) * static_cast<float>(100) / static_cast<float>(m_today_rqst);

            res = UI64ToStroka(m_lost_rqst) + " (" + FloatToStr(rps) + "%)";
        }

        return res;
    }

    TString GetYesterdayLostStat() {
        TString res = "-";
        float rps = 0;

        if (m_yesterday_lost > 0) {
            if (m_yesterday_rqst > 0)
                rps = static_cast<float>(m_yesterday_lost) * static_cast<float>(100) / static_cast<float>(m_yesterday_rqst);

            res = UI64ToStroka(m_yesterday_lost) + " (" + FloatToStr(rps) + "%)";
        }

        return res;
    }

    bool Serialize(TString& serialize_data) {
        bool res = false;
        char tbuff[256];
        size_t in_buff = 0;
        TString err_s = "";

        serialize_data = "";

        memcpy(tbuff + in_buff, m_cps, sizeof(m_cps));
        in_buff += sizeof(m_cps);

        memcpy(tbuff + in_buff, &m_today_rqst, sizeof(m_today_rqst));
        in_buff += sizeof(m_today_rqst);

        memcpy(tbuff + in_buff, &m_lost_rqst, sizeof(m_lost_rqst));
        in_buff += sizeof(m_lost_rqst);

        memcpy(tbuff + in_buff, &m_yesterday_rqst, sizeof(m_yesterday_rqst));
        in_buff += sizeof(m_yesterday_rqst);

        memcpy(tbuff + in_buff, &m_yesterday_lost, sizeof(m_yesterday_lost));
        in_buff += sizeof(m_yesterday_lost);

        memcpy(tbuff + in_buff, &m_today_putqueue_count, sizeof(m_today_putqueue_count));
        in_buff += sizeof(m_today_putqueue_count);

        memcpy(tbuff + in_buff, &m_today_putqueue_lost, sizeof(m_today_putqueue_lost));
        in_buff += sizeof(m_today_putqueue_lost);

        memcpy(tbuff + in_buff, &m_yesterday_putqueue_count, sizeof(m_yesterday_putqueue_count));
        in_buff += sizeof(m_yesterday_putqueue_count);

        memcpy(tbuff + in_buff, &m_yesterday_putqueue_lost, sizeof(m_yesterday_putqueue_lost));
        in_buff += sizeof(m_yesterday_putqueue_lost);

        res = CompressAndBase64(tbuff, in_buff, serialize_data, err_s);

        return res;
    }

    bool Deserialize(const TString& serialize_data) {
        bool res = false;
        TString result = "";
        TString err_s = "";
        bool warning_size = false;
        size_t from_buff = 0;

        res = Unbase64AndUncompress(serialize_data.c_str(), serialize_data.length(), warning_size, result, err_s);
        if (res) {
            memcpy(m_cps, result.c_str() + from_buff, sizeof(m_cps));
            from_buff += sizeof(m_cps);

            memcpy(&m_today_rqst, result.c_str() + from_buff, sizeof(m_today_rqst));
            from_buff += sizeof(m_today_rqst);

            memcpy(&m_lost_rqst, result.c_str() + from_buff, sizeof(m_lost_rqst));
            from_buff += sizeof(m_lost_rqst);

            memcpy(&m_yesterday_rqst, result.c_str() + from_buff, sizeof(m_yesterday_rqst));
            from_buff += sizeof(m_yesterday_rqst);

            memcpy(&m_yesterday_lost, result.c_str() + from_buff, sizeof(m_yesterday_lost));
            from_buff += sizeof(m_yesterday_lost);

            if ((result.length() - from_buff) >= sizeof(m_today_putqueue_count)) {
                memcpy(&m_today_putqueue_count, result.c_str() + from_buff, sizeof(m_today_putqueue_count));
                from_buff += sizeof(m_today_putqueue_count);
            }

            if ((result.length() - from_buff) >= sizeof(m_today_putqueue_lost)) {
                memcpy(&m_today_putqueue_lost, result.c_str() + from_buff, sizeof(m_today_putqueue_lost));
                from_buff += sizeof(m_today_putqueue_lost);
            }

            if ((result.length() - from_buff) >= sizeof(m_yesterday_putqueue_count)) {
                memcpy(&m_yesterday_putqueue_count, result.c_str() + from_buff, sizeof(m_yesterday_putqueue_count));
                from_buff += sizeof(m_yesterday_putqueue_count);
            }

            if ((result.length() - from_buff) >= sizeof(m_yesterday_putqueue_lost)) {
                memcpy(&m_yesterday_putqueue_lost, result.c_str() + from_buff, sizeof(m_yesterday_putqueue_lost));
                from_buff += sizeof(m_yesterday_putqueue_lost);
            }
        }

        return res;
    }
};

struct TConsoleStatData {
    ui32 m_lastdate;
    char m_serverhostname[64];
    char m_servercode[16];
    char m_serverstarttime[32];
    char m_serverversion[32];
    char m_rate_mode[128];
    TConsoleStatDataItem m_data[4];

    TConsoleStatData() {
        Clear();
    }

    void Clear() {
        m_lastdate = 0;
        memset(m_serverhostname, 0, sizeof(m_serverhostname));
        memset(m_servercode, 0, sizeof(m_servercode));
        memset(m_serverstarttime, 0, sizeof(m_serverstarttime));
        memset(m_serverversion, 0, sizeof(m_serverversion));
        memset(m_rate_mode, 0, sizeof(m_rate_mode));
        for (size_t i = 0; i < 4; i++)
            m_data[i].Clear();
    }

    static TString Name(size_t index) {
        TString res = "UNKNOWN";

        switch (index) {
            case 0:
                res = "CHECK";
                break;
            case 1:
                res = "RCVRCPT";
                break;
            case 2:
                res = "CORRLONGSTAT";
                break;
            case 3:
                res = "RESERV";
                break;
        };

        return res;
    }

    void CreateStorageRequest(nosql::HashMap& sets) {
        TString serializ_data = "";

        sets.clear();

        sets[CST_LASTDATE] = m_lastdate;
        sets[CST_HOSTNAME] = TString(m_serverhostname);
        sets[CST_CODE] = TString(m_servercode);
        sets[CST_STARTTIME] = TString(m_serverstarttime);
        sets[CST_VERSION] = TString(m_serverversion);
        sets[CST_RATEMODE] = TString(m_rate_mode);

        if (m_data[0].Serialize(serializ_data))
            sets[CST_CHECK] = serializ_data;
        if (m_data[1].Serialize(serializ_data))
            sets[CST_RCPT] = serializ_data;
        if (m_data[2].Serialize(serializ_data))
            sets[CST_CORRLS] = serializ_data;
        if (m_data[3].Serialize(serializ_data))
            sets[CST_RESERV] = serializ_data;
    }

    bool ParseRequestFromStorage(const nosql::HashMap& hash) {
        nosql::HashMap::const_iterator it;
        bool a1 = false, a2 = false, a3 = false, a4 = false, a5 = false, a6 = false, a7 = false, a8 = false, a9 = false, a10 = false;
        TString tstr = "";
        TConsoleStatDataItem csdi;

        Clear();

        it = hash.find(CST_LASTDATE);
        if (it != hash.end()) {
            m_lastdate = (*it).second.Integer();
            a1 = true;
        }

        it = hash.find(CST_HOSTNAME);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                snprintf(m_serverhostname, sizeof(m_serverhostname) - 1, "%s", tstr.c_str());
                a2 = true;
            }
        }

        it = hash.find(CST_CODE);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                snprintf(m_servercode, sizeof(m_servercode) - 1, "%s", tstr.c_str());
                a3 = true;
            }
        }

        it = hash.find(CST_STARTTIME);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                snprintf(m_serverstarttime, sizeof(m_serverstarttime) - 1, "%s", tstr.c_str());
                a4 = true;
            }
        }

        it = hash.find(CST_VERSION);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                snprintf(m_serverversion, sizeof(m_serverversion) - 1, "%s", tstr.c_str());
                a5 = true;
            }
        }

        it = hash.find(CST_RATEMODE);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                snprintf(m_rate_mode, sizeof(m_rate_mode) - 1, "%s", tstr.c_str());
                a10 = true;
            }
        }

        it = hash.find(CST_CHECK);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                csdi.Clear();
                if (csdi.Deserialize(tstr)) {
                    m_data[0] = csdi;
                    a6 = true;
                }
            }
        }

        it = hash.find(CST_RCPT);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                csdi.Clear();
                if (csdi.Deserialize(tstr)) {
                    m_data[1] = csdi;
                    a7 = true;
                }
            }
        }

        it = hash.find(CST_CORRLS);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                csdi.Clear();
                if (csdi.Deserialize(tstr)) {
                    m_data[2] = csdi;
                    a8 = true;
                }
            }
        }

        it = hash.find(CST_RESERV);
        if (it != hash.end()) {
            tstr = (*it).second.String();
            if (!tstr.empty()) {
                csdi.Clear();
                if (csdi.Deserialize(tstr)) {
                    m_data[3] = csdi;
                    a9 = true;
                }
            }
        }

        return (a1 && a2 && a3 && a4 && a5 && a6 && a7 && a8 && a9 && a10);
    }
};

typedef std::vector<TConsoleStatData> TConsoleStatDataList;
typedef TConsoleStatDataList::iterator TConsoleStatDataListIt;

TString PrintServersStatistik(TConsoleStatDataList& servers_stats);
