#pragma once

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include "tstoragenosql.h"
#include "tstorebase_data.h"
#include "tcheckform_types.h"
#ifdef _win_
#include <mail/so/spamstop/tools/so-common/find_files.h>
#endif

typedef THashMap<ui64, stordata::TLongIPDataItem> TLongIPDataItemHash;
typedef TLongIPDataItemHash::iterator TLongIPDataItemHashIt;

typedef THashMap<TString, TLongIPDataItemHash> TDaysHashLI;
typedef TDaysHashLI::iterator TDaysHashLIIt;

typedef THashMap<ui64, stordata::TShingleDataItem> TShingleDataItemHash;
typedef TShingleDataItemHash::iterator TShingleDataItemHashIt;

typedef THashMap<TString, TShingleDataItemHash> TDaysHash;
typedef TDaysHash::iterator TDaysHashIt;

class TDataBasaHash : public TStorageNoSql {
private:
    class StorageLogger;

    TDaysHash* m_data;
    TDaysHashLI* m_longip_data;
    TMutex m_Mutex;
    bool m_print_debug;

    void Lock();
    void UnLock();

private:
    bool StorageUpdate(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err);
    bool StorageFindOne(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, nosql::HashMap& hash, bool& err);
    bool StorageFind(stor_bt::TShingleStorageType sstype, const TString& ext_collname, TVector<nosql::HashMap>& hashes, bool& err);
    bool StorageErase(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err);
    i64 StorageSize(int type, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err);
    bool StorageTableDrop(int type, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err);
    void StorageMultiAction(stor_bt::TStorageActionList& actlist, bool& err);

    bool CreateCollection(const TString& collection_name, TString& err_s);
    bool DeleteCollection(const TString& collection_name, TString& err_s);

    TString ReturnDriverProp() {
        return "";
    }
    qustat::TDriverRqstPoolStat ReturnLiveRqstStatMaster() {
        return qustat::TDriverRqstPoolStat();
    }
    qustat::TDriverRqstPoolStat ReturnLiveRqstStatReplica() {
        return qustat::TDriverRqstPoolStat();
    }

    bool IsLongIPCollection(const TString& collection_name);
    void GetOtherCollection(const TString& collection_name, ui64 shingle, stor_bt::TNoSqlItem* nosqldata);
    void UpdateOtherCollection(const TString& collection_name, ui64 shingle, stor_bt::TNoSqlItem* nosqldata);
    void GetLongIPCollection(const TString& collection_name, ui64 shingle, stor_bt::TNoSqlItem* nosqldata);
    void UpdateLongIPCollection(const TString& collection_name, ui64 shingle, stor_bt::TNoSqlItem* nosqldata);

    bool WriteDumpOtherCollections(const TString& path, ui32& collection_count, ui32& record_count);
    bool ReadDumpOtherCollections(const TString& path, ui32& collection_count, ui32& record_count);
    bool ListDumpOtherCollections(const TString& path, ui32& collection_count, ui32& record_count);

    bool WriteDumpLongIP(const TString& path, ui32& collection_count, ui32& record_count);
    bool ReadDumpLongIP(const TString& path, ui32& collection_count, ui32& record_count);
    bool ListDumpLongIP(const TString& path, ui32& collection_count, ui32& record_count);

public:
    TDataBasaHash();
    virtual ~TDataBasaHash();

    bool InitBeforeFork(TServiceType servicetypeA, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupCF* LogsGroupA, TKConfig* configobjA);
    bool InitBeforeForkNum(int index, TServiceType servicetypeA, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupCF* LogsGroupA, TKConfig* configobjA);
    void InitAfterFork();

    bool WriteDump(const TString& path, ui32& collection_count, ui32& record_count);
    bool ReadDump(const TString& path, ui32& collection_count, ui32& record_count);
    bool ListDump(const TString& path, ui32& collection_count, ui32& record_count);
};
