#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "util/string/util.h"
#include "util/system/rwlock.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/system/env.h"
#include <util/generic/map.h>
#include <util/generic/vector.h>
#include <mail/so/spamstop/tools/so-common/eventhandler.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/postgreclient/interface.h>
#include <mail/so/spamstop/tools/postgreclient/pq/Error.h>
#include <mail/so/spamstop/tools/so-common/tbasestoragetypes.h>
#include "tstoragenosql.h"
#include "tconsolestat.h"

//*********************************************************************************************************************************
//                                                       TDataBasaPostgre
//*********************************************************************************************************************************

#define SHINGLEDATA_COLLECTION "SHINGLEDATA"

#define ASYNC_MODE true
//#define ASYNC_MODE false

struct TBulkReadData {
    TMap<ui64, nosql::HashMap*> m_bulk_read_hash;
    TMap<ui64, bool*> m_bulk_read_error;
    TString m_collection_name;
    bool m_err;

    TBulkReadData() {
        Clear();
    }

    TBulkReadData(TString& collection_name, ui64 shingle, nosql::HashMap* data, bool* errp) {
        Clear();

        m_collection_name = collection_name;
        m_bulk_read_hash[shingle] = data;
        m_bulk_read_error[shingle] = errp;
    }

    void Clear() {
        m_bulk_read_hash.clear();
        m_bulk_read_error.clear();
        m_collection_name = "";
        m_err = false;
    }

    void SetErrors() {
        TMap<ui64, bool*>::iterator it;

        it = m_bulk_read_error.begin();
        while (it != m_bulk_read_error.end()) {
            if ((*it).second != NULL)
                (*((*it).second)) = m_err;

            ++it;
        }
    }
};

typedef std::list<TBulkReadData> TBulkReadDataList;
typedef TBulkReadDataList::iterator TBulkReadDataListIt;

class TDataBasaPostgre : public TStorageNoSql {
private:
    class StorageLogger;
    static TAtomic inited;

    TString m_host;
    TString m_user;
    bool m_pwd_define;
    size_t m_port;
    static bool skipResponsesToBD;
    ui32 m_pool_item_size_master;
    ui32 m_wait_pool_item_ms_master;
    ui32 m_pool_item_size_replica;
    ui32 m_wait_pool_item_ms_replica;
    ui32 m_rcv_timeout_ms;
    ui32 m_allow_full_time;
    TString m_conn_string;
    TString m_conn_string_hidden;

    typedef enum { RT_REPLICA,
                   RT_MASTER } TRequestType;

private:
    bool StorageUpdate(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err);
    bool StorageFindOne(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, nosql::HashMap& hash, bool& err);
    bool StorageFind(stor_bt::TShingleStorageType sstype, const TString& ext_collname, TVector<nosql::HashMap>& hashes, bool& err);
    bool StorageErase(ui64 shingle, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err);
    i64 StorageSize(int type, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err);
    bool StorageTableCreate(int type, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err, const sql::table_t& table);
    bool StorageTableDrop(int type, stor_bt::TShingleStorageType sstype, const TString& ext_collname, bool& err);
    void StorageMultiAction(stor_bt::TStorageActionList& actlist, bool& err);

    bool CreateCollection(const TString& collection_name, TString& err_s);
    bool DeleteCollection(const TString& collection_name, TString& err_s);

    TString ReturnDriverProp();

    bool CheckConnection(TString& status);
    void prepareTables();
    qustat::TDriverRqstPoolStat ReturnLiveRqstStatMaster();
    qustat::TDriverRqstPoolStat ReturnLiveRqstStatReplica();

    TString CorrectInitPassword(const TString& init_str);

    TString ModifyLONGIPSTATCollection(const TString& collection_name);
    sql::table_t GetSheme(const TString& collection_name);

public:
    TDataBasaPostgre();
    virtual ~TDataBasaPostgre();

    bool InitBeforeFork(TServiceType servicetypeA, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupCF* LogsGroupA, TKConfig* configobjA);
    bool InitBeforeForkNum(int index, TServiceType servicetypeA, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupCF* LogsGroupA, TKConfig* configobjA);
    void InitAfterFork();

    bool WriteDump(const TString& path, ui32& collection_count, ui32& record_count) {
        Y_UNUSED(path, collection_count, record_count);
        return true;
    }
    bool ReadDump(const TString& path, ui32& collection_count, ui32& record_count) {
        Y_UNUSED(path, collection_count, record_count);
        return true;
    }
    bool ListDump(const TString& path, ui32& collection_count, ui32& record_count) {
        Y_UNUSED(path, collection_count, record_count);
        return true;
    }

private:
    TMap<TString, sql::table_t> tables;
};

//*********************************************************************************************************************************
