#include "tdelaysstorage.h"

//******************************************************************************************************************************************
//                                                          TDelaysStorage
//******************************************************************************************************************************************

TDelaysStorageItem::TDelaysStorageItem() {
    m_srvc = "";
}

TDelaysStorageItem::TDelaysStorageItem(const TString& srvcname) {
    m_srvc = srvcname;
}

TDelaysStorageItem::TDelaysStorageItem(const TString& srvcname, const TString& formname, ui32 delay, bool spam, bool ban, bool dirty, int http_code) {
    m_srvc = srvcname;
    m_data[formname] = TFormDelaysData(delay, spam, ban, dirty, http_code);
}

TDelaysStorageItem::~TDelaysStorageItem() {
}

void TDelaysStorageItem::Init(const TString& srvcname) {
    m_srvc = srvcname;
}

void TDelaysStorageItem::Add(const TString& formname, ui32 delay, bool spam, bool ban, bool dirty, int http_code) {
    TFormsDelaysHashIt it;

    it = m_data.find(formname);
    if (it != m_data.end()) {
        (*it).second.Add(delay, spam, ban, dirty, http_code);

    } else {
        m_data[formname] = TFormDelaysData(delay, spam, ban, dirty, http_code);
    }
}

TString TDelaysStorageItem::GetStat() {
    TString res = "";
    TFormsDelaysHashIt it;

    if (m_data.size() == 0) {
        res = "<FSSD srvc='" + m_srvc + "' ->";

    } else {
        it = m_data.begin();
        while (it != m_data.end()) {
            res = res + (*it).second.GetStat(m_srvc, (*it).first);

            ++it;
        }
    }

    return res;
}

void TDelaysStorageItem::Clear() {
    TFormsDelaysHashIt it;

    it = m_data.begin();
    while (it != m_data.end()) {
        (*it).second.Clear();

        ++it;
    }
}

//******************************************************************************************************************************************
//                                                          TDelaysStorageMain
//******************************************************************************************************************************************

TDelaysStorageMain::TDelaysStorageMain() {
    m_start_add = time(NULL);
}

TDelaysStorageMain::~TDelaysStorageMain() {
}

void TDelaysStorageMain::AddSrvc(const TString& srvcname) {
    TDelaysStorageItemListIt it;
    bool exists = false;

    m_Mutex.Acquire();

    it = m_data.begin();
    while (it != m_data.end()) {
        if ((*it).GerSrvcName() == srvcname) {
            exists = true;
            break;
        }

        ++it;
    }
    if (!exists)
        m_data.push_back(TDelaysStorageItem(srvcname));

    m_Mutex.Release();
}

void TDelaysStorageMain::Add(const TString& srvcname, const TString& formname, ui32 delay, bool spam, bool ban, bool dirty, int http_code) {
    TDelaysStorageItemListIt it;
    bool exists = false;

    m_Mutex.Acquire();

    it = m_data.begin();
    while (it != m_data.end()) {
        if ((*it).GerSrvcName() == srvcname) {
            (*it).Add(formname, delay, spam, ban, dirty, http_code);
            exists = true;
            break;
        }

        ++it;
    }
    if (!exists)
        m_data.push_back(TDelaysStorageItem(srvcname, formname, delay, spam, ban, dirty, http_code));

    m_Mutex.Release();
}

TString TDelaysStorageMain::GetStat(const TString& hostcode) {
    TString res = "";
    TDelaysStorageItemListIt it;
    time_t current_time = 0;
    ui32 tp = 0;

    //"#<DSST period=time srvr=hostcode><FSSD srvc='srvcname' form='formname' delays(ms)=<50,<100,<200,<300,<400,<500,<600,<700,<1000,<3000,<5000,>=5000 httpcode=200,4xx,5xx,other ham=XX spam=XX ban=XX dirty=XX>"

    m_Mutex.Acquire();

    current_time = time(NULL);

    if ((m_start_add != 0) && (current_time > m_start_add)) {
        tp = current_time - m_start_add;
        res = res + "<DSST period='" + IntToHourMinSec(tp) + "' srvr=" + hostcode + ">";
    }

    it = m_data.begin();
    while (it != m_data.end()) {
        res = res + (*it).GetStat();
        (*it).Clear();

        ++it;
    }

    m_start_add = current_time;

    m_Mutex.Release();

    return res;
}

//******************************************************************************************************************************************
