#pragma once

#include "util/system/mutex.h"
#include <util/generic/string.h>
#include "util/generic/hash.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <list>

//******************************************************************************************************************************************
//                                                          TDelaysStorageItem
//******************************************************************************************************************************************

struct TFormDelaysData {
    ui32 delays_array[12];
    ui32 code_200;
    ui32 code_4xx;
    ui32 code_5xx;
    ui32 code_other;
    ui32 ham_count;
    ui32 spam_count;
    ui32 ban_count;
    ui32 dirty_count;

    TFormDelaysData() {
        Clear();
    }

    TFormDelaysData(ui32 delay, bool spam, bool ban, bool dirty, int http_code) {
        Clear();
        Add(delay, spam, ban, dirty, http_code);
    }

    void Clear() {
        memset(delays_array, 0, sizeof(delays_array));
        code_200 = 0;
        code_4xx = 0;
        code_5xx = 0;
        code_other = 0;
        ham_count = 0;
        spam_count = 0;
        ban_count = 0;
        dirty_count = 0;
    }

    void Add(ui32 delay, bool spam, bool ban, bool dirty, int http_code) {
        //delays
        if (delay < 50)
            delays_array[0] = IncMax32(delays_array[0], 1);
        else if (delay < 100)
            delays_array[1] = IncMax32(delays_array[1], 1);
        else if (delay < 200)
            delays_array[2] = IncMax32(delays_array[2], 1);
        else if (delay < 300)
            delays_array[3] = IncMax32(delays_array[3], 1);
        else if (delay < 400)
            delays_array[4] = IncMax32(delays_array[4], 1);
        else if (delay < 500)
            delays_array[5] = IncMax32(delays_array[5], 1);
        else if (delay < 600)
            delays_array[6] = IncMax32(delays_array[6], 1);
        else if (delay < 700)
            delays_array[7] = IncMax32(delays_array[7], 1);
        else if (delay < 1000)
            delays_array[8] = IncMax32(delays_array[8], 1);
        else if (delay < 3000)
            delays_array[9] = IncMax32(delays_array[9], 1);
        else if (delay < 5000)
            delays_array[10] = IncMax32(delays_array[10], 1);
        else
            delays_array[11] = IncMax32(delays_array[11], 1);

        //http code
        if (http_code == 200)
            code_200 = IncMax32(code_200, 1);
        else if ((http_code >= 400) && (http_code <= 499))
            code_4xx = IncMax32(code_4xx, 1);
        else if ((http_code >= 500) && (http_code <= 599))
            code_5xx = IncMax32(code_5xx, 1);
        else
            code_other = IncMax32(code_other, 1);

        //spam/ham
        if (spam)
            spam_count = IncMax32(spam_count, 1);
        else
            ham_count = IncMax32(ham_count, 1);

        //ban
        if (ban)
            ban_count = IncMax32(ban_count, 1);

        //dirty
        if (dirty)
            dirty_count = IncMax32(dirty_count, 1);
    }

    TString GetStat(const TString& srvc, const TString& formname) {
        TString res = "";

        //"<FSSD srvc='srvcname' form='formname' delays(ms)=<50,<100,<200,<300,<400,<500,<600,<700,<1000,<3000,<5000,>=5000 httpcode=200,4xx,5xx,other ham=XX spam=XX ban=XX dirty=XX>"

        res = res + "<FSSD srvc='" + srvc + "' form='" + formname + "' ";

        if ((spam_count == 0) && (ham_count == 0)) {
            res = res + "nodata ";

        } else {
            res = res + "delays=";
            for (int i = 0; i < 12; i++) {
                if (i == 11)
                    res = res + IntToStroka(delays_array[i]) + " ";
                else
                    res = res + IntToStroka(delays_array[i]) + ",";
            }

            res = res + "httpcode=" + IntToStroka(code_200) + "," + IntToStroka(code_4xx) + "," + IntToStroka(code_5xx) + "," + IntToStroka(code_other) + " ";

            res = res + "ham=" + IntToStroka(ham_count) + " ";
            res = res + "spam=" + IntToStroka(spam_count) + " ";
            res = res + "ban=" + IntToStroka(ban_count) + " ";
            res = res + "dirty=" + IntToStroka(dirty_count) + " ";
        }
        res = res + ">";

        return res;
    }
};

typedef THashMap<TString, TFormDelaysData> TFormsDelaysHash;
typedef TFormsDelaysHash::iterator TFormsDelaysHashIt;

class TDelaysStorageItem {
private:
    TFormsDelaysHash m_data;
    TString m_srvc;

public:
    TDelaysStorageItem();
    TDelaysStorageItem(const TString& srvcname);
    TDelaysStorageItem(const TString& srvcname, const TString& formname, ui32 delay, bool spam, bool ban, bool dirty, int http_code);
    ~TDelaysStorageItem();

    void Init(const TString& srvcname);
    void Add(const TString& formname, ui32 delay, bool spam, bool ban, bool dirty, int http_code);
    TString GetStat();
    TString GerSrvcName() {
        return m_srvc;
    }
    void Clear();
};

//******************************************************************************************************************************************
//                                                          TDelaysStorageMain
//******************************************************************************************************************************************

typedef std::list<TDelaysStorageItem> TDelaysStorageItemList;
typedef TDelaysStorageItemList::iterator TDelaysStorageItemListIt;

class TDelaysStorageMain {
private:
    TDelaysStorageItemList m_data;
    TMutex m_Mutex;
    time_t m_start_add;

public:
    TDelaysStorageMain();
    ~TDelaysStorageMain();

    void AddSrvc(const TString& srvcname);
    void Add(const TString& srvcname, const TString& formname, ui32 delay, bool spam, bool ban, bool dirty, int http_code);
    TString GetStat(const TString& hostcode);
};

//******************************************************************************************************************************************
