#include "tgeneralobject.h"

#ifdef INTERFACE
#undef INTERFACE
#endif

//******************************************************************************************************************************************
//                                                       TGeneralObject
//******************************************************************************************************************************************

TGeneralObject::TGeneralObject() {
    m_service_type = SO_CHECKFORM;
    m_storagetype = STORAGE_INTERNAL;
    LogsGroup = NULL;
    config = NULL;
    server_id = "";
    last_write_mondata = time(NULL);
    m_last_write_console_stat = static_cast<ui32>(time(NULL));
    m_last_read_console_stat = static_cast<ui32>(time(NULL));
    m_last_write_dump = static_cast<ui32>(time(NULL));
    m_filter = NULL;
    m_groupfilter = NULL;
    m_delaysstorage = NULL;
    AllowService = NULL;
    m_signhash = NULL;
    FieldCheck = NULL;
    LoginCheck = NULL;
    AntiDDOSCheck = NULL;
    m_last_update_stat_to_database = static_cast<ui32>(time(NULL));
}

TGeneralObject::~TGeneralObject() {
    if (FieldCheck != NULL) {
        delete FieldCheck;
        FieldCheck = NULL;
    }

    if (LoginCheck != NULL) {
        delete LoginCheck;
        LoginCheck = NULL;
    }

    if (AntiDDOSCheck != NULL) {
        delete AntiDDOSCheck;
        AntiDDOSCheck = NULL;
    }

    if (m_signhash != NULL) {
        delete m_signhash;
        m_signhash = NULL;
    }

    if (AllowService != NULL) {
        delete AllowService;
        AllowService = NULL;
    }

    if (m_delaysstorage != NULL) {
        delete m_delaysstorage;
        m_delaysstorage = NULL;
    }

    if (m_groupfilter != NULL) {
        delete m_groupfilter;
        m_groupfilter = NULL;
    }

    if (m_filter != NULL) {
        delete m_filter;
        m_filter = NULL;
    }
}

TLogsGroupCF* TGeneralObject::GetLogsGroup() {
    return (TLogsGroupCF*)LogsGroup;
}

bool TGeneralObject::InitBeforeFork(const TString& server_idA, TLogsGroupBase* LogsGroupA, TKConfig* configA) {
    TLogClass* log = NULL;

    LogsGroup = LogsGroupA;
    config = configA;
    server_id = server_idA;

    if (GetLogsGroup() != NULL)
        log = GetLogsGroup()->GetServerLog();

    if (config != NULL) {
        TString tstr = config->ReadStroka("server", "srvctype", "checkform");
        if (tstr == "checkform")
            m_service_type = SO_CHECKFORM;
        else if (tstr == "cleanweb")
            m_service_type = SO_CLEANWEB;
        else if (tstr == "msearch")
            m_service_type = SO_MSEARCH;

        TString storage_type = config->ReadStroka("server", "storage", "INTERNAL");
        storage_type.to_upper(0, storage_type.length());
        if (storage_type == "MONGO")
            m_storagetype = STORAGE_MONGO;
        else if (storage_type == "REDIS")
            m_storagetype = STORAGE_REDIS;
        else
            m_storagetype = STORAGE_INTERNAL;

        TString tstr2 = config->ReadStroka("server", "allowservices", "");
        AllowService = new TAllowService();
        if (AllowService != NULL)
            AllowService->LoadServices(tstr2);

        bool limit_disable = config->ReadBool("rqst_limit", "disable", false);
        ui32 check_perc = config->ReadInteger("rqst_limit", "check", 90);
        ui32 corrlongstat_perc = config->ReadInteger("rqst_limit", "corrlongstat", 5);
        ui32 interface_perc = config->ReadInteger("rqst_limit", "interface", 5);

        LimitObj.Init(config, limit_disable);
        LimitObj.AddItem(TMakeRequestLimit::CHECK, check_perc);
        LimitObj.AddItem(TMakeRequestLimit::CORRLONGSTAT, corrlongstat_perc);
        LimitObj.AddItem(TMakeRequestLimit::INTERFACE, interface_perc);

        TString ipcachedump_s = config->ReadStroka("server", "ipcachedump", "");

        m_delaysstorage = new TDelaysStorageMain();

        m_groupfilter = new TGroupFilter();
        if (m_groupfilter != NULL)
            m_groupfilter->Init(m_service_type, m_storagetype, GetServerHostName(), GetServerCode(), GetServerStartTime(), GetServerVersion(), GetLogsGroup(), AllowService, config, m_delaysstorage);

        FieldCheck = new TKIniFile();
        if (FieldCheck != NULL) {
            FieldCheck->Init(config->ReadStroka("filter", "fieldcheck", ""));
            WriteToLogBig(KMESSAGE, "CheckField data: %s", FieldCheck->GetAllField().c_str());
        }

        LoginCheck = new TKIniFile();
        if (LoginCheck != NULL) {
            LoginCheck->Init(config->ReadStroka("filter", "logincheck", ""));
            WriteToLogBig(KMESSAGE, "CheckLogin data: %s", LoginCheck->GetAllField().c_str());
        }

        AntiDDOSCheck = new TKIniFile();
        if (AntiDDOSCheck != NULL) {
            AntiDDOSCheck->Init(config->ReadStroka("filter", "antiddoscheck", ""));
            WriteToLogBig(KMESSAGE, "AntiDDOS data: %s", AntiDDOSCheck->GetAllField().c_str());
        }

        //signaturehash (for MSEARCH_PROXY)
        if ((AllowService != NULL) && (AllowService->ExistsService("MSEARCH-PROXY"))) {
            TString m_signaturehash_filename = config->ReadStroka("***MSEARCH-PROXY", "signaturehash", "");
            if (!m_signaturehash_filename.empty()) {
                m_signhash = new TSignatureClass();
                if (m_signhash != NULL) {
                    m_signhash->Init(m_signaturehash_filename, GetLogsGroup()->GetServerLog());
                    m_signhash->Reload();
                }
            }
        }

        //filter
        m_filter = new CSoFilterCF();
        if (m_filter != NULL)
            m_filter->InitBeforeFork(config, GetLogsGroup(), m_signhash, m_storagetype, m_groupfilter, FieldCheck, ipcachedump_s, LoginCheck, AntiDDOSCheck);
    }

    m_check_tc.Init(10000, 20000, true, false);

    traccert_stat.Init();
    traccert_stat_forecast.Init();

    return true;
}

bool TGeneralObject::InitAfterFork() {
    ui32 collection_count = 0;
    ui32 record_count = 0;

    ReadDump(collection_count, record_count);

    if (m_filter != NULL)
        m_filter->InitAfterFork(NULL);

    if (m_groupfilter != NULL)
        m_groupfilter->InitAfterFork();

    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
        GetLogsGroup()->GetServerLog()->FFlush();

    return true;
}

bool TGeneralObject::Midnight() {
    /*if ( (GetLogsGroup() != NULL) && (GetLogsGroup()->GetLogTraccertDays() != NULL) )
   {
      TString trassert_days = GetTraccertStatWeb();
      GetLogsGroup()->GetLogTraccertDays()->WriteMessageBUFF(trassert_days.c_str(), trassert_days.length());

   }*/

    LimitObj.Midnight();
    traccert_stat.Midnight();
    traccert_stat_forecast.Midnight();

    if (GetLogsGroup() != NULL)
        GetLogsGroup()->TruncLog();

    m_check_tc.Midnight();

    if (m_filter != NULL)
        m_filter->Midnight();

    return true;
}

bool TGeneralObject::Shutdown() {
    if (m_filter != NULL)
        m_filter->Shutdown();

    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
        GetLogsGroup()->GetServerLog()->FFlush();

    return true;
}

void TGeneralObject::EventTick() {
    m_check_tc.CalcCPS();

    GetServersStatistikAuto();

    if (m_filter != NULL)
        m_filter->EventTick();

    WriteConsoleStatToStorage();
    WriteStatToLog();
}

bool TGeneralObject::Close() {
    ui32 collection_count = 0;
    ui32 record_count = 0;

    WriteDump(collection_count, record_count);

    if (m_filter != NULL)
        m_filter->Close();

    return true;
}

bool TGeneralObject::WriteDump(ui32& collection_count, ui32& record_count) {
    bool res = false;
    TString path = "";
    TString text = "";
    ui32 tick = CShingleTime::GetMs();

    if ((config != NULL) && (GetGroupFilter() != NULL) && (GetGroupFilter()->GetCommonStore() != NULL)) {
        path = config->ReadStroka("server", "dumppath", "");
        if (!path.empty())
            res = GetGroupFilter()->GetCommonStore()->WriteDump(path, collection_count, record_count);
    }

    tick = CShingleTime::GetMs() - tick;

    if (res) {
        text = "write dump - OK (" + IntToStroka(tick) + "ms, collection_count = " + IntToStroka(collection_count) + ", all_record_count = " + IntToStroka(record_count) + ")";
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", text.c_str());

    } else {
        text = "write dump - FAILED (" + IntToStroka(tick) + "ms)";
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s", text.c_str());
    }

    return res;
}

bool TGeneralObject::ReadDump(ui32& collection_count, ui32& record_count) {
    bool res = false;
    TString path = "";
    TString text = "";
    ui32 tick = CShingleTime::GetMs();

    if ((config != NULL) && (GetGroupFilter() != NULL) && (GetGroupFilter()->GetCommonStore() != NULL)) {
        path = config->ReadStroka("server", "dumppath", "");
        if (!path.empty())
            res = GetGroupFilter()->GetCommonStore()->ReadDump(path, collection_count, record_count);
    }

    tick = CShingleTime::GetMs() - tick;

    if (res) {
        text = "read dump - OK (" + IntToStroka(tick) + "ms, collection_count = " + IntToStroka(collection_count) + ", all_record_count = " + IntToStroka(record_count) + ")";
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", text.c_str());

    } else {
        text = "read dump - FAILED (" + IntToStroka(tick) + "ms)";
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s", text.c_str());
    }

    return res;
}

bool TGeneralObject::ListDump(ui32& collection_count, ui32& record_count) {
    bool res = false;
    TString path = "";
    TString text = "";
    ui32 tick = CShingleTime::GetMs();

    if ((config != NULL) && (GetGroupFilter() != NULL) && (GetGroupFilter()->GetCommonStore() != NULL)) {
        path = config->ReadStroka("server", "dumppath", "");
        if (!path.empty())
            res = GetGroupFilter()->GetCommonStore()->ListDump(path, collection_count, record_count);
    }

    tick = CShingleTime::GetMs() - tick;

    if (res) {
        text = "list dump - OK (" + IntToStroka(tick) + "ms, collection_count = " + IntToStroka(collection_count) + ", all_record_count = " + IntToStroka(record_count) + ")";
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", text.c_str());

    } else {
        text = "list dump - FAILED (" + IntToStroka(tick) + "ms)";
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s", text.c_str());
    }

    return res;
}

void TGeneralObject::WriteStatToLog() {
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetMonLog())) {
        ui32 last_write_mondata_diff = time(NULL) - last_write_mondata;

        if (last_write_mondata_diff >= 60) {
            TString mon_text = "";
            TStorageInfoExt si;

            //server code "<SCODE: server_code>"
            mon_text += "<SCODE: " + GetServerCode() + ">";

            //input statistik
            mon_text += LimitObj.GetMonStatistik();

            //storage statistik
            mon_text += GetStorageMonStatistik();

            GetLogsGroup()->GetMonLog()->WriteMessageAndData("%s", mon_text.c_str());
            GetLogsGroup()->GetMonLog()->FFlush();

            last_write_mondata = time(NULL);
        }
    }
}

/*TStorageInfoFull TGeneralObject::GetStorageFullInfo(int index, bool &notfound)
{
   TStorageInfoFull res;

   if (m_StoragePool != NULL)
      res = m_StoragePool->GetStorageFullInfo(index, notfound);

   return res;
}*/

TString TGeneralObject::GetPutQueueProperties() {
    TString res = "";

    if (GetStorage() != NULL)
        res = ((TStorageNoSql*)GetStorage())->GetPutQueueProperties();

    return res;
}

TString TGeneralObject::GetStorageIdent() {
    TString res = "";

    if (GetStorage() != NULL)
        res = ((TStorageNoSql*)GetStorage())->GetStorageIdent();

    return res;
}

TString TGeneralObject::GetDriverProperties() {
    TString res = "";

    if (GetStorage())
        res = ((TStorageNoSql*)GetStorage())->ReturnDriverProp();

    return res;
}

TString TGeneralObject::GetStorageWebStatistik() {
    TString res = "";

    if (GetStorage() != NULL) {
        NStorageStats::TStorageStatVector stat;

        stat = ((TStorageNoSql*)GetStorage())->GetWebStatistik();
        res = stat.PrintDataWEB(false, false, false);

        //live time thread in postgree driver (master)
        res += ((TStorageNoSql*)GetStorage())->GetLiveRqstData(true) + "<br>";
        res += ((TStorageNoSql*)GetStorage())->GetLiveRqstData(false) + "<br>";
    }

    return res;
}

TString TGeneralObject::GetReadCacheStatistik() {
    TString res = "";

    if (GetStorage() != NULL) {
        res += "<b><i>Input cache statistik for long ip storage:</i></b><br>";
        res += ((TStorageNoSql*)GetStorage())->GetLongIPCacheStatS() + "<br>";

        res += "<b><i>Input cache statistik for today data storage:</i></b><br>";
        res += ((TStorageNoSql*)GetStorage())->GetDataTodayCacheStatS() + "<br>";

        res += "<b><i>Input cache statistik for yesterday data storage:</i></b><br>";
        res += ((TStorageNoSql*)GetStorage())->GetDataYesterdayCacheStatS() + "<br>";
    }

    return res;
}

TString TGeneralObject::GetPutQueueStatistik() {
    TString res = "";

    if (GetStorage() != NULL) {
        res += "<b><i>Put queue statistik:</i></b><br>";
        res += ((TStorageNoSql*)GetStorage())->GetUpdateQueueWebStatistik() + "<br>";
    }

    return res;
}

TString TGeneralObject::GetStorageTraccertStatistik() {
    TString res = "";

    if (GetStorage() != NULL) {
        res += "<i><b>Traccert request to storage:</b></i><br>";
        res += ((TStorageNoSql*)GetStorage())->GetTraccertStat() + "<br>";
    }

    return res;
}

TString TGeneralObject::GetStorageMonStatistik() {
    TString res = "";

    if (GetStorage() != NULL) {
        NStorageStats::TStorageStatVector stat;

        stat = ((TStorageNoSql*)GetStorage())->GetMonStatistik();
        res = stat.PrintDataLog();

        res += ((TStorageNoSql*)GetStorage())->GetPutQueueMonStatistik();
    }

    return res;
}

TString TGeneralObject::GetUpdateQueueWebStatistik() {
    TString res = "";

    if (GetStorage() != NULL)
        res = ((TStorageNoSql*)GetStorage())->GetUpdateQueueWebStatistik();

    return res;
}

TConsoleStatDataItem GetLocalConsoleStatItem(TTrafficControl& tc_obj) {
    TConsoleStatDataItem res;

    snprintf(res.m_cps, sizeof(res.m_cps) - 1, "%s", tc_obj.GetStatistMin().c_str());
    res.m_today_rqst = tc_obj.GetTodayRequest();
    res.m_lost_rqst = tc_obj.GetTodayUserValue1Request();
    res.m_yesterday_rqst = tc_obj.GetYesterdayRequest();
    res.m_yesterday_lost = tc_obj.GetYesterdayUserValue1Request();

    return res;
}

TConsoleStatData TGeneralObject::GetLocalConsoleStat() {
    TConsoleStatData res;
    qustat::TDriverRqstPoolStatFour putqueue_stat;

    /*if (m_StoragePool != NULL)
   {
      TStorageInfoExt storobj;

      storobj = m_StoragePool->GetStorageInfo(0, 0, 0);
      if (storobj.storage != NULL)
         putqueue_stat = ((TStorageNoSql *)storobj.storage)->GetConsoleStat();
   }*/

    res.m_lastdate = time(NULL);

    snprintf(res.m_serverhostname, sizeof(res.m_serverhostname) - 1, "%s", GetServerHostName().c_str());
    snprintf(res.m_servercode, sizeof(res.m_servercode) - 1, "%s", GetServerCode().c_str());
    snprintf(res.m_serverstarttime, sizeof(res.m_serverstarttime) - 1, "%s", GetServerStartTime().c_str());
    snprintf(res.m_serverversion, sizeof(res.m_serverversion) - 1, "%s", GetServerVersion().c_str());
    snprintf(res.m_rate_mode, sizeof(res.m_rate_mode), "-");

    res.m_data[0] = GetLocalConsoleStatItem(m_check_tc);
    res.m_data[0].m_today_putqueue_count = putqueue_stat.m_today_fastput.GetCount();
    res.m_data[0].m_today_putqueue_lost = putqueue_stat.m_today_fastput.GetInputLost();
    res.m_data[0].m_yesterday_putqueue_count = putqueue_stat.m_yesterday_fastput.GetCount();
    res.m_data[0].m_yesterday_putqueue_lost = putqueue_stat.m_yesterday_fastput.GetInputLost();

    res.m_data[1] = TConsoleStatDataItem(); //GetLocalConsoleStatItem(m_loginrcpt_tc);
    res.m_data[2] = TConsoleStatDataItem(); //GetLocalConsoleStatItem(m_corrlongstat_tc);
    res.m_data[3] = TConsoleStatDataItem(); //GetLocalConsoleStatItem(m_reserv_tc);

    return res;
}

void TGeneralObject::WriteConsoleStatToStorage() {
    ui32 currenttime = static_cast<ui32>(time(NULL));
    ui32 t_diff = 0;

    if (currenttime > m_last_write_console_stat)
        t_diff = currenttime - m_last_write_console_stat;

    if (t_diff >= 15) {
        TString srv_code = GetServerCode();

        if (!srv_code.empty()) {
            nosql::HashMap sets;
            TConsoleStatData c_stat;
            ui64 id = 0;

            if (sscanf(srv_code.c_str(), "%lx", &id) != 1)
                id = ShingleFromStroka(srv_code);
            c_stat = GetLocalConsoleStat();

            c_stat.CreateStorageRequest(sets);

            if (GetStorage() != NULL)
                ((TStorageNoSql*)GetStorage())->WriteConsoleDataToStorage(id, sets);
        }

        m_last_write_console_stat = currenttime;
    }
}

ui32 TGeneralObject::GetServersStatistik(TConsoleStatDataList& servers_stats) {
    TConsoleStatData local;
    TString local_s = "LOCAL";
    TConsoleStatDataList servers_stats_ext;
    TConsoleStatDataListIt it;
    TString marker = "***";
    TString tstr = "";
    ui32 tick = 0;

    local = GetLocalConsoleStat();
    memset(local.m_serverhostname, 0, sizeof(local.m_serverhostname));
    snprintf(local.m_serverhostname, sizeof(local.m_serverhostname) - 1, "%s", local_s.c_str());

    if (true) {
        tick = CShingleTime::GetMs();
        if (GetStorage() != NULL)
            ((TStorageNoSql*)GetStorage())->ReadConsoleDataFromStorage(servers_stats_ext);
        tick = CShingleTime::GetMs() - tick;
    }

    servers_stats.push_back(local);
    it = servers_stats_ext.begin();
    while (it != servers_stats_ext.end()) {
        tstr = TString((*it).m_servercode);
        if (tstr == TString(local.m_servercode))
            snprintf((*it).m_servercode, sizeof((*it).m_servercode) - 1, "%s%s", marker.c_str(), tstr.c_str());

        servers_stats.push_back(*it);

        ++it;
    }

    return tick;
}

TString TGeneralObject::GetServersStatistikText(ui32& stor_tick) {
    TString res = "";
    TConsoleStatDataList servers_stats;

    stor_tick = GetServersStatistik(servers_stats);
    res = PrintServersStatistik(servers_stats);

    {
        //last update statistik to BD (PGaaS)
        for (size_t i = 0; i < servers_stats.size(); i++) {
            if (strstr(servers_stats[i].m_servercode, "***") != NULL) {
                m_last_update_stat_to_database = servers_stats[i].m_lastdate;
            }
        }

        m_last_read_console_stat = static_cast<ui32>(time(NULL));
    }

    return res;
}

void TGeneralObject::GetServersStatistikAuto() {
    ui32 currenttime = static_cast<ui32>(time(NULL));
    ui32 t_diff = 0;

    if (currenttime > m_last_read_console_stat)
        t_diff = currenttime - m_last_read_console_stat;

    if (t_diff > 30) {
        TConsoleStatDataList servers_stats;

        GetServersStatistik(servers_stats);

        //last update statistik to BD (PGaaS)
        for (size_t i = 0; i < servers_stats.size(); i++) {
            if (strstr(servers_stats[i].m_servercode, "***") != NULL) {
                m_last_update_stat_to_database = servers_stats[i].m_lastdate;
            }
        }

        m_last_read_console_stat = currenttime;
    }
}

bool TGeneralObject::StorageInitStatus(TString& status) {
    bool res = false;

    status = "";
    if (GetStorage() != NULL)
        res = ((TStorageNoSql*)GetStorage())->StorageInitStatus(status);

    return res;
}

i64 TGeneralObject::GetStorageSize() {
    i64 res = 0;

    if (GetStorage() != NULL)
        res = ((TStorageNoSql*)GetStorage())->GetStorageSize();

    return res;
}

TString TGeneralObject::HTTP_200_OK_TextXMLUTF8(float rating, TRateSrvc::TTypeInstance type_instance, ui8 hash_one, ui64 hash_two) {
    TString text = "";

    text = text + "Status: 200 OK\r\n";
    //text = text + "Server: " + m_servername + "\r\n";
    text = text + "Server: " + GetServerVersion() + "\r\n";
    text = text + "Content-type: text/xml; charset=utf-8\r\n";
    text = text + "Rate: " + FloatToStr0(rating) + "\r\n";
    text = text + "TYPEINST: " + InstanceTypeToStroka(type_instance) + "\r\n";
    text = text + "HashOne: " + IntToStroka(hash_one) + "\r\n";
    text = text + "HashTwo: " + ShingleToStroka2(hash_two) + "\r\n";
    text = text + "SrvCode: " + GetServerCode() + "\r\n";
    text = text + "\r\n";

    return text;
}

void TGeneralObject::AddTraccertData(const chkfrm::TDelayClass& delays) {
    TString tstr = "";

    traccert_stat.AddTick("*CHK", delays.check_delay);

    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV", delays.check_delay - delays.resolv_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RBLRUL", delays.check_delay - delays.rblrule_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo SPST", delays.check_delay - delays.spamstat_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo LONGSTOR", delays.check_delay - delays.get_longip_stat_tick);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo LONGSTOR_PHONE", delays.check_delay - delays.get_longphone_stat_tick);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & RBLRUL", delays.check_delay - delays.resolv_delay - delays.rblrule_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & SPST", delays.check_delay - delays.resolv_delay - delays.spamstat_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & LONGSTOR", delays.check_delay - delays.resolv_delay - delays.get_longip_stat_tick);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & LONGSTOR_PHONE", delays.check_delay - delays.resolv_delay - delays.get_longphone_stat_tick);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & RBLRUL & SPST & LONGSTOR", delays.check_delay - delays.resolv_delay - delays.rblrule_delay - delays.spamstat_delay - delays.get_longip_stat_tick);

    if (delays.geo_delay_pr)
        traccert_stat.AddTick("GEO", delays.geo_delay);
    if (delays.geo_delay_ok)
        traccert_stat.AddTick("GEO_OK <b>[CNT]</b>", 0);

    if (delays.spamstat_delay_pr) {
        traccert_stat.AddTick("SPST", delays.spamstat_delay);
        if (delays.spamstat_delay_exist)
            traccert_stat.AddTick("SPST (exist_data) <b>[CNT]</b>", 0);
        if (delays.spamstat_today_ban)
            traccert_stat.AddTick("SPST (today_ban) <b>[CNT]</b>", 0);
        if (delays.spamstat_yesterday_ban)
            traccert_stat.AddTick("SPST (yesterday_ban) <b>[CNT]</b>", 0);
        if (delays.spamstat_exist_host)
            traccert_stat.AddTick("SPST (exist_host) <b>[CNT]</b>", 0);
        if (delays.spamstat_exist_geo)
            traccert_stat.AddTick("SPST (exist_geo) <b>[CNT]</b>", 0);
    }

    if (delays.resolv_delay_pr)
        traccert_stat.AddTick("RSLV", delays.resolv_delay);
    if (delays.resolv_delay_ok)
        traccert_stat.AddTick("RSLV OK <b>[CNT]</b>", 0);

    if (delays.is_black_login)
        traccert_stat.AddTick("LST:BLACK_LOGIN <b>[CNT]</b>", 0);
    if (delays.is_white_login)
        traccert_stat.AddTick("LST:WHITE_LOGIN <b>[CNT]</b>", 0);
    if (delays.is_max_mess_from_login)
        traccert_stat.AddTick("LST:MAX_MESS_FROM_LOGIN <b>[CNT]</b>", 0);

    if (delays.antiddos_action)
        traccert_stat.AddTick("ANTIDDOS:ACTION <b>[CNT]</b>", 0);
    if (delays.antiddos_ip)
        traccert_stat.AddTick("ANTIDDOS:IP <b>[CNT]</b>", 0);
    if (delays.antiddos_xmpp_srv)
        traccert_stat.AddTick("ANTIDDOS:XMPPSERV <b>[CNT]</b>", 0);
    if (delays.antiddos_login)
        traccert_stat.AddTick("ANTIDDOS:LOGIN <b>[CNT]</b>", 0);
    if (delays.antiddos_subj)
        traccert_stat.AddTick("ANTIDDOS:SUBJECT <b>[CNT]</b>", 0);
    if (delays.antiddos_nick)
        traccert_stat.AddTick("ANTIDDOS:NICK <b>[CNT]</b>", 0);
    if (delays.antiddos_comment)
        traccert_stat.AddTick("ANTIDDOS:COMMENT <b>[CNT]</b>", 0);

    if (delays.updmsearchfound)
        traccert_stat.AddTick("UPDATE_MSEARCH_FOUND", delays.updmsearchfound_tick);

    if (delays.get_longip_stat)
        traccert_stat.AddTick("LIP:GET_LONGIP_STAT", delays.get_longip_stat_tick);

    if (delays.get_longphone_stat)
        traccert_stat.AddTick("LIP:GET_LONGPHONE_STAT", delays.get_longphone_stat_tick);

    if (delays.updlongipstat)
        traccert_stat.AddTick("LIP:UPDATE_LONGIP_STAT", delays.updlongipstat_tick);

    if (delays.updlongphonestat)
        traccert_stat.AddTick("LIP:UPDATE_LONGPHONE_STAT", delays.updlongphonestat_tick);

    if (delays.parse_host_email_phone)
        traccert_stat.AddTick("PARSE_HOST_EMAIL_PHONE", delays.parse_host_email_phone_tick);

    if (delays.get_from_storage)
        traccert_stat.AddTick("TY:GET_FROM_STORAGE", delays.get_from_storage_tick);
    if (delays.upd_to_storage)
        traccert_stat.AddTick("TY:UPDATE_TO_STORAGE", delays.upd_to_storage_tick);

    if (delays.get_filter_ok)
        traccert_stat.AddTick("FW:FILTER_GET_OK", delays.get_filter_ok_tick);
    if (delays.get_filter_failed)
        traccert_stat.AddTick("FW:FILTER_GET_FAIL", delays.get_filter_failed_tick);
    if (delays.filterwork)
        traccert_stat.AddTick("FW:FILTER_WORK", delays.filterwork_delay);
    if (delays.writedlvlog)
        traccert_stat.AddTick("FW:WRTDLV (write dlv-log)", delays.writedlvlog_delay);

    if (delays.ipstat_collision_count > 0)
        traccert_stat.AddTick("RQST_WITH_IPSTAT_COLLISION <b>[CNT]</b>", 0);

    if (delays.service_stat_collision_count > 0)
        traccert_stat.AddTick("RQST_WITH_SRVCSTAT_COLLISION <b>[CNT]</b>", 0);

    if (delays.shingles_collision_count > 0)
        traccert_stat.AddTick("RQST_WITH_SHIN_COLLISION <b>[CNT]</b>", 0);
}

/*TSummaryStatistik TGeneralObject::GetStatistic()
{
   TSummaryStatistik res;

   if (GetFilter() != NULL)
   {
      if (GetFilter()->GetFilterPool() != NULL)
         res.renginepool = GetFilter()->GetFilterPool()->GetStat();

      GetFilter()->GetStat(res.storage_counters);

      res.allow_user_count  = GetFilter()->AllowUserCount();

   }

   return res;
}*/

/*TString TGeneralObject::GetLongStorCacheStatS()
{
   TString res = "";

   if (GetStorage() != NULL)
      res = ((TStorageNoSql *)GetStorage())->GetLongStorCacheStatS();

   return res;
}*/

TResetResponceCF TGeneralObject::Reset() {
    TResetResponceCF res;

    if (m_filter != NULL) //������ ���������� ������������ � FilterPool
        res = m_filter->ReloadRules();

    return res;
}

TString TGeneralObject::GetTraccertStatWeb() {
    TString res = "";

    res += "Create report: " + TimeToStr(time(NULL)) + "<br><br>";

    res += "<i><b>Forecast:</b></i>";
    res += traccert_stat_forecast.GetWebData();
    res += "<br>";

    res += "<i><b>Reality:</b></i>";
    res += traccert_stat.GetWebData();
    res += "<br>";

    return res;
}

void TGeneralObject::WriteToLogBig(const TLogStatus LogLevel, const char* msg, ...) {
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL)) {
        char* tbuff = NULL;
        int tbuffsize = 64000;
        TString rid = "S";
        va_list args;

        tbuff = new char[tbuffsize];
        if (tbuff != NULL) {
            memset(tbuff, 0, tbuffsize);
            va_start(args, msg);
            vsnprintf(tbuff, tbuffsize - 1, msg, args);
            va_end(args);

            switch (LogLevel) {
                case KMESSAGE:
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%17s\t%s", rid.c_str(), tbuff);
                    break;
                case KWARNING:
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "%17s\t%s", rid.c_str(), tbuff);
                    break;
                case KERROR:
                    GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%17s\t%s", rid.c_str(), tbuff);
                    break;
                default:
                    break;
            }

            delete[] tbuff;
            tbuff = NULL;
        }
    }
}

bool TGeneralObject::ReloadServiceList() {
    bool res = false;
    TString s = "";

    if (config != NULL) {
        res = true; // config->ReloadKey("server", "allowservices");
        if (res) {
            s = config->ReadStroka("server", "allowservices", "");
            if (AllowService != NULL)
                res = AllowService->LoadServices(s);
        }
    }

    return res;
}

int TGeneralObject::CheckCF(TReqParams* ReqParams, const NJson::TJsonValue& js, bool& Spam, const TString& id, chkfrm::TDelayClass& DelayClass, TString& service, TString& formname, bool& Skeep, bool& dirtyword, bool& banrule, TCheckformResponceType& format, TAntiDDOSCriterionInfo& antiddos, TMaybe<TReceipt>& receipt) {
    int res = false;

    if (m_filter != NULL) {
        res = m_filter->Chec2(ReqParams, js, Spam, id, DelayClass, service, formname, Skeep, dirtyword, banrule, format, antiddos, receipt);
        AddTraccertData(DelayClass);
    }

    return res;
}

TStoreBase* TGeneralObject::GetStorage() {
    TStoreBase* res = NULL;

    if (m_groupfilter != NULL)
        res = m_groupfilter->GetCommonStore();

    return res;
}

TString TGeneralObject::GetServicesStatistik() {
    TString res = "";

    if (m_filter != NULL)
        res = m_filter->GetServicesStatistik();

    return res;
}

//******************************************************************************************************************************************
