#pragma once

#include <mail/so/spamstop/tools/fcgiserver_base/tgeneralserviceobject.h>
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/spamstop/tools/fcgiserver_base/tratesrvc.h>
#include <mail/so/spamstop/tools/fcgiserver_base/sotypes.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tlogsgroup_cf.h"
#include "tstoragenosql.h"
#include "trqstlimit.h"
#include "tconsolestat.h"
#include "ttraccert_stat.h"
#include "tcheckform_types.h"
#include "tdelaysstorage.h"
#include "tgroupfilter.h"
#include "sofilter_cf.h"
#include "tsignatureclass.h"
#include "traccert.h"

//******************************************************************************************************************************************
//                                                       TGeneralObject
//******************************************************************************************************************************************

class TGeneralObject : public TGeneralServiceObject {
private:
    TServiceType m_service_type;
    STORAGETYPE m_storagetype;
    TLogsGroupBase* LogsGroup;
    TKConfig* config;
    TString server_id;
    TMakeRequestLimit LimitObj;
    trcstat::TTraccertStat traccert_stat_forecast;
    trcstat::TTraccertStat traccert_stat;
    ui32 m_last_update_stat_to_database;

    TLogsGroupCF* GetLogsGroup();
    TKConfig* GetConfigObject() {
        return config;
    }

    TDelaysStorageMain* m_delaysstorage;
    TSignatureClass* m_signhash;
    TGroupFilter* m_groupfilter;
    TTrafficControl m_check_tc;
    CSoFilterCF* m_filter;

    TAllowService* AllowService;
    TKIniFile* FieldCheck;
    TKIniFile* LoginCheck;
    TKIniFile* AntiDDOSCheck;

    ui32 last_write_mondata;
    void WriteStatToLog();

    ui32 m_last_write_console_stat;
    ui32 m_last_read_console_stat;
    ui32 m_last_write_dump;

    void WriteToLogBig(const TLogStatus LogLevel, const char* msg, ...);

public:
    TGeneralObject();
    ~TGeneralObject();

    bool InitBeforeFork(const TString& server_idA, TLogsGroupBase* LogsGroupA, TKConfig* configA);
    bool InitAfterFork();

    bool Midnight();
    bool Shutdown();
    void EventTick();
    bool Close();

    bool WriteDump(ui32& collection_count, ui32& record_count);
    bool ReadDump(ui32& collection_count, ui32& record_count);
    bool ListDump(ui32& collection_count, ui32& record_count);

    TServiceType GetServiceType() {
        return m_service_type;
    }
    TMakeRequestLimit* GetLimitObj() {
        return &LimitObj;
    }
    TGroupFilter* GetGroupFilter() {
        return m_groupfilter;
    }
    TDelaysStorageMain* GetDelaysStorage() {
        return m_delaysstorage;
    }

    TString GetPutQueueProperties();

    TString GetStorageIdent();
    TString GetDriverProperties();
    TString GetStorageWebStatistik();
    TString GetReadCacheStatistik();
    TString GetPutQueueStatistik();
    TString GetStorageTraccertStatistik();
    TString GetStorageMonStatistik();
    TString GetUpdateQueueWebStatistik();
    TConsoleStatData GetLocalConsoleStat();
    void WriteConsoleStatToStorage();
    ui32 GetServersStatistik(TConsoleStatDataList& servers_stats);
    TString GetServersStatistikText(ui32& stor_tick);
    void GetServersStatistikAuto();
    ui32 GetLastUpdateStatistikToBD() {
        return m_last_update_stat_to_database;
    }

    bool StorageInitStatus(TString& status);
    i64 GetStorageSize();

    TTrafficControl* GetCheckTC() {
        return &m_check_tc;
    }
    CSoFilterCF* GetFilter() {
        return m_filter;
    }
    TString HTTP_200_OK_TextXMLUTF8(float rating, TRateSrvc::TTypeInstance type_instance, ui8 hash_one, ui64 hash_two);

    TString GetTraccertStatWeb();
    void AddTraccertData(const chkfrm::TDelayClass& delays);

    int CheckCF(TReqParams* ReqParams, const NJson::TJsonValue& js, bool& Spam, const TString& id, chkfrm::TDelayClass& DelayClass, TString& service, TString& formname, bool& Skeep, bool& dirtyword, bool& banrule, TCheckformResponceType& format, TAntiDDOSCriterionInfo& antiddos, TMaybe<TReceipt>& receipt);
    bool ReloadServiceList();
    TResetResponceCF Reset();

    TStoreBase* GetStorage();

    TString GetServicesStatistik();
};

//******************************************************************************************************************************************
